package html;

import java.util.Vector;
import java.awt.*;

class HtmlPagerItem
{
  protected final static int TOP = 1;
  protected final static int MIDDLE = 0;
  protected final static int BOTTOM = -1;

  private Color color = null;
  private int length = 0;
  private HtmlImage image = null;
  private int align = 0;
  private Font font = null;
  private String text = null;

  protected HtmlPagerItem(Color color, int length)
  {
    this.color = color;
    this.length = length;
  }

  protected HtmlPagerItem(Color color, HtmlImage image, int align)
  {
    this.color = color;
    this.image = image;
    this.align = align;
  }

  protected HtmlPagerItem(Color color, Font font, String text)
  {
    this.color = color;
    this.font = font;
    this.text = text;
  }

  protected int getAscent(FontMetrics fm)
  {
    if (font != null)
    {
      return fm.getMaxAscent();
    }
    else if (image != null)
    {
      int h = image.h;
      if (color != null)
	h += 2;
      switch (align)
      {
      case TOP: return -1;
      case MIDDLE: return h / 2;
      case BOTTOM: return h;
      }
      return 0;
    }
    else
    {
      return 7;
    }
  }

  protected int getHeight(FontMetrics fm)
  {
    if (font != null)
    {
      return fm.getHeight();
    }
    else if (image != null)
    {
      if (color != null)
        return image.h + 2;
      else
        return image.h;
    }
    else
    {
      return 14;
    }
  }

  protected void draw(Graphics g, int x, int y, int ascent, Vector imgs)
  {
    g.setColor(color);
    if (font != null)
    {
      g.setFont(font);
      g.drawString(text, x, y);
    }
    else if (image != null)
    {
      int h = image.h;
      if (color != null)
	h += 2;
      switch (align)
      {
      case TOP: y -= ascent; break;
      case MIDDLE: y -= h / 2; break;
      case BOTTOM: y -= h; break;
      default: return;
      }
      if (color != null)
      {
	g.drawRect(x, y, image.w + 2, h);
	x++;
	y++;
      }
      image.x = x;
      image.y = y;
      imgs.addElement(image);
    }
    else
    {
      g.drawLine(x, y, x + length, y);
    }
  }
}
