package jacob.tool;

import ccl.awt.AWTUtil;
import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Util;

import jacob.JacobConstants;

import java.io.File;
import java.util.Date;

/**
 * Creates Main.java and
 * ViewController.java.
 * 
 * @author  Chr. Clemens Lahme
 * @version $Id: ApplicationWizard.java,v 1.1 1998/12/18 12:39:22 clemens Exp clemens $
 */
public class ApplicationWizard extends WrapperAdapter 
                               implements JacobConstants
{
    public ApplicationWizard() {
        super();
    }

    public void run() {
        // get project name and package
        Init pInit = _pJacobInterface.getInit();
        String sProjectPath = pInit.getFilePath();
        Util.debug( "ApplicationWizard.run().sProjectPath: " +
                    sProjectPath );
        if ( sProjectPath.charAt( sProjectPath.length() - 1 ) ==
             File.separatorChar ) 
        {
            sProjectPath = sProjectPath.substring
                   ( 0, sProjectPath.length() - 1 );
        }
        Util.debug( "ApplicationWizard.run().sProjectPath: " +
                    sProjectPath );
        String sProjectPackage = sProjectPath.substring
               ( sProjectPath.lastIndexOf( File.separatorChar ) + 1 );
        Util.debug( "ApplicationWizard.run().sProjectPackage: " +
                    sProjectPackage );

        // first test if Main.java and
        // ViewController.java do not already
        // exist
        String sIndexFullFileName = 
               FileUtil.concatPath( sProjectPath, 
                                    "doc" + File.separator +
                                    "index.html" );
        if ( FileUtil.exists
             ( FileUtil.concatPath( sProjectPath, "Main.java" ) ) ||
             FileUtil.exists( FileUtil.concatPath
                              ( sProjectPath, "ViewController.java" ) ) ||
             FileUtil.exists( sIndexFullFileName ) )
        {
            /*AWTUtil.showMessage( _pJacobInterface.getMainFrame(),
                                 "Either\n" +
                                 "Main.java, ViewController.java, or doc/index.html\n" +
                                 "do already exists.\n" +
                                 "Therefore no files will be created." );

            super.run();

            return;*/
        }

        // write Main.java and ViewController.java
        String sJavadocAuthor = pInit.getKeyValue(S_INIT_JAVADOC_AUTHOR);
        String sMain = "package " + sProjectPackage + ";\n\n" +
               "import ccl.util.Util;\n\n" +
               "/**\n"+
               " *\n" +
               " *\n" +
               " * @author " + sJavadocAuthor + "\n" +
               " * @version $Header: /home/clemens/src/java/jacob/tool/RCS/ApplicationWizard.java,v 1.1 1998/12/18 12:39:22 clemens Exp clemens $\n" +
               " */\n" +
               "public class Main {\n" +
               "    public Main() {\n" +
               "\tsuper();\n" +
               "    }\n" +
               "\n" +
               "    public static void main( String[] asArg_ ) {\n" +
               "\tUtil.setDebug( false );\n" +
               "\tViewController pViewController = new ViewController\n" +
               "\t       ( asArg_, \"$Header: " + 
               sProjectPath + File.separator + "RCS" + 
               File.separator + "Main.java 1.0 " +
               Util.getStandardDate( new Date() ) + " " +
               Util.getTime( new Date() ) + " anonymous Exp anonymous" +
               " $\" );\n" +
               "\n" +
               "\tpViewController.start();\n" +
               "\n" +
               "\tSystem.exit( 0 );\n" +
               "    }\n" +
               "}\n";
        String sViewController = "package " + sProjectPackage + ";\n" +
               "\n" +
               "import java.awt.event.ActionEvent;\n" +
               "import java.awt.event.ActionListener;\n" +
               "import java.util.Vector;\n" +
               "\n" +
               "import javax.swing.SwingUtilities;\n" +
               "\n" +               
               "import ccl.awt.AWTUtil;\n" +
               "import ccl.swing.MainJFrame;\n" +
               "import ccl.util.Util;\n" +
               "\n" +
               "/**\n"+
               " *\n" +
               " *\n" +
               " * @author " + sJavadocAuthor + "\n" +
               " * @version $Id: ApplicationWizard.java,v 1.1 1998/12/18 12:39:22 clemens Exp clemens $\n" +
               " */\n" +
               "public class ViewController extends MainJFrame\n" +
               "                            implements ActionListener\n" +
               "{\n" +
               /*"    private static final String S_MF_OPEN = \"Open...\";\n" +*/
               "\n" +
               "    private void _setTitle() {\n" +
               "\tsetTitle( \"" + pInit.getFileName() + "\" );\n" +
               "    }\n" +
               "\n" + 
               "    private void _setMenuBar() {\n" +
               "\tVector vMenus = new Vector();\n" +
               "\tVector vFileMenu = new Vector();\n" +
               "\tVector vHelpMenu = new Vector();\n" +
               "\n" +
               "\tvFileMenu.addElement( \"File\" );\n" +
               /*"\tvFileMenu.addElement( S_MF_OPEN );\n" +*/
               "\tvFileMenu.addElement( \"Exit\" );\n" +
               "\n" +
               "\tvHelpMenu.addElement( \"Help\" );\n" +
               "\tvHelpMenu.addElement( \"Contents...\" );\n" +
               "\tvHelpMenu.addElement( \"-----\" );\n" +
               "\tvHelpMenu.addElement( \"About...\" );\n" +
               "\n" +
               "\tvMenus.addElement( vFileMenu );\n" +
               "\tvMenus.addElement( vHelpMenu );\n" +
               "\n" + 
               "\tsetMenuBar( vMenus );\n" +
               "    }\n" +
               "\n" +
               "    public ViewController( String[] asArg_, String sRCSHeader_ ) {\n" +
               "\tsuper( \"" + pInit.getFileName() + "\",\n" +
               "\t       asArg_, sRCSHeader_ );\n" +
               "\n" +
               "\tif ( isExitSet() ) {\n" +
               "\t    return;\n" +
               "\t}\n" +
               "\n" +
               "\t_setTitle();\n" +
               "\t_setMenuBar();\n" +
               "\tpack();" +
               "\tAWTUtil.maximizeWindow( this );\n" +
               "\tshow();\n" +
               "\tSwingUtilities.invokeLater( new Runnable() {\n" +
               "\t    public void run() {\n" +
               "\t\tAWTUtil.maximizeWindow( ViewController.this );\n" +
               "\t\tUtil.sleep( 1 );\n" +
               "\t\tAWTUtil.maximizeWindow( ViewController.this );\n" +
               "\t    }\n" +
               "\t} );\n" +
               "    }\n" +
               "}\n";
        String sIndex = "<html>\n" +
               "   <head>\n" +
               "      <title>" + pInit.getFileName() + "</title>\n" +
               "   </head>\n" +
               "   <body>\n" +
               "      <h1>" + pInit.getFileName() + "</h1>\n" +
               (new Date()) + "<p>\n" + 
               "No documentation here yet.\n" +
               "   </body>\n" +
               "</html>\n";


        String sMainFullFileName = FileUtil.concatPath( sProjectPath, "Main.java" );
        try {
            FileUtil.writeFile( sMainFullFileName,
                                sMain );
        } catch( Exception excMain ) {
            AWTUtil.showMessage( _pJacobInterface.getMainFrame(),
                                 "Error while writing file\n'" +
                                 sMainFullFileName +
                                 "'!" );
            super.run();

            return;
        }
        String sViewControllerFullFileName = 
               FileUtil.concatPath( sProjectPath, 
                                    "ViewController.java" );
        try {
            FileUtil.writeFile( sViewControllerFullFileName,
                                sViewController );
        } catch( Exception excMain ) {
            AWTUtil.showMessage( _pJacobInterface.getMainFrame(),
                                 "Error while writing file\n'" +
                                 sViewControllerFullFileName +
                                 "'!" );
            super.run();

            return;
        }
        try {
            FileUtil.writeFile( sIndexFullFileName,
                                sIndex );
        } catch( Exception excMain ) {
            AWTUtil.showMessage( _pJacobInterface.getMainFrame(),
                                 "Error while writing file\n'" +
                                 sIndexFullFileName +
                                 "'!" );
            super.run();

            return;
        }


        // add them to project

        // hack to stop tool
        super.run();
    }
}
