/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.address;

import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.AddressAbstract;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete an address."})
public class DeleteAddress
extends AddressAbstract {
    @CommandLine.Option(names={"--force"}, description={"Delete the address even if it has queues. All messages in those queues will be deleted! Default: false."})
    private Boolean force = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.deleteAddress(context);
        return null;
    }

    private void deleteAddress(ActionContext context) throws Exception {
        this.performCoreManagement(message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"deleteAddress", (Object[])new Object[]{this.getName(true), this.force}), reply -> context.out.println("Address " + this.getName(true) + " deleted successfully."), reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            context.err.println("Failed to delete address " + this.getName(true) + ". Reason: " + errMsg);
        });
    }

    public void setForce(Boolean force) {
        this.force = force;
    }
}

