/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.csvinput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hop.core.util.Utils;
import org.apache.hop.pipeline.transforms.csvinput.IFieldsMapping;

public class NamedFieldsMapping
implements IFieldsMapping {
    private final int[] actualToMetaFieldMapping;

    public NamedFieldsMapping(int[] actualToMetaFieldMapping) {
        this.actualToMetaFieldMapping = actualToMetaFieldMapping;
    }

    @Override
    public int fieldMetaIndex(int index) {
        if (index >= this.size() || index < 0) {
            return -1;
        }
        return this.actualToMetaFieldMapping[index];
    }

    @Override
    public int size() {
        return this.actualToMetaFieldMapping.length;
    }

    public static NamedFieldsMapping mapping(String[] actualFieldNames, String[] metaFieldNames) {
        int i;
        LinkedHashMap<String, List> metaNameToIndex = new LinkedHashMap<String, List>();
        ArrayList<Integer> unmatchedMetaFields = new ArrayList<Integer>();
        int[] actualToMetaFieldMapping = new int[actualFieldNames == null ? 0 : actualFieldNames.length];
        for (i = 0; i < metaFieldNames.length; ++i) {
            List coll = metaNameToIndex.getOrDefault(metaFieldNames[i], new ArrayList());
            coll.add(i);
            metaNameToIndex.put(metaFieldNames[i], coll);
        }
        if (actualFieldNames != null) {
            for (i = 0; i < actualFieldNames.length; ++i) {
                List columnIndexes = (List)metaNameToIndex.get(actualFieldNames[i]);
                if (Utils.isEmpty((Collection)columnIndexes)) {
                    unmatchedMetaFields.add(i);
                    actualToMetaFieldMapping[i] = -1;
                    continue;
                }
                actualToMetaFieldMapping[i] = (Integer)columnIndexes.remove(0);
            }
        }
        Iterator remainingMetaIndexes = metaNameToIndex.values().stream().flatMap(Collection::stream).sorted().iterator();
        Iterator iterator = unmatchedMetaFields.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            if (!remainingMetaIndexes.hasNext()) break;
            actualToMetaFieldMapping[idx] = (Integer)remainingMetaIndexes.next();
        }
        return new NamedFieldsMapping(actualToMetaFieldMapping);
    }
}

