/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.staxpoi;

import javax.xml.stream.XMLInputFactory;
import org.apache.poi.ss.SpreadsheetVersion;

public class StaxUtil {
    private static final SpreadsheetVersion DEFAULT_SPREADSHEET_VERSION = SpreadsheetVersion.EXCEL2007;
    public static final int MAX_ROWS = DEFAULT_SPREADSHEET_VERSION.getMaxRows();
    public static final int MAX_COLUMNS = DEFAULT_SPREADSHEET_VERSION.getMaxColumns();

    private StaxUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static int extractRowNumber(String position) {
        int startIndex;
        for (startIndex = 0; !Character.isDigit(position.charAt(startIndex)) && startIndex < position.length(); ++startIndex) {
        }
        String rowPart = position.substring(startIndex);
        return Integer.parseInt(rowPart);
    }

    public static int extractColumnNumber(String position) {
        int startIndex;
        for (startIndex = 0; !Character.isDigit(position.charAt(startIndex)) && startIndex < position.length(); ++startIndex) {
        }
        String colPart = position.substring(0, startIndex);
        return StaxUtil.parseColumnNumber(colPart);
    }

    public static final int parseColumnNumber(String columnIndicator) {
        int col = 0;
        for (int i = columnIndicator.length() - 1; i >= 0; --i) {
            char c = columnIndicator.charAt(i);
            int offset = 1 + Character.getNumericValue(c) - Character.getNumericValue('A');
            col = (int)((double)col + Math.pow(26.0, (double)(columnIndicator.length() - i) - 1.0) * (double)offset);
        }
        return col;
    }

    public static final XMLInputFactory safeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        return factory;
    }
}

