/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;

class HCSUserInfoReplyDS
extends ClientAccessDataStream {
    HCSUserInfoReplyDS() {
    }

    @Override
    public Object getNewDataStream() {
        return new HCSUserInfoReplyDS();
    }

    int getRC() {
        return this.get32bit(20);
    }

    GregorianCalendar getCurrentSignonDate() {
        return this.getDate(4358);
    }

    GregorianCalendar getLastSignonDate() {
        return this.getDate(4359);
    }

    GregorianCalendar getExpirationDate() {
        return this.getDate(4360);
    }

    int getPWDExpirationWarning() {
        int offset = this.findCP(4396);
        if (offset == -1) {
            return -1;
        }
        return this.get32bit(this.findCP(4396) + 6);
    }

    int findCP(int cp) {
        for (int offset = 24; offset < this.data_.length - 1; offset += this.get32bit(offset)) {
            if (this.get16bit(offset + 4) != cp) continue;
            return offset;
        }
        return -1;
    }

    GregorianCalendar getDate(int cp) {
        GregorianCalendar date = null;
        for (int offset = 24; offset < this.data_.length - 1; offset += this.get32bit(offset)) {
            if (this.get16bit(offset + 4) != cp) {
                continue;
            }
            date = new GregorianCalendar(this.get16bit(offset + 6), this.data_[offset + 8] - 1, this.data_[offset + 9], this.data_[offset + 10], this.data_[offset + 11], this.data_[offset + 12]);
            break;
        }
        return date;
    }

    int getServerCCSID() {
        int ccsid = 0;
        for (int offset = 24; offset < this.data_.length - 1; offset += this.get32bit(offset)) {
            if (this.get16bit(offset + 4) != 4372) {
                continue;
            }
            ccsid = this.get32bit(offset + 6);
            break;
        }
        return ccsid;
    }

    AS400Message[] getErrorMessages(ConverterImplRemote converter) throws IOException {
        return AS400ImplRemote.parseMessages(this.data_, 24, converter);
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving retrieve signon information reply...");
        }
        if (this.readFromStream(in, header = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the retrieve signon information reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 20);
        this.readAfterHeader(in);
    }

    @Override
    public int hashCode() {
        return 61700;
    }
}

