/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import java.util.concurrent.ExecutorService;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.storage.GcsPathValidator;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExecutorOptions;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface GcsOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions {
    @JsonIgnore
    @Description(value="The GcsUtil instance that should be used to communicate with Google Cloud Storage.")
    @Default.InstanceFactory(value=GcsUtil.GcsUtilFactory.class)
    @Hidden
    public @UnknownKeyFor @NonNull @Initialized GcsUtil getGcsUtil();

    public void setGcsUtil(@UnknownKeyFor @NonNull @Initialized GcsUtil var1);

    @JsonIgnore
    @Description(value="The GoogleCloudStorageReadOptions instance that should be used to read from Google Cloud Storage.")
    @Default.InstanceFactory(value=GcsUtil.GcsReadOptionsFactory.class)
    @Hidden
    public @UnknownKeyFor @NonNull @Initialized GoogleCloudStorageReadOptions getGoogleCloudStorageReadOptions();

    public void setGoogleCloudStorageReadOptions(@UnknownKeyFor @NonNull @Initialized GoogleCloudStorageReadOptions var1);

    @JsonIgnore
    @Default.InstanceFactory(value=ExecutorServiceFactory.class)
    @Hidden
    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized ExecutorService getExecutorService();

    @Deprecated
    public void setExecutorService(@UnknownKeyFor @NonNull @Initialized ExecutorService var1);

    @JsonIgnore
    @Hidden
    @Description(value="The URL for the GCS API.")
    public @UnknownKeyFor @NonNull @Initialized String getGcsEndpoint();

    public void setGcsEndpoint(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The buffer size (in bytes) to use when uploading files to GCS. Please see the documentation for AsyncWriteChannelOptions.getUploadChunkSize for more information on the restrictions and performance implications of this value.\n\nhttps://github.com/GoogleCloudPlatform/bigdata-interop/blob/master/util/src/main/java/com/google/cloud/hadoop/util/AsyncWriteChannelOptions.java")
    public @Nullable @UnknownKeyFor @Initialized Integer getGcsUploadBufferSizeBytes();

    public void setGcsUploadBufferSizeBytes(@Nullable @UnknownKeyFor @Initialized Integer var1);

    @Description(value="The class of the validator that should be created and used to validate paths. If pathValidator has not been set explicitly, an instance of this class will be constructed and used as the path validator.")
    @Default.Class(value=GcsPathValidator.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PathValidator> getPathValidatorClass();

    public void setPathValidatorClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PathValidator> var1);

    @JsonIgnore
    @Description(value="The path validator instance that should be used to validate paths. If no path validator has been set explicitly, the default is to use the instance factory that constructs a path validator based upon the currently set pathValidatorClass.")
    @Default.InstanceFactory(value=PathValidatorFactory.class)
    public @UnknownKeyFor @NonNull @Initialized PathValidator getPathValidator();

    public void setPathValidator(@UnknownKeyFor @NonNull @Initialized PathValidator var1);

    @Description(value="Whether to report performance metrics of certain GCS operations.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getGcsPerformanceMetrics();

    public void setGcsPerformanceMetrics(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Read timeout for gcs http requests")
    public @Nullable @UnknownKeyFor @Initialized Integer getGcsHttpRequestReadTimeout();

    public void setGcsHttpRequestReadTimeout(@Nullable @UnknownKeyFor @Initialized Integer var1);

    @Description(value="Write timeout for gcs http requests.")
    public @Nullable @UnknownKeyFor @Initialized Integer getGcsHttpRequestWriteTimeout();

    public void setGcsHttpRequestWriteTimeout(@Nullable @UnknownKeyFor @Initialized Integer var1);

    @Description(value="Batching limit for rewrite ops which will copy data.")
    public @Nullable @UnknownKeyFor @Initialized Integer getGcsRewriteDataOpBatchLimit();

    public void setGcsRewriteDataOpBatchLimit(@Nullable @UnknownKeyFor @Initialized Integer var1);

    @Description(value="Whether to report number of bytes written per GCS bucket.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableBucketWriteMetricCounter();

    public void setEnableBucketWriteMetricCounter(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Whether to report number of bytes read per GCS bucket.")
    @Default.Boolean(value=false)
    public @UnknownKeyFor @NonNull @Initialized Boolean getEnableBucketReadMetricCounter();

    public void setEnableBucketReadMetricCounter(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Description(value="Prefix for the metric that counts the number of bytes read per GCS bucket. The resulting metric name will be formatted according to this template: <prefix>_<bucket_name>.")
    @Default.String(value="GCS_read_bytes_counter")
    public @UnknownKeyFor @NonNull @Initialized String getGcsReadCounterPrefix();

    public void setGcsReadCounterPrefix(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Prefix for the metric that counts the number of bytes written per GCS bucket. The resulting metric name will be formatted according to this template: <prefix>_<bucket_name>.")
    @Default.String(value="GCS_write_bytes_counter")
    public @UnknownKeyFor @NonNull @Initialized String getGcsWriteCounterPrefix();

    public void setGcsWriteCounterPrefix(@UnknownKeyFor @NonNull @Initialized String var1);

    public static class PathValidatorFactory
    implements DefaultValueFactory<PathValidator> {
        public @UnknownKeyFor @NonNull @Initialized PathValidator create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            GcsOptions gcsOptions = (GcsOptions)options.as(GcsOptions.class);
            return (PathValidator)InstanceBuilder.ofType(PathValidator.class).fromClass(gcsOptions.getPathValidatorClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, (Object)options).build();
        }
    }

    public static class ExecutorServiceFactory
    implements DefaultValueFactory<ExecutorService> {
        public @UnknownKeyFor @NonNull @Initialized ExecutorService create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return ((ExecutorOptions)options.as(ExecutorOptions.class)).getScheduledExecutorService();
        }
    }
}

