/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.EmptyScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SelectScope
extends ListScope {
    private final SqlSelect select;
    protected final List<String> windowNames = new ArrayList<String>();
    private @Nullable List<SqlNode> expandedSelectList = null;
    private @MonotonicNonNull SqlNodeList orderList;
    private final SqlValidatorScope windowParent;

    SelectScope(SqlValidatorScope parent, SqlValidatorScope windowParent, SqlSelect select) {
        super(parent);
        this.select = Objects.requireNonNull(select, "select");
        this.windowParent = Objects.requireNonNull(windowParent, "windowParent");
    }

    public @Nullable SqlValidatorTable getTable() {
        return null;
    }

    @Override
    public SqlSelect getNode() {
        return this.select;
    }

    @Override
    public @Nullable SqlWindow lookupWindow(String name) {
        SqlNodeList windowList = this.select.getWindowList();
        for (SqlWindow window : windowList) {
            SqlIdentifier declId = Objects.requireNonNull(window.getDeclName(), () -> "declName of window " + window);
            assert (declId.isSimple());
            if (!((String)declId.names.get(0)).equals(name)) continue;
            return window;
        }
        return this.windowParent.lookupWindow(name);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        SqlMonotonicity monotonicity = expr.getMonotonicity(this);
        if (monotonicity != SqlMonotonicity.NOT_MONOTONIC) {
            return monotonicity;
        }
        SqlNodeList orderList = this.getOrderList();
        if (!orderList.isEmpty()) {
            SqlNode order0 = orderList.get(0);
            monotonicity = SqlMonotonicity.INCREASING;
            if (order0 instanceof SqlCall && ((SqlCall)order0).getOperator() == SqlStdOperatorTable.DESC) {
                monotonicity = monotonicity.reverse();
                order0 = ((SqlCall)order0).operand(0);
            }
            if (expr.equalsDeep(order0, Litmus.IGNORE)) {
                return monotonicity;
            }
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlNodeList getOrderList() {
        if (this.orderList == null) {
            SqlValidatorNamespace child;
            List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;
            this.orderList = new SqlNodeList(SqlParserPos.ZERO);
            if (this.children.size() == 1 && !(monotonicExprs = (child = ((ScopeChild)this.children.get((int)0)).namespace).getMonotonicExprs()).isEmpty()) {
                this.orderList.add((SqlNode)monotonicExprs.get((int)0).left);
            }
        }
        return this.orderList;
    }

    public void addWindowName(String winName) {
        this.windowNames.add(winName);
    }

    public boolean existingWindowName(String winName) {
        for (String windowName : this.windowNames) {
            if (!windowName.equalsIgnoreCase(winName)) continue;
            return true;
        }
        SqlValidatorScope walker = this.parent;
        while (!(walker instanceof EmptyScope)) {
            if (walker instanceof SelectScope) {
                SelectScope parentScope = (SelectScope)walker;
                return parentScope.existingWindowName(winName);
            }
            walker = ((DelegatingScope)walker).parent;
        }
        return false;
    }

    public @Nullable List<SqlNode> getExpandedSelectList() {
        return this.expandedSelectList;
    }

    public void setExpandedSelectList(@Nullable List<SqlNode> selectList) {
        this.expandedSelectList = selectList;
    }
}

