/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.security.authentication.event;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite3.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite3.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite3.internal.security.authentication.basic.BasicAuthenticationProviderConfiguration;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationProviderConfiguration;
import org.apache.ignite3.internal.security.authentication.configuration.AuthenticationProviderView;
import org.apache.ignite3.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite3.internal.security.authentication.event.AuthenticationProviderEventParameters;
import org.apache.ignite3.internal.security.authentication.event.UserEventFactory;
import org.apache.ignite3.internal.security.configuration.SecurityConfiguration;
import org.apache.ignite3.internal.util.CompletableFutures;

public class AuthenticationProviderEventFactory
implements ConfigurationNamedListListener<AuthenticationProviderView> {
    private final SecurityConfiguration securityConfiguration;
    private final UserEventFactory userEventFactory;
    private final Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier;

    public AuthenticationProviderEventFactory(SecurityConfiguration securityConfiguration, UserEventFactory userEventFactory, Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier) {
        this.securityConfiguration = securityConfiguration;
        this.userEventFactory = userEventFactory;
        this.notifier = notifier;
    }

    @Override
    public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        this.onCreate(ctx.newValue());
        return CompletableFutures.nullCompletedFuture();
    }

    private void onCreate(AuthenticationProviderView providerView) {
        AuthenticationProviderConfiguration configuration;
        if ("basic".equals(providerView.type()) && (configuration = this.securityConfiguration.authentication().providers().get(providerView.name())) != null) {
            BasicAuthenticationProviderConfiguration basicCfg = (BasicAuthenticationProviderConfiguration)configuration;
            basicCfg.users().listenElements(this.userEventFactory);
        }
    }

    @Override
    public CompletableFuture<?> onRename(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        this.onCreate(ctx.newValue());
        return this.notifier.apply(AuthenticationProviderEventParameters.removed(ctx.oldValue().name()));
    }

    @Override
    public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        return this.notifier.apply(AuthenticationProviderEventParameters.removed(ctx.oldValue().name()));
    }

    @Override
    public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<AuthenticationProviderView> ctx) {
        if ("basic".equals(ctx.oldValue().type()) && ctx.oldValue().type().equals(ctx.newValue().type())) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.notifier.apply(AuthenticationProviderEventParameters.updated(ctx.newValue().name()));
    }
}

