/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.List;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

@Header(value="Accept")
public final class Accept {
    private static final Cache<String, Accept> cache = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);
    private final MediaTypeRange[] mediaRanges;
    private final List<MediaTypeRange> mediaRangesList;

    public static Accept forString(String value) {
        if (value == null) {
            return null;
        }
        Accept a = cache.get(value);
        if (a == null) {
            a = cache.put(value, new Accept(value));
        }
        return a;
    }

    private Accept(String value) {
        this.mediaRanges = MediaTypeRange.parse(value);
        this.mediaRangesList = CollectionUtils.immutableList(this.mediaRanges);
    }

    public List<MediaTypeRange> asRanges() {
        return this.mediaRangesList;
    }

    public int findMatch(MediaType[] mediaTypes) {
        MediaTypeRange mr;
        float q2;
        int matchQuant = 0;
        int matchIndex = -1;
        float q = 0.0f;
        MediaTypeRange[] mediaTypeRangeArray = this.mediaRanges;
        int n = mediaTypeRangeArray.length;
        for (int i = 0; i < n && !((q2 = (mr = mediaTypeRangeArray[i]).getQValue().floatValue()) < q) && q2 != 0.0f; ++i) {
            for (int i2 = 0; i2 < mediaTypes.length; ++i2) {
                MediaType mt = mediaTypes[i2];
                int matchQuant2 = mr.getMediaType().match(mt, false);
                if (matchQuant2 <= matchQuant) continue;
                matchIndex = i2;
                matchQuant = matchQuant2;
                q = q2;
            }
        }
        return matchIndex;
    }

    public int findMatch(MediaTypeRange[] mediaTypeRanges) {
        MediaTypeRange mr;
        float q2;
        float matchQuant = 0.0f;
        int matchIndex = -1;
        float q = 0.0f;
        MediaTypeRange[] mediaTypeRangeArray = this.mediaRanges;
        int n = mediaTypeRangeArray.length;
        for (int i = 0; i < n && !((q2 = (mr = mediaTypeRangeArray[i]).getQValue().floatValue()) < q) && q2 != 0.0f; ++i) {
            for (int i2 = 0; i2 < mediaTypeRanges.length; ++i2) {
                MediaTypeRange mt = mediaTypeRanges[i2];
                float matchQuant2 = (float)mr.getMediaType().match(mt.getMediaType(), false) * mt.getQValue().floatValue();
                if (!(matchQuant2 > matchQuant)) continue;
                matchIndex = i2;
                matchQuant = matchQuant2;
                q = q2;
            }
        }
        return matchIndex;
    }

    public boolean hasSubtypePart(String part) {
        for (MediaTypeRange mr : this.mediaRanges) {
            if (!(mr.getQValue().floatValue() > 0.0f) || mr.getMediaType().getSubTypes().indexOf(part) < 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return StringUtils.join((Object[])this.mediaRanges, ',');
    }
}

