/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.sling.maven.feature.launcher.LauncherArguments;

public class Launch {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-\\.]+");
    private String id;
    private Dependency feature;
    private String featureFile;
    private LauncherArguments launcherArguments = new LauncherArguments();
    private int startTimeoutSeconds = 30;
    private boolean skip = false;
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private List<String> repositoryUrls = new ArrayList<String>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Optional<Dependency> getFeature() {
        return Optional.ofNullable(this.feature);
    }

    public void setFeature(Dependency feature) {
        this.feature = feature;
    }

    public Optional<File> getFeatureFile() {
        return Optional.ofNullable(this.featureFile).map(File::new);
    }

    public void setFeatureFile(String featureFile) {
        this.featureFile = featureFile;
    }

    public LauncherArguments getLauncherArguments() {
        return this.launcherArguments;
    }

    public void setLauncherArguments(LauncherArguments launcherArguments) {
        this.launcherArguments = launcherArguments;
    }

    public int getStartTimeoutSeconds() {
        return this.startTimeoutSeconds;
    }

    public void setStartTimeoutSeconds(int startTimeoutSeconds) {
        this.startTimeoutSeconds = startTimeoutSeconds;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public Map<String, String> getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            return Collections.emptyMap();
        }
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public List<String> getRepositoryUrls() {
        return this.repositoryUrls;
    }

    public void setRepositoryUrls(List<String> repositoryUrls) {
        this.repositoryUrls = repositoryUrls;
    }

    public void validate() {
        boolean hasFeatureFile;
        if (this.id == null || this.id.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing id");
        }
        if (!ID_PATTERN.matcher(this.id).matches()) {
            throw new IllegalArgumentException("Invalid id '" + this.id + "'. Allowed characters are digits, numbers, '-','_' and '.'.");
        }
        if (this.startTimeoutSeconds < 0) {
            this.throwInvalid("startTimeout value '" + this.startTimeoutSeconds + "' is negative");
        }
        boolean hasFeature = this.feature != null;
        boolean bl = hasFeatureFile = this.featureFile != null && !this.featureFile.trim().isEmpty();
        if (hasFeature && hasFeatureFile) {
            this.throwInvalid("Only one of 'feature' and 'featureFile' is allowed, but both are set");
        }
        if (!hasFeature && !hasFeatureFile) {
            this.throwInvalid("Neither 'feature' nor 'featureFile' are set");
        }
        if (hasFeatureFile && !new File(this.featureFile).exists()) {
            this.throwInvalid("Feature file '" + this.featureFile + "' does not exist");
        }
        if (hasFeature && !"slingosgifeature".equals(this.feature.getType())) {
            this.throwInvalid("type must be 'slingosgifeature' but is '" + this.feature.getType() + "'");
        }
    }

    private void throwInvalid(String reason) {
        throw new IllegalArgumentException("Invalid launch '" + this.id + "': " + reason);
    }
}

