/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class OidcHandlerInterceptorAdapter
extends OAuth20HandlerInterceptorAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcHandlerInterceptorAdapter.class);
    private final ObjectProvider<HandlerInterceptor> requiresAuthenticationDynamicRegistrationInterceptor;
    private final ObjectProvider<HandlerInterceptor> requiresAuthenticationClientConfigurationInterceptor;
    private final CasConfigurationProperties casProperties;

    public OidcHandlerInterceptorAdapter(ObjectProvider<HandlerInterceptor> requiresAuthenticationAccessTokenInterceptor, ObjectProvider<HandlerInterceptor> requiresAuthenticationAuthorizeInterceptor, ObjectProvider<HandlerInterceptor> requiresAuthenticationDynamicRegistrationInterceptor, ObjectProvider<HandlerInterceptor> requiresAuthenticationClientConfigurationInterceptor, CasConfigurationProperties casProperties, ObjectProvider<List<AccessTokenGrantRequestExtractor>> accessTokenGrantRequestExtractors, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<SessionStore> sessionStore, ObjectProvider<List<OAuth20AuthorizationRequestValidator>> oauthAuthorizationRequestValidators, ObjectProvider<OAuth20RequestParameterResolver> oauthRequestParameterResolver) {
        super(requiresAuthenticationAccessTokenInterceptor, requiresAuthenticationAuthorizeInterceptor, accessTokenGrantRequestExtractors, servicesManager, sessionStore, oauthAuthorizationRequestValidators, oauthRequestParameterResolver);
        this.requiresAuthenticationDynamicRegistrationInterceptor = requiresAuthenticationDynamicRegistrationInterceptor;
        this.casProperties = casProperties;
        this.requiresAuthenticationClientConfigurationInterceptor = requiresAuthenticationClientConfigurationInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LOGGER.trace("Attempting to pre-handle OIDC request at [{}] with parameters [{}]", (Object)request.getRequestURI(), request.getParameterMap().keySet());
        if (this.casProperties.getAuthn().getOidc().getDiscovery().isRequirePushedAuthorizationRequests() && !HttpMethod.valueOf((String)request.getMethod()).equals((Object)HttpMethod.POST) && StringUtils.isBlank((CharSequence)request.getParameter("request_uri")) && this.isAuthorizationRequest(request, response)) {
            LOGGER.warn("CAS is configured to only accept pushed authorization requests and this is not a POST");
            response.setStatus(403);
            return false;
        }
        if (this.isPushedAuthorizationRequest(request.getRequestURI())) {
            LOGGER.trace("OIDC pushed authorization request is protected at [{}]", (Object)request.getRequestURI());
            return ((HandlerInterceptor)this.requiresAuthenticationAccessTokenInterceptor.getObject()).preHandle(request, response, handler);
        }
        if (this.isCibaRequest(request.getRequestURI())) {
            LOGGER.trace("OIDC CIBA request is protected at [{}]", (Object)request.getRequestURI());
            return ((HandlerInterceptor)this.requiresAuthenticationAccessTokenInterceptor.getObject()).preHandle(request, response, handler);
        }
        if (!super.preHandle(request, response, handler)) {
            LOGGER.trace("Unable to pre-handle OIDC request at [{}]", (Object)request.getRequestURI());
            return false;
        }
        if (this.isClientConfigurationRequest(request.getRequestURI())) {
            LOGGER.trace("OIDC client configuration is protected at [{}]", (Object)request.getRequestURI());
            return ((HandlerInterceptor)this.requiresAuthenticationClientConfigurationInterceptor.getObject()).preHandle(request, response, handler);
        }
        if (this.isDynamicClientRegistrationRequest(request.getRequestURI())) {
            LOGGER.trace("OIDC request at [{}] is one of dynamic client registration", (Object)request.getRequestURI());
            if (this.isDynamicClientRegistrationRequestProtected()) {
                LOGGER.trace("OIDC dynamic client registration is protected at [{}]", (Object)request.getRequestURI());
                return ((HandlerInterceptor)this.requiresAuthenticationDynamicRegistrationInterceptor.getObject()).preHandle(request, response, handler);
            }
        }
        return true;
    }

    private boolean isCibaRequest(String requestURI) {
        return this.doesUriMatchPattern(requestURI, CollectionUtils.wrapList((Object[])new String[]{"oidcCiba"}));
    }

    protected boolean isDynamicClientRegistrationRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, CollectionUtils.wrapList((Object[])new String[]{"register"}));
    }

    protected boolean isClientConfigurationRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, CollectionUtils.wrapList((Object[])new String[]{"clientConfig"}));
    }

    protected boolean isPushedAuthorizationRequest(String requestPath) {
        return this.doesUriMatchPattern(requestPath, CollectionUtils.wrapList((Object[])new String[]{"oidcPushAuthorize"}));
    }

    protected List<String> getRevocationUrls() {
        List urls = super.getRevocationUrls();
        urls.add("revoke");
        return urls;
    }

    protected List<String> getAccessTokenUrls() {
        List accessTokenUrls = super.getAccessTokenUrls();
        accessTokenUrls.add("oidcAccessToken");
        accessTokenUrls.add("oidcToken");
        return accessTokenUrls;
    }

    protected List<String> getAuthorizeUrls() {
        List urls = super.getAuthorizeUrls();
        urls.add("oidcAuthorize");
        return urls;
    }

    private boolean isDynamicClientRegistrationRequestProtected() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        return oidc.getRegistration().getDynamicClientRegistrationMode().isProtected();
    }
}

