/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.common.engine.api.FlowableException;

public class VariableListenerEventDefinitionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "variableListenerEventDefinition";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Event)) {
            throw new FlowableException("variableListenerEventDefinition is only supported for events, not for activity id " + parentElement.getId());
        }
        VariableListenerEventDefinition eventDefinition = new VariableListenerEventDefinition();
        BpmnXMLUtil.addXMLLocation((BaseElement)eventDefinition, xtr);
        String variableName = xtr.getAttributeValue(null, "variableName");
        if (StringUtils.isEmpty((CharSequence)variableName)) {
            LOGGER.warn("variable name is required for variable listener with activity id {}", (Object)parentElement.getId());
        }
        eventDefinition.setVariableName(variableName);
        String variableChangeType = xtr.getAttributeValue(null, "variableChangeType");
        eventDefinition.setVariableChangeType(variableChangeType);
        Event event = (Event)parentElement;
        event.addEventDefinition((EventDefinition)eventDefinition);
        model.addActivityIdForVariableListenerName(variableName, parentElement.getId());
    }
}

