/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.persistence.jpa.dao.repo.ClientAppRepoExt;

public abstract class AbstractClientRepoExt<C extends ClientApp>
implements ClientAppRepoExt<C> {
    protected final EntityManager entityManager;

    protected AbstractClientRepoExt(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected StringBuilder getByPolicyQuery(Class<? extends Policy> policyClass, Class<? extends C> clientAppJPAClass) {
        StringBuilder query = new StringBuilder("SELECT e FROM ").append(clientAppJPAClass.getSimpleName()).append(" e WHERE e.");
        if (AuthPolicy.class.isAssignableFrom(policyClass)) {
            query.append("authPolicy");
        } else if (AccessPolicy.class.isAssignableFrom(policyClass)) {
            query.append("accessPolicy");
        } else if (AttrReleasePolicy.class.isAssignableFrom(policyClass)) {
            query.append("attrReleasePolicy");
        } else if (TicketExpirationPolicy.class.isAssignableFrom(policyClass)) {
            query.append("ticketExpirationPolicy");
        }
        return query;
    }

    protected List<C> findAllByPolicy(Policy policy, Class<C> reference, Class<? extends C> clientAppJPAClass) {
        TypedQuery query = this.entityManager.createQuery(this.getByPolicyQuery(policy.getClass(), clientAppJPAClass).append("=:policy").toString(), reference);
        query.setParameter("policy", (Object)policy);
        return query.getResultList();
    }

    protected List<C> findAllByRealm(Realm realm, Class<C> reference, Class<? extends C> clientAppJPAClass) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + clientAppJPAClass.getSimpleName() + " e WHERE e.realm=:realm", reference);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }
}

