/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.metadata;

import com.googlecode.cqengine.index.support.CloseableIterable;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.index.support.KeyStatistics;
import com.googlecode.cqengine.index.support.KeyStatisticsIndex;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.metadata.KeyFrequency;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class AttributeMetadata<A, O> {
    private final KeyStatisticsIndex<A, O> index;
    private final Supplier<QueryOptions> openResourcesHandler;
    private final Consumer<QueryOptions> closeResourcesHandler;

    AttributeMetadata(KeyStatisticsIndex<A, O> index, Supplier<QueryOptions> openResourcesHandler, Consumer<QueryOptions> closeResourcesHandler) {
        this.index = index;
        this.openResourcesHandler = openResourcesHandler;
        this.closeResourcesHandler = closeResourcesHandler;
    }

    public Stream<KeyFrequency<A>> getFrequencyDistribution() {
        QueryOptions queryOptions = this.openResources();
        return this.asKeyFrequencyStream(queryOptions, this.index.getStatisticsForDistinctKeys(queryOptions));
    }

    public Stream<A> getDistinctKeys() {
        QueryOptions queryOptions = this.openResources();
        return this.asStream(queryOptions, this.index.getDistinctKeys(queryOptions));
    }

    public Integer getCountOfDistinctKeys() {
        QueryOptions queryOptions = this.openResources();
        try {
            Integer n = this.index.getCountOfDistinctKeys(queryOptions);
            return n;
        }
        finally {
            this.closeResources(queryOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCountForKey(A key) {
        QueryOptions queryOptions = this.openResources();
        try {
            Integer n = this.index.getCountForKey(key, queryOptions);
            return n;
        }
        finally {
            this.closeResources(queryOptions);
        }
    }

    public Stream<KeyValue<A, O>> getKeysAndValues() {
        QueryOptions queryOptions = this.openResources();
        return this.asStream(queryOptions, this.index.getKeysAndValues(queryOptions));
    }

    protected Stream<KeyFrequency<A>> asKeyFrequencyStream(QueryOptions queryOptions, CloseableIterable<KeyStatistics<A>> iterable) {
        Stream<KeyFrequency<A>> keyStatisticsStream = this.asStream(queryOptions, iterable);
        return keyStatisticsStream;
    }

    protected <T> Stream<T> asStream(QueryOptions queryOptions, CloseableIterable<T> iterable) {
        Iterator iterator = iterable.iterator();
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 16);
        return (Stream)((Stream)StreamSupport.stream(spliterator, false).onClose(((CloseableIterator)iterator)::close)).onClose(() -> this.closeResources(queryOptions));
    }

    protected QueryOptions openResources() {
        return this.openResourcesHandler.get();
    }

    protected void closeResources(QueryOptions queryOptions) {
        this.closeResourcesHandler.accept(queryOptions);
    }
}

