/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class CasSimpleMultifactorWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    public CasSimpleMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, FlowDefinitionRegistry mfaFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties, Optional.of(mfaFlowDefinitionRegistry), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        String providerId = this.casProperties.getAuthn().getMfa().getSimple().getId();
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            Flow flow = this.getFlow((FlowDefinitionRegistry)registry, providerId);
            this.createFlowVariable(flow, "credential", CasSimpleMultifactorTokenCredential.class);
            flow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
            ActionState initLoginFormState = this.createActionState(flow, "initializeLoginForm", (Action)this.createEvaluateAction("initializeLoginAction"));
            this.createTransitionForState((TransitionableState)initLoginFormState, "success", "sendSimpleToken");
            this.setStartState(flow, (TransitionableState)initLoginFormState);
            this.createEndState(flow, "success");
            this.createEndState(flow, "unavailable");
            ActionState sendSimpleToken = this.createActionState(flow, "sendSimpleToken", new String[]{"mfaSimpleMultifactorSendTokenAction"});
            this.createTransitionForState((TransitionableState)sendSimpleToken, "error", "unavailable");
            this.createTransitionForState((TransitionableState)sendSimpleToken, "success", "viewLoginForm");
            this.createTransitionForState((TransitionableState)sendSimpleToken, "select", "selectRecipientsView");
            boolean registrationEnabled = this.casProperties.getAuthn().getMfa().getSimple().getMail().isRegistrationEnabled();
            if (registrationEnabled) {
                this.createTransitionForState((TransitionableState)sendSimpleToken, "register", "recipientsRegistrationView");
            }
            ViewState selectRecipientsView = this.createViewState(flow, "selectRecipientsView", "simple-mfa/casSimpleMfaSelectRecipientsView");
            this.createTransitionForState((TransitionableState)selectRecipientsView, "select", "sendSimpleToken");
            if (registrationEnabled) {
                this.createEmailRegistrationStates(flow);
            }
            SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
            List propertiesToBind = CollectionUtils.wrapList((Object[])new String[]{"token"});
            BinderConfiguration binder = this.createStateBinderConfiguration(propertiesToBind);
            ViewState viewLoginFormState = this.createViewState(flow, "viewLoginForm", "simple-mfa/casSimpleMfaLoginView", binder);
            this.createStateModelBinding((TransitionableState)viewLoginFormState, "credential", CasSimpleMultifactorTokenCredential.class);
            viewLoginFormState.getEntryActionList().add((Action)setPrincipalAction);
            this.createTransitionForState((TransitionableState)viewLoginFormState, "submit", "realSubmit", Map.of("bind", Boolean.TRUE, "validate", Boolean.TRUE));
            this.createTransitionForState((TransitionableState)viewLoginFormState, "resend", "sendSimpleToken", Map.of("bind", Boolean.FALSE, "validate", Boolean.FALSE));
            ActionState realSubmitState = this.createActionState(flow, "realSubmit", (Action)this.createEvaluateAction("oneTimeTokenAuthenticationWebflowAction"));
            this.createTransitionForState((TransitionableState)realSubmitState, "success", "success");
            this.createTransitionForState((TransitionableState)realSubmitState, "error", "viewLoginForm");
        });
        this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), providerId);
    }

    private void createEmailRegistrationStates(Flow flow) {
        ViewState registrationView = this.createViewState(flow, "recipientsRegistrationView", "simple-mfa/casSimpleMfaRegisterRecipientsView");
        registrationView.getEntryActionList().add(ConsumerExecutionAction.EVENT_ATTRIBUTES_TO_FLOW_SCOPE);
        this.createTransitionForState((TransitionableState)registrationView, "register", "verifyEmail");
        ActionState verifyEmailState = this.createActionState(flow, "verifyEmail", new String[]{"mfaSimpleMultifactorVerifyEmailAction"});
        verifyEmailState.getEntryActionList().add(ConsumerExecutionAction.EVENT_ATTRIBUTES_TO_FLOW_SCOPE);
        this.createTransitionForState((TransitionableState)verifyEmailState, "error", registrationView.getId());
        this.createTransitionForState((TransitionableState)verifyEmailState, "success", "updateEmailRegistrationView");
        ViewState updateEmailViewState = this.createViewState(flow, "updateEmailRegistrationView", "simple-mfa/casSimpleMfaUpdateEmailRegistrationView");
        this.createTransitionForState((TransitionableState)updateEmailViewState, "submit", "updateEmailRegistration");
        this.createTransitionForState((TransitionableState)updateEmailViewState, "error", updateEmailViewState.getId());
        ActionState updateEmailRegistrationState = this.createActionState(flow, "updateEmailRegistration", new String[]{"mfaSimpleMultifactorUpdateEmailAction"});
        this.createTransitionForState((TransitionableState)updateEmailRegistrationState, "resume", "sendSimpleToken");
        this.createTransitionForState((TransitionableState)updateEmailRegistrationState, "error", updateEmailViewState.getId());
    }
}

