/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.mgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ChainingServicesManager;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.query.RegisteredServiceQuery;
import org.apereo.inspektr.audit.annotation.Audit;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class DefaultChainingServicesManager
implements ChainingServicesManager {
    private final List<ServicesManager> serviceManagers = new ArrayList<ServicesManager>();

    public void registerServiceManager(ServicesManager manager) {
        this.serviceManagers.add(manager);
        AnnotationAwareOrderComparator.sortIfNecessary(this.serviceManagers);
    }

    public void save(Stream<RegisteredService> toSave) {
        this.serviceManagers.forEach(mgr -> {
            Stream<RegisteredService> filtered = toSave.filter(arg_0 -> ((ServicesManager)mgr).supports(arg_0));
            mgr.save(filtered);
        });
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public RegisteredService save(RegisteredService registeredService) {
        Optional<ServicesManager> manager = this.findServicesManager(registeredService);
        return manager.map(servicesManager -> servicesManager.save(registeredService)).orElse(null);
    }

    @Audit(action="SAVE_SERVICE", actionResolverName="SAVE_SERVICE_ACTION_RESOLVER", resourceResolverName="SAVE_SERVICE_RESOURCE_RESOLVER")
    public RegisteredService save(RegisteredService registeredService, boolean publishEvent) {
        Optional<ServicesManager> manager = this.findServicesManager(registeredService);
        return manager.map(servicesManager -> servicesManager.save(registeredService, publishEvent)).orElse(null);
    }

    public void save(Supplier<RegisteredService> supplier, Consumer<RegisteredService> andThenConsume, long countExclusive) {
        this.serviceManagers.forEach(servicesManager -> servicesManager.save(() -> this.lambda$save$3((Supplier)supplier), andThenConsume, countExclusive));
    }

    public void deleteAll() {
        this.serviceManagers.forEach(ServicesManager::deleteAll);
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public RegisteredService delete(long id) {
        return this.serviceManagers.stream().map(manager -> manager.delete(id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Audit(action="DELETE_SERVICE", actionResolverName="DELETE_SERVICE_ACTION_RESOLVER", resourceResolverName="DELETE_SERVICE_RESOURCE_RESOLVER")
    public RegisteredService delete(RegisteredService svc) {
        Optional<ServicesManager> manager = this.findServicesManager(svc);
        return manager.map(servicesManager -> servicesManager.delete(svc)).orElse(null);
    }

    public RegisteredService findServiceBy(Service service) {
        Optional<ServicesManager> manager = this.findServicesManager(service);
        return manager.map(servicesManager -> servicesManager.findServiceBy(service)).orElse(null);
    }

    public Collection<RegisteredService> findServiceBy(Predicate<RegisteredService> clazz) {
        return this.serviceManagers.stream().flatMap(manager -> manager.findServiceBy(clazz).stream()).collect(Collectors.toList());
    }

    public <T extends RegisteredService> T findServiceBy(Service serviceId, Class<T> clazz) {
        Optional<ServicesManager> manager = this.findServicesManager(serviceId);
        return (T)((RegisteredService)manager.map(servicesManager -> servicesManager.findServiceBy(serviceId, clazz)).orElse(null));
    }

    public RegisteredService findServiceBy(long id) {
        return this.serviceManagers.stream().map(manager -> manager.findServiceBy(id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <T extends RegisteredService> T findServiceBy(long id, Class<T> clazz) {
        Optional<ServicesManager> manager = this.findServicesManager(clazz);
        return (T)((RegisteredService)manager.map(servicesManager -> servicesManager.findServiceBy(id, clazz)).orElse(null));
    }

    public RegisteredService findServiceByName(String name) {
        return this.serviceManagers.stream().map(manager -> manager.findServiceByName(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public <T extends RegisteredService> T findServiceByName(String name, Class<T> clazz) {
        Optional<ServicesManager> manager = this.findServicesManager(clazz);
        return (T)((RegisteredService)manager.map(servicesManager -> servicesManager.findServiceByName(name, clazz)).orElse(null));
    }

    public Collection<RegisteredService> getAllServices() {
        return this.serviceManagers.stream().flatMap(manager -> manager.getAllServices().stream()).collect(Collectors.toList());
    }

    public <T extends RegisteredService> Collection<T> getAllServicesOfType(Class<T> clazz) {
        return this.serviceManagers.stream().filter(manager -> manager.supports(clazz)).flatMap(manager -> manager.getAllServicesOfType(clazz).stream()).collect(Collectors.toList());
    }

    public Collection<RegisteredService> load() {
        return this.serviceManagers.stream().flatMap(manager -> manager.load().stream()).collect(Collectors.toList());
    }

    public long count() {
        return this.serviceManagers.stream().mapToLong(ServicesManager::count).sum();
    }

    public boolean supports(Service service) {
        return this.findServicesManager(service).isPresent();
    }

    public boolean supports(RegisteredService service) {
        return this.findServicesManager(service).isPresent();
    }

    public boolean supports(Class clazz) {
        return this.findServicesManager(clazz).isPresent();
    }

    public Stream<String> getDomains() {
        return this.serviceManagers.stream().flatMap(ServicesManager::getDomains);
    }

    public Collection<RegisteredService> getServicesForDomain(String domain) {
        return this.serviceManagers.stream().flatMap(manager -> manager.getServicesForDomain(domain).stream()).collect(Collectors.toList());
    }

    public Stream<RegisteredService> findServicesBy(RegisteredServiceQuery ... queries) {
        return this.serviceManagers.stream().map(manager -> manager.findServicesBy(queries)).flatMap(results -> StreamSupport.stream(results.spliterator(), false));
    }

    private Optional<ServicesManager> findServicesManager(RegisteredService service) {
        return this.serviceManagers.stream().filter(manager -> manager.supports(service)).findFirst();
    }

    private Optional<ServicesManager> findServicesManager(Service service) {
        return this.serviceManagers.stream().filter(manager -> manager.supports(service)).findFirst();
    }

    private Optional<ServicesManager> findServicesManager(Class<?> clazz) {
        return this.serviceManagers.stream().filter(manager -> manager.supports(clazz)).findFirst();
    }

    @Generated
    public List<ServicesManager> getServiceManagers() {
        return this.serviceManagers;
    }

    private /* synthetic */ RegisteredService lambda$save$3(Supplier supplier) {
        RegisteredService registeredService = (RegisteredService)supplier.get();
        return this.findServicesManager(registeredService).isPresent() ? registeredService : null;
    }
}

