### R code from vignette source 'SQLForge.Rnw'

###################################################
### code chunk number 1: FileDemo
###################################################
library(AnnotationForge)
read.table(system.file("extdata", "hcg110_ID",
                       package="AnnotationDbi"),
           sep = "\t", header = FALSE, as.is = TRUE)[1:5,]


###################################################
### code chunk number 2: availableDB0s
###################################################
  available.db0pkgs()  


###################################################
### code chunk number 3: GetIntermedDB (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("human.db0")


###################################################
### code chunk number 4: GetOrg.db (eval = FALSE)
###################################################
## biocLite("org.Hs.eg.db")


###################################################
### code chunk number 5: list Schemas
###################################################
available.dbschemas()


###################################################
### code chunk number 6: SQLForge
###################################################
hcg110_IDs = system.file("extdata",
                          "hcg110_ID",
                          package="AnnotationDbi")

tmpout = tempdir()

makeDBPackage("HUMANCHIP_DB",
              affy=FALSE,            
              prefix="hcg110",
              fileName=hcg110_IDs,
              baseMapType="gb",
              outputDir = tmpout,
              version="1.0.0",
              manufacturer = "Affymetrix",
              chipName = "Human Cancer G110 Array",
              manufacturerUrl = "http://www.affymetrix.com")


###################################################
### code chunk number 7: cleanup2
###################################################
file.remove(file.path(tmpout, "hcg110.sqlite"))
file.rename(file.path(tmpout, "hcg110.db"),file.path(tmpout, "foo.db"))


###################################################
### code chunk number 8: install (eval = FALSE)
###################################################
## install.packages("packageNameAndPath", repos=NULL, type="source")


###################################################
### code chunk number 9: createSimpleMapping
###################################################
library(hgu95av2.db)
hgu95av2NAMESYMBOL <- createSimpleBimap("gene_info",
                                        "gene_name",
                                        "symbol",
                                        hgu95av2.db:::datacache,
                                        "NAMESYMBOL",
                                        "hgu95av2.db")
##What is the mapping we just made?
hgu95av2NAMESYMBOL
##Display the 1st 4 relationships in this new mapping
as.list(hgu95av2NAMESYMBOL)[1:4]


###################################################
### code chunk number 10: SessionInfo
###################################################
sessionInfo()


