### R code from vignette source 'CellNOptR-vignette.Rnw'

###################################################
### code chunk number 1: installRBGL (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("RBGL")


###################################################
### code chunk number 2: installPackage (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("CellNOptR")


###################################################
### code chunk number 3: installPackage2 (eval = FALSE)
###################################################
## install.packages("path_to_CellNOptR/CellNOptR_1.0.0.tar.gz",
##     repos=NULL, type="source")


###################################################
### code chunk number 4: Ropts
###################################################
options(width=70)


###################################################
### code chunk number 5: loadLib
###################################################
library(CellNOptR)


###################################################
### code chunk number 6: newDir (eval = FALSE)
###################################################
## dir.create("CNOR_analysis")
## setwd("CNOR_analysis")


###################################################
### code chunk number 7: quickstart (eval = FALSE)
###################################################
## # ---------------------- load the library and get a SIF and MIDAS file
## library(CellNOptR)
## #
## # ---------------------- examples are provided in CellNOptR
## data("ToyModel", package="CellNOptR")
## data("CNOlistToy", package="CellNOptR")
## pknmodel = ToyModel
## cnolist = CNOlist(CNOlistToy)
## #
## # ---------------------- but you can read your own files:
## pknmodel = readSIF("ToyModel.sif")
## cnolist = CNOlist("ToyDataMMB.csv")
## #
## # ---------------------- pre process the network
## model = preprocessing(cnolist, pknmodel)
## #
## # ---------------------- perform the analysis
## res = gaBinaryT1(cnolist, model, verbose=FALSE)
## #
## # ---------------------- plot the results
## cutAndPlot(cnolist, model, list(res$bString))


###################################################
### code chunk number 8: directory
###################################################
cpfile<-dir(system.file("ToyModel",package="CellNOptR"),full=TRUE)
file.copy(from=cpfile,to=getwd(),overwrite=TRUE)


###################################################
### code chunk number 9: getData
###################################################
dataToy<-readMIDAS("ToyDataMMB.csv", verbose=FALSE)
CNOlistToy<-makeCNOlist(dataToy,subfield=FALSE, verbose=FALSE)


###################################################
### code chunk number 10: getData2
###################################################
data(CNOlistToy,package="CellNOptR", verbose=FALSE)


###################################################
### code chunk number 11: cnolistClass
###################################################
CNOlistToy = CNOlist("ToyDataMMB.csv")


###################################################
### code chunk number 12: cnolistClass2 (eval = FALSE)
###################################################
## data(CNOlistToy,package="CellNOptR")
## CNOlistToy = CNOlist(CNOlistToy)


###################################################
### code chunk number 13: showCNO
###################################################
CNOlistToy


###################################################
### code chunk number 14: plotCNO
###################################################
plot(CNOlistToy)


###################################################
### code chunk number 15: ploCNOPDF
###################################################
plotCNOlistPDF(CNOlist=CNOlistToy,filename="ToyModelGraph.pdf")


###################################################
### code chunk number 16: getModel
###################################################
ToyModel<-readSIF("ToyPKNMMB.sif")


###################################################
### code chunk number 17: getModel2
###################################################
data(ToyModel,package="CellNOptR")


###################################################
### code chunk number 18: indices
###################################################
checkSignals(CNOlistToy,ToyModel)


###################################################
### code chunk number 19: plotModel
###################################################
plotModel(ToyModel, CNOlistToy)


###################################################
### code chunk number 20: NONC
###################################################
indicesToy<-indexFinder(CNOlistToy,ToyModel,verbose=TRUE)
ToyNCNOindices<-findNONC(ToyModel,indicesToy,verbose=TRUE)
ToyNCNOcut<-cutNONC(ToyModel,ToyNCNOindices)
indicesToyNCNOcut<-indexFinder(CNOlistToy,ToyNCNOcut)


###################################################
### code chunk number 21: compress
###################################################
ToyNCNOcutComp<-compressModel(ToyNCNOcut,indicesToyNCNOcut)
indicesToyNCNOcutComp<-indexFinder(CNOlistToy,ToyNCNOcutComp)


###################################################
### code chunk number 22: expand
###################################################
ToyNCNOcutCompExp<-expandGates(ToyNCNOcutComp, maxInputsPerGate=3)


###################################################
### code chunk number 23: expand
###################################################
ToyNCNOcutCompExp <- preprocessing(CNOlistToy, ToyModel, expansion=TRUE,
    compression=TRUE, cutNONC=TRUE, verbose=FALSE)


###################################################
### code chunk number 24: resError
###################################################
resECNOlistToy<-residualError(CNOlistToy)


###################################################
### code chunk number 25: initbs
###################################################
initBstring<-rep(1,length(ToyNCNOcutCompExp$reacID))


###################################################
### code chunk number 26: optim
###################################################
ToyT1opt<-gaBinaryT1(CNOlist=CNOlistToy, model=ToyNCNOcutCompExp,
    initBstring=initBstring, verbose=FALSE)


###################################################
### code chunk number 27: resSim (eval = FALSE)
###################################################
## cutAndPlot(model=ToyNCNOcutCompExp, bStrings=list(ToyT1opt$bString),
##     CNOlist=CNOlistToy,plotPDF=TRUE)


###################################################
### code chunk number 28: plotFit
###################################################
plotFit(optRes=ToyT1opt)


###################################################
### code chunk number 29: simFitPDF
###################################################
cutAndPlot(
    model=ToyNCNOcutCompExp,
    bStrings=list(ToyT1opt$bString),
    CNOlist=CNOlistToy,
    plotPDF=TRUE)
pdf("evolFitToyT1.pdf")
plotFit(optRes=ToyT1opt)
dev.off()


###################################################
### code chunk number 30: writeRes
###################################################
writeScaffold(
    modelComprExpanded=ToyNCNOcutCompExp,
    optimResT1=ToyT1opt,
    optimResT2=NA,
    modelOriginal=ToyModel,
    CNOlist=CNOlistToy)

writeNetwork(
    modelOriginal=ToyModel,
    modelComprExpanded=ToyNCNOcutCompExp,
    optimResT1=ToyT1opt,
    optimResT2=NA,
    CNOlist=CNOlistToy)

namesFilesToy<-list(
    dataPlot="ToyModelGraph.pdf",
    evolFitT1="evolFitToyT1.pdf",
    evolFitT2=NA,
    simResultsT1="SimResultsT1_1.pdf",
    simResultsT2=NA,
    scaffold="Scaffold.sif",
    scaffoldDot="Scaffold.dot",
    tscaffold="TimesScaffold.EA",
    wscaffold="weightsScaffold.EA",
    PKN="PKN.sif",
    PKNdot="PKN.dot",
    wPKN="TimesPKN.EA",
    nPKN="nodesPKN.NA")

writeReport(
    modelOriginal=ToyModel,
    modelOpt=ToyNCNOcutCompExp,
    optimResT1=ToyT1opt,
    optimResT2=NA,
    CNOlist=CNOlistToy,
    directory="testToy",
    namesFiles=namesFilesToy,
    namesData=list(CNOlist="Toy",model="ToyModel"))


###################################################
### code chunk number 31: eraseDir
###################################################
unlink("testToy",recursive=TRUE)


###################################################
### code chunk number 32: getToy
###################################################
dataToy<-readMIDAS("ToyDataMMB.csv")
CNOlistToy<-makeCNOlist(dataToy,subfield=FALSE)
ToyModel<-readSIF("ToyPKNMMB.sif")


###################################################
### code chunk number 33: wrap1 (eval = FALSE)
###################################################
## res <- CNORwrap(
##     paramsList=NA,
##     name="Toy",
##     namesData=list(CNOlist="ToyData",model="ToyModel"),
##     data=CNOlistToy,
##     model=ToyModel)


###################################################
### code chunk number 34: eraseToyDir
###################################################
unlink("Toy",recursive=TRUE)


###################################################
### code chunk number 35: wrap2
###################################################
pList<-defaultParameters(CNOlistToy, ToyModel)
#pList$data = CNOlistToy
#pList$model = ToyModel
res <- CNORwrap(
    paramsList=pList,
    name="Toy1Step",
    namesData=list(CNOlist="ToyData",model="ToyModel"))


###################################################
### code chunk number 36: eraseData
###################################################
unlink("ToyDataMMB.csv")
unlink("ToyPKNMMB.sif")
unlink("Toy1Step",recursive=TRUE)
unlink("ToyModelMMB2.sif")


###################################################
### code chunk number 37: getDREAM
###################################################
#Option 1: copy the SIF and MIDAS files (followed by readMIDAS, makeCNOlist and readSIF)
cpfile<-dir(system.file("DREAMModel",package="CellNOptR"),full=TRUE)
file.copy(from=cpfile,to=getwd(),overwrite=TRUE)
#Option 2: load the CNOlist and model objects
data(CNOlistDREAM,package="CellNOptR")
data(DreamModel,package="CellNOptR")


###################################################
### code chunk number 38: DREAMAnalysis (eval = FALSE)
###################################################
## model = preprocessing(CNOlistDREAM, DreamModel, verbose=FALSE)
## res = gaBinaryT1(CNOlistDREAM, model, verbose=FALSE, maxTime=10)
## cutAndPlot(CNOlistDREAM, model, bStrings=list(res$bString), plotPDF=TRUE,
##     plotParams=list(maxrow=25, margin=0.1, width=20, height=20))
## 
## 


###################################################
### code chunk number 39: t2load
###################################################
data(CNOlistToy2,package="CellNOptR")
data(ToyModel2,package="CellNOptR")


###################################################
### code chunk number 40: t2plotCNOlist
###################################################
plotCNOlist(CNOlistToy2)
plotCNOlistPDF(CNOlist=CNOlistToy2,filename="ToyModelGraphT2.pdf")


###################################################
### code chunk number 41: t2Opt1
###################################################
ToyNCNOcutCompExp2 = preprocessing(CNOlistToy2,ToyModel2, verbose=FALSE)
initBstring2<-rep(1,length(ToyNCNOcutCompExp2$reacID))
ToyT1opt2<-gaBinaryT1(
    CNOlist=CNOlistToy2,
    model=ToyNCNOcutCompExp2,
    initBstring=initBstring2,
    stallGenMax=10,
    maxTime=60,
    verbose=FALSE)


###################################################
### code chunk number 42: t2OptT1plot
###################################################
cutAndPlot(
    model=ToyNCNOcutCompExp2,
    bStrings=list(ToyT1opt2$bString),
    CNOlist=CNOlistToy2,
    plotPDF=TRUE)
pdf("evolFitToy2T1.pdf")
plotFit(optRes=ToyT1opt2)
dev.off()
plotFit(optRes=ToyT1opt2)


###################################################
### code chunk number 43: t2OptT2
###################################################
ToyT1opt2T2<-gaBinaryTN(
    CNOlist=CNOlistToy2,
    model=ToyNCNOcutCompExp2,
    bStrings=list(ToyT1opt2$bString),
    stallGenMax=10,
    maxTime=60,
    verbose=FALSE)


###################################################
### code chunk number 44: resSimT2
###################################################
cutAndPlot(
    model=ToyNCNOcutCompExp2,
    bStrings=list(ToyT1opt2$bString, ToyT1opt2T2$bString),
    CNOlist=CNOlistToy2,
    plotPDF=TRUE, plotParams=list(cex=0.8, cmap_scale=0.5, margin=0.2))


###################################################
### code chunk number 45: t2OptT2plot (eval = FALSE)
###################################################
## pdf("evolFitToy2T2.pdf")
## plotFit(optRes=ToyT1opt2T2)
## dev.off()
## plotFit(optRes=ToyT1opt2T2)
## writeScaffold(
##     modelComprExpanded=ToyNCNOcutCompExp2,
##     optimResT1=ToyT1opt2,
##     optimResT2=ToyT1opt2T2,
##     modelOriginal=ToyModel2,
##     CNOlist=CNOlistToy2)
## writeNetwork(
##     modelOriginal=ToyModel2,
##     modelComprExpanded=ToyNCNOcutCompExp2,
##     optimResT1=ToyT1opt2,
##     optimResT2=ToyT1opt2T2,
##     CNOlist=CNOlistToy2)
## namesFilesToy<-list(
##     dataPlot="ToyModelGraphT2.pdf",
##     evolFitT1="evolFitToy2T1.pdf",
##     evolFitT2="evolFitToy2T2.pdf",
##     simResultsT2="SimResultsTN.pdf",
##     simResultsT1="SimResultsT1_1.pdf",
##     scaffold="Scaffold.sif",
##     scaffoldDot="Scaffold.dot",
##     tscaffold="TimesScaffold.EA",
##     wscaffold="weightsScaffold.EA",
##     PKN="PKN.sif",
##     PKNdot="PKN.dot",
##     wPKN="TimesPKN.EA",
##     nPKN="nodesPKN.NA")
## writeReport(
##     modelOriginal=ToyModel2,
##     modelOpt=ToyNCNOcutCompExp2,
##     optimResT1=ToyT1opt2,
##     optimResT2=ToyT1opt2T2,
##     CNOlist=CNOlistToy2,
##     directory="testToy2",
##     namesFiles=namesFilesToy,
##     namesData=list(CNOlist="ToyModified4T2",model="ToyModified4T2"))


