### R code from vignette source 'ChemmineR.Rnw'

###################################################
### code chunk number 1: ChemmineR.Rnw:38-39
###################################################
options(width=80)


###################################################
### code chunk number 2: ChemmineR.Rnw:81-83 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R") # Sources the biocLite.R installation script.
## biocLite("ChemmineR") # Installs the package.


###################################################
### code chunk number 3: ChemmineR.Rnw:88-89
###################################################
library("ChemmineR") # Loads the package


###################################################
### code chunk number 4: ChemmineR.Rnw:91-93 (eval = FALSE)
###################################################
## library(help="ChemmineR") # Lists all functions and classes 
## vignette("ChemmineR") # Opens this PDF manual from R


###################################################
### code chunk number 5: ChemmineR.Rnw:100-105
###################################################
data(sdfsample)
sdfset <- sdfsample
sdfset # Returns summary of SDFset
sdfset[1:4] # Subsetting of object 
sdfset[[1]] # Returns summarized content of one SDF


###################################################
### code chunk number 6: ChemmineR.Rnw:106-108 (eval = FALSE)
###################################################
## view(sdfset[1:4]) # Returns summarized content of many SDFs, not printed here
## as(sdfset[1:4], "list") # Returns complete content of many SDFs, not printed here


###################################################
### code chunk number 7: ChemmineR.Rnw:112-114 (eval = FALSE)
###################################################
## sdfset <- read.SDFset("http://faculty.ucr.edu/~tgirke/Documents/
##                        R_BioCond/Samples/sdfsample.sdf")


###################################################
### code chunk number 8: ChemmineR.Rnw:118-119 (eval = FALSE)
###################################################
## header(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 9: ChemmineR.Rnw:120-121
###################################################
header(sdfset[[1]])


###################################################
### code chunk number 10: ChemmineR.Rnw:122-123 (eval = FALSE)
###################################################
## atomblock(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 11: ChemmineR.Rnw:124-125
###################################################
atomblock(sdfset[[1]])[1:4,]


###################################################
### code chunk number 12: ChemmineR.Rnw:126-127 (eval = FALSE)
###################################################
## bondblock(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 13: ChemmineR.Rnw:128-129
###################################################
bondblock(sdfset[[1]])[1:4,] 


###################################################
### code chunk number 14: ChemmineR.Rnw:130-131 (eval = FALSE)
###################################################
## datablock(sdfset[1:4]) # Not printed here


###################################################
### code chunk number 15: ChemmineR.Rnw:132-133
###################################################
datablock(sdfset[[1]])[1:4]


###################################################
### code chunk number 16: ChemmineR.Rnw:137-141
###################################################
cid(sdfset)[1:4] # Returns IDs from SDFset object
sdfid(sdfset)[1:4] # Returns IDs from SD file header block
unique_ids <- makeUnique(sdfid(sdfset))
cid(sdfset) <- unique_ids


###################################################
### code chunk number 17: ChemmineR.Rnw:145-151
###################################################
blockmatrix <- datablock2ma(datablocklist=datablock(sdfset))
   # Converts data block to matrix   
numchar <- splitNumChar(blockmatrix=blockmatrix) 
   # Splits to numeric and character matrix
numchar[[1]][1:2,1:2] # Slice of numeric matrix
numchar[[2]][1:2,10:11] # Slice of character matrix


###################################################
### code chunk number 18: ChemmineR.Rnw:155-157
###################################################
propma <- data.frame(MF=MF(sdfset), MW=MW(sdfset), atomcountMA(sdfset))
propma[1:4, ]


###################################################
### code chunk number 19: ChemmineR.Rnw:161-163
###################################################
datablock(sdfset) <- propma
datablock(sdfset[1])


###################################################
### code chunk number 20: ChemmineR.Rnw:167-170 (eval = FALSE)
###################################################
## grepSDFset("650001", sdfset, field="datablock", mode="subset") 
##    # Returns summary view of matches. Not printed here.
## .


###################################################
### code chunk number 21: ChemmineR.Rnw:172-173
###################################################
grepSDFset("650001", sdfset, field="datablock", mode="index") 


###################################################
### code chunk number 22: ChemmineR.Rnw:177-178 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE)


###################################################
### code chunk number 23: plotstruct
###################################################
plot(sdfset[1:4], print=FALSE) # Plots structures to R graphics device


###################################################
### code chunk number 24: ChemmineR.Rnw:186-187 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4]) # Compound viewing in web browser


###################################################
### code chunk number 25: ChemmineR.Rnw:197-200 (eval = FALSE)
###################################################
## apset <- sdf2ap(sdfset) 
##    # Generate atom pair descriptor database for searching
## .


###################################################
### code chunk number 26: ChemmineR.Rnw:202-208
###################################################
data(apset)
   # Load sample apset data provided by library.
cmp.search(apset, apset[1], type=3, cutoff = 0.3, quiet=TRUE) 
   # Search apset database with single compound.
cmp.cluster(db=apset, cutoff = c(0.65, 0.5), quiet=TRUE)[1:4,] 
   # Binning clustering using variable similarity cutoffs.


###################################################
### code chunk number 27: ChemmineR.Rnw:306-308 (eval = FALSE)
###################################################
## sdfset <- read.SDFset("http://faculty.ucr.edu/~tgirke/Documents/
##                        R_BioCond/Samples/sdfsample.sdf")


###################################################
### code chunk number 28: ChemmineR.Rnw:310-314
###################################################
data(sdfsample) # Loads the same SDFset provided by the library
sdfset <- sdfsample 
valid <- validSDF(sdfset) # Identifies invalid SDFs in SDFset objects
sdfset <- sdfset[valid] # Removes invalid SDFs, if there are any


###################################################
### code chunk number 29: ChemmineR.Rnw:318-320 (eval = FALSE)
###################################################
## sdfstr <- read.SDFstr("http://faculty.ucr.edu/~tgirke/Documents/
##                        R_BioCond/Samples/sdfsample.sdf")


###################################################
### code chunk number 30: ChemmineR.Rnw:323-326
###################################################
sdfstr <- as(sdfset, "SDFstr")
sdfstr
as(sdfstr, "SDFset") 


###################################################
### code chunk number 31: ChemmineR.Rnw:334-335 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf")


###################################################
### code chunk number 32: ChemmineR.Rnw:339-340 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE, cid=TRUE, db=NULL)


###################################################
### code chunk number 33: ChemmineR.Rnw:344-347 (eval = FALSE)
###################################################
## props <- data.frame(MF=MF(sdfset), MW=MW(sdfset), atomcountMA(sdfset))
## datablock(sdfset) <- props
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE, cid=TRUE)


###################################################
### code chunk number 34: ChemmineR.Rnw:351-355 (eval = FALSE)
###################################################
## sdf2str(sdf=sdfset[[1]], sig=TRUE, cid=TRUE) 
##    # Uses default components
## sdf2str(sdf=sdfset[[1]], head=letters[1:4], db=NULL) 
##    # Uses custom components for header and data block


###################################################
### code chunk number 35: ChemmineR.Rnw:359-362 (eval = FALSE)
###################################################
## write.SDF(sdfset[1:4], file="sub.sdf", sig=TRUE, cid=TRUE, db=NULL)
## write.SDF(sdfstr[1:4], file="sub.sdf")
## cat(unlist(as(sdfstr[1:4], "list")), file="sub.sdf", sep="\n")


###################################################
### code chunk number 36: ChemmineR.Rnw:372-373 (eval = FALSE)
###################################################
## write.SDF(sdfset, "test.sdf")


###################################################
### code chunk number 37: ChemmineR.Rnw:377-378 (eval = FALSE)
###################################################
## sdfstr <- read.SDFstr("test.sdf")


###################################################
### code chunk number 38: ChemmineR.Rnw:382-384 (eval = FALSE)
###################################################
## write.SDFsplit(x=sdfstr, filetag="myfile", nmol=10)
##    # 'nmol' defines the number of molecules to write to each file


###################################################
### code chunk number 39: ChemmineR.Rnw:388-389 (eval = FALSE)
###################################################
## write.SDFsplit(x=sdfset, filetag="myfile", nmol=10)


###################################################
### code chunk number 40: ChemmineR.Rnw:399-400 (eval = FALSE)
###################################################
## write.SDF(sdfset, "test.sdf")


###################################################
### code chunk number 41: ChemmineR.Rnw:404-414 (eval = FALSE)
###################################################
## desc <- function(sdfset) {
##         cbind(SDFID=sdfid(sdfset),
##               # datablock2ma(datablocklist=datablock(sdfset)),
##               MW=MW(sdfset),
##               groups(sdfset),
##               APFP=desc2fp(x=sdf2ap(sdfset), descnames=1024, type="character"),
##               AP=sdf2ap(sdfset, type="character"),
##               rings(sdfset, type="count", upper=6, arom=TRUE)
##         )
## }


###################################################
### code chunk number 42: ChemmineR.Rnw:418-420 (eval = FALSE)
###################################################
## sdfStream(input="test.sdf", output="matrix.xls", fct=desc, Nlines=1000)
##    # 'Nlines': number of lines to read from input SD File at a time


###################################################
### code chunk number 43: ChemmineR.Rnw:424-426 (eval = FALSE)
###################################################
## sdfStream(input="test.sdf", output="matrix2.xls", append=FALSE, fct=desc, 
##           Nlines=1000, startline=950) 


###################################################
### code chunk number 44: ChemmineR.Rnw:430-435 (eval = FALSE)
###################################################
## indexDF <- read.delim("matrix.xls", row.names=1)[,1:4]
## indexDFsub <- indexDF[indexDF$MW < 400, ] 
##    # Selects molecules with MW < 400
## sdfset <- read.SDFindex(file="test.sdf", index=indexDFsub, type="SDFset")
##    # Collects results in 'SDFset' container


###################################################
### code chunk number 45: ChemmineR.Rnw:439-440 (eval = FALSE)
###################################################
## read.SDFindex(file="test.sdf", index=indexDFsub, type="file", outfile="sub.sdf")


###################################################
### code chunk number 46: ChemmineR.Rnw:444-446 (eval = FALSE)
###################################################
## apset <- read.AP(x="matrix.xls", type="ap", colid="AP") 
## apfp <- read.AP(x="matrix.xls", type="fp", colid="APFP")


###################################################
### code chunk number 47: ChemmineR.Rnw:450-453 (eval = FALSE)
###################################################
## apset <- read.AP(x=sdf2ap(sdfset[1:20], type="character"), type="ap")
## fpchar <- desc2fp(sdf2ap(sdfset[1:20]), descnames=1024, type="character")
## fpset <- as(fpchar, "FPset")


###################################################
### code chunk number 48: ChemmineR.Rnw:462-468 (eval = FALSE)
###################################################
## view(sdfset[1:4]) # Summary view of several molecules
## length(sdfset) # Returns number of molecules
## sdfset[[1]] # Returns single molecule from SDFset as SDF object
## sdfset[[1]][[2]] # Returns atom block from first compound as matrix
## sdfset[[1]][[2]][1:4,] 
## c(sdfset[1:4], sdfset[5:8]) # Concatenation of several SDFsets


###################################################
### code chunk number 49: ChemmineR.Rnw:472-475 (eval = FALSE)
###################################################
## grepSDFset("650001", sdfset, field="datablock", mode="subset") 
##    # To return index, set mode="index")
## .


###################################################
### code chunk number 50: ChemmineR.Rnw:479-486 (eval = FALSE)
###################################################
## sdfid(sdfset[1:4])
##    # Retrieves CMP IDs from Molecule Name field in header block.
## cid(sdfset[1:4])
##    # Retrieves CMP IDs from ID slot in SDFset.
## unique_ids <- makeUnique(sdfid(sdfset)) 
##    # Creates unique IDs by appending a counter to duplicates.
## cid(sdfset) <- unique_ids # Assigns uniquified IDs to ID slot


###################################################
### code chunk number 51: ChemmineR.Rnw:490-494 (eval = FALSE)
###################################################
## view(sdfset[c("650001", "650012")])
## view(sdfset[4:1])
## mylog <- cid(sdfset) %in% c("650001", "650012")
## view(sdfset[mylog])


###################################################
### code chunk number 52: ChemmineR.Rnw:498-508 (eval = FALSE)
###################################################
## atomblock(sdf); sdf[[2]]; sdf[["atomblock"]] 
##    # All three methods return the same component
## header(sdfset[1:4])
## atomblock(sdfset[1:4])
## bondblock(sdfset[1:4])
## datablock(sdfset[1:4])
## header(sdfset[[1]])
## atomblock(sdfset[[1]])
## bondblock(sdfset[[1]])
## datablock(sdfset[[1]])


###################################################
### code chunk number 53: ChemmineR.Rnw:512-515 (eval = FALSE)
###################################################
## sdfset[[1]][[2]][1,1] <- 999
## atomblock(sdfset)[1] <- atomblock(sdfset)[2]
## datablock(sdfset)[1] <- datablock(sdfset)[2]


###################################################
### code chunk number 54: ChemmineR.Rnw:519-521 (eval = FALSE)
###################################################
## datablock(sdfset) <- as.matrix(iris[1:100,])
## view(sdfset[1:4])


###################################################
### code chunk number 55: ChemmineR.Rnw:525-528 (eval = FALSE)
###################################################
## as(sdfstr[1:2], "list") 
## as(sdfstr[[1]], "SDF")
## as(sdfstr[1:2], "SDFset")


###################################################
### code chunk number 56: ChemmineR.Rnw:532-537 (eval = FALSE)
###################################################
## sdfcomplist <- as(sdf, "list")
## sdfcomplist <- as(sdfset[1:4], "list"); as(sdfcomplist[[1]], "SDF")
## sdflist <- as(sdfset[1:4], "SDF"); as(sdflist, "SDFset")
## as(sdfset[[1]], "SDFstr")
## as(sdfset[[1]], "SDFset")


###################################################
### code chunk number 57: ChemmineR.Rnw:541-544 (eval = FALSE)
###################################################
## as(sdfset[1:4], "SDF")
## as(sdfset[1:4], "list")
## as(sdfset[1:4], "SDFstr")


###################################################
### code chunk number 58: boxplot
###################################################
propma <- atomcountMA(sdfset, addH=FALSE)
boxplot(propma, col="blue", main="Atom Frequency")


###################################################
### code chunk number 59: ChemmineR.Rnw:558-559 (eval = FALSE)
###################################################
## boxplot(rowSums(propma), main="All Atom Frequency")   


###################################################
### code chunk number 60: ChemmineR.Rnw:563-565
###################################################
data(atomprop)
atomprop[1:4,] 


###################################################
### code chunk number 61: ChemmineR.Rnw:569-571
###################################################
MW(sdfset[1:4], addH=FALSE)
MF(sdfset[1:4], addH=FALSE)


###################################################
### code chunk number 62: ChemmineR.Rnw:575-576
###################################################
groups(sdfset[1:4], groups="fctgroup", type="countMA")


###################################################
### code chunk number 63: ChemmineR.Rnw:580-586
###################################################
propma <- data.frame(MF=MF(sdfset, addH=FALSE), MW=MW(sdfset, addH=FALSE), 
                     Ncharges=sapply(bonds(sdfset, type="charge"), length), 
                     atomcountMA(sdfset, addH=FALSE), groups(sdfset, 
		     type="countMA"), rings(sdfset, upper=6, type="count", 
		     arom=TRUE))
propma[1:4,]


###################################################
### code chunk number 64: ChemmineR.Rnw:590-594 (eval = FALSE)
###################################################
## datablock(sdfset) <- propma # Works with all SDF components
## datablock(sdfset)[1:4]
## test <- apply(propma[1:4,], 1, function(x) data.frame(col=colnames(propma), value=x))
## sdf.visualize(sdfset[1:4], extra = test)


###################################################
### code chunk number 65: ChemmineR.Rnw:598-600 (eval = FALSE)
###################################################
## datablocktag(sdfset, tag="PUBCHEM_NIST_INCHI")
## datablocktag(sdfset, tag="PUBCHEM_OPENEYE_CAN_SMILES")


###################################################
### code chunk number 66: ChemmineR.Rnw:604-611 (eval = FALSE)
###################################################
## blockmatrix <- datablock2ma(datablocklist=datablock(sdfset)) 
##    # Converts data block to matrix 
## numchar <- splitNumChar(blockmatrix=blockmatrix) 
##    # Splits matrix to numeric matrix and character matrix
## numchar[[1]][1:4,]; numchar[[2]][1:4,] 
##    # Splits matrix to numeric matrix and character matrix
## .


###################################################
### code chunk number 67: contable (eval = FALSE)
###################################################
## conMA(sdfset[1:2], exclude=c("H"))
##    # Create bond matrix for first two molecules in sdfset
## conMA(sdfset[[1]], exclude=c("H"))
##    # Return bond matrix for first molecule
## plot(sdfset[1], atomnum = TRUE, noHbonds=FALSE , no_print_atoms = "", atomcex=0.8)
##    # Plot its structure with atom numbering
## rowSums(conMA(sdfset[[1]], exclude=c("H")))
##    # Return number of non-H bonds for each atom
## .


###################################################
### code chunk number 68: ChemmineR.Rnw:637-640
###################################################
bonds(sdfset[[1]], type="bonds")[1:4,]
bonds(sdfset[1:2], type="charge")
bonds(sdfset[1:2], type="addNH")


###################################################
### code chunk number 69: ChemmineR.Rnw:652-653
###################################################
(ringatoms <- rings(sdfset[1], upper=Inf, type="all", arom=FALSE, inner=FALSE))


###################################################
### code chunk number 70: ChemmineR.Rnw:657-659
###################################################
atomindex <- as.numeric(gsub(".*_", "", unique(unlist(ringatoms))))
plot(sdfset[1], print=FALSE, colbonds=atomindex)


###################################################
### code chunk number 71: ChemmineR.Rnw:663-664
###################################################
plot(sdfset[1], print=FALSE, atomnum=TRUE, no_print_atoms="H")


###################################################
### code chunk number 72: ChemmineR.Rnw:668-669
###################################################
rings(sdfset[1], upper=Inf, type="all", arom=TRUE, inner=FALSE)  


###################################################
### code chunk number 73: ChemmineR.Rnw:673-674
###################################################
rings(sdfset[1], upper=6, type="arom", arom=TRUE, inner=FALSE)


###################################################
### code chunk number 74: ChemmineR.Rnw:678-679
###################################################
rings(sdfset[1:4], upper=Inf, type="count", arom=TRUE, inner=TRUE) 


###################################################
### code chunk number 75: plotstruct2
###################################################
data(sdfsample)
sdfset <- sdfsample
plot(sdfset[1:4], print=FALSE) # 'print=TRUE' returns SDF summaries


###################################################
### code chunk number 76: ChemmineR.Rnw:697-699 (eval = FALSE)
###################################################
## plot(sdfset[1:4], griddim=c(2,2), print_cid=letters[1:4], print=FALSE, 
##      noHbonds=FALSE)


###################################################
### code chunk number 77: plotstruct3
###################################################
plot(sdfset["CMP1"], atomnum = TRUE,  noHbonds=F , no_print_atoms = "", 
     atomcex=0.8, sub=paste("MW:", MW(sdfsample["CMP1"])), print=FALSE)


###################################################
### code chunk number 78: plotstruct4
###################################################
plot(sdfset[1], print=FALSE, colbonds=c(22,26,25,3,28,27,2,23,21,18,8,19,20,24))


###################################################
### code chunk number 79: ChemmineR.Rnw:718-719 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4])


###################################################
### code chunk number 80: ChemmineR.Rnw:729-730 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4], extra=month.name[1:4])


###################################################
### code chunk number 81: ChemmineR.Rnw:734-737 (eval = FALSE)
###################################################
## extra <- apply(propma[1:4,], 1, function(x) 
##          data.frame(Property=colnames(propma), Value=x))
## sdf.visualize(sdfset[1:4], extra=extra)


###################################################
### code chunk number 82: ChemmineR.Rnw:741-742 (eval = FALSE)
###################################################
## sdf.visualize(sdfset[1:4], extra=bondblock(sdfset[1:4]))


###################################################
### code chunk number 83: plotmcs
###################################################
library(fmcsR)
data(fmcstest) # Loads test sdfset object
test <- fmcs(fmcstest[1], fmcstest[2], au=2, bu=1) # Searches for MCS with mismatches
plotMCS(test) # Plots both query compounds with MCS in color


###################################################
### code chunk number 84: ChemmineR.Rnw:763-765
###################################################
ap <- sdf2ap(sdfset[[1]]) # For single compound
ap


###################################################
### code chunk number 85: ChemmineR.Rnw:766-767 (eval = FALSE)
###################################################
## apset <- sdf2ap(sdfset) # For many compounds. 


###################################################
### code chunk number 86: ChemmineR.Rnw:768-769
###################################################
view(apset[1:4])


###################################################
### code chunk number 87: ChemmineR.Rnw:773-776 (eval = FALSE)
###################################################
## cid(apset[1:4]) # Compound IDs
## ap(apset[1:4]) # Atom pair descriptors
## db.explain(apset[1]) # Return atom pairs in human readable format


###################################################
### code chunk number 88: ChemmineR.Rnw:780-783 (eval = FALSE)
###################################################
## apset2descdb(apset) # Returns old list-style AP database
## tmp <- as(apset, "list") # Returns list
## as(tmp, "APset") # Converts list back to APset


###################################################
### code chunk number 89: ChemmineR.Rnw:790-794 (eval = FALSE)
###################################################
## save(sdfset, file = "sdfset.rda", compress = TRUE)
## load("sdfset.rda")
## save(apset, file = "apset.rda", compress = TRUE)
## load("apset.rda")


###################################################
### code chunk number 90: ChemmineR.Rnw:799-801
###################################################
cmp.similarity(apset[1], apset[2])
cmp.similarity(apset[1], apset[1])


###################################################
### code chunk number 91: ChemmineR.Rnw:806-807
###################################################
cmp.search(apset, apset["650065"], type=3, cutoff = 0.3, quiet=TRUE) 


###################################################
### code chunk number 92: ChemmineR.Rnw:810-812
###################################################
cmp.search(apset, apset["650065"], type=1, cutoff = 0.3, quiet=TRUE) 
cmp.search(apset, apset["650065"], type=2, cutoff = 0.3, quiet=TRUE) 


###################################################
### code chunk number 93: ChemmineR.Rnw:819-820
###################################################
showClass("FPset")


###################################################
### code chunk number 94: ChemmineR.Rnw:824-827
###################################################
data(apset)
(fpset <- desc2fp(apset))
view(fpset[1:2])


###################################################
### code chunk number 95: ChemmineR.Rnw:831-838
###################################################
fpset[1:4] # behaves like a list
fpset[[1]] # returns FP object
length(fpset) # number of compounds
cid(fpset) # returns compound ids
fpset[10] <- 0 # replacement of 10th fingerprint to all zeros  
cid(fpset) <- 1:length(fpset) # replaces compound ids
c(fpset[1:4], fpset[11:14]) # concatenation of several FPset objects


###################################################
### code chunk number 96: ChemmineR.Rnw:842-844
###################################################
fpma <- as.matrix(fpset) # coerces FPset to matrix 
as(fpma, "FPset")


###################################################
### code chunk number 97: ChemmineR.Rnw:848-850
###################################################
fpchar <- as.character(fpset) # coerces FPset to character strings
as(fpchar, "FPset") # construction of FPset class from character vector


###################################################
### code chunk number 98: ChemmineR.Rnw:854-855
###################################################
fpSim(fpset[1], fpset, method="Tanimoto", cutoff=0.4, top=4)


###################################################
### code chunk number 99: ChemmineR.Rnw:862-865 (eval = FALSE)
###################################################
## data(sdfsample)
## sdfset <- sdfsample[1:10]
## apset <- sdf2ap(sdfset)


###################################################
### code chunk number 100: ChemmineR.Rnw:869-870 (eval = FALSE)
###################################################
## fpset <- desc2fp(apset, descnames=1024, type="FPset")


###################################################
### code chunk number 101: ChemmineR.Rnw:874-876 (eval = FALSE)
###################################################
## fpset1024 <- names(rev(sort(table(unlist(as(apset, "list")))))[1:1024])
## fpset <- desc2fp(apset, descnames=fpset1024, type="FPset")


###################################################
### code chunk number 102: ChemmineR.Rnw:880-882 (eval = FALSE)
###################################################
## fpchar <- desc2fp(x=apset, descnames=1024, type="character")
## fpchar <- as.character(fpset) 


###################################################
### code chunk number 103: ChemmineR.Rnw:886-888 (eval = FALSE)
###################################################
## fpma <- as.matrix(fpset) 
## fpset <- as(fpma, "FPset")


###################################################
### code chunk number 104: ChemmineR.Rnw:892-893 (eval = FALSE)
###################################################
## fpSim(fpset[1], fpset, method="Tanimoto")


###################################################
### code chunk number 105: ChemmineR.Rnw:897-898 (eval = FALSE)
###################################################
## fpSim(fpset[1], fpset, method="Tversky", cutoff=0.4, top=4, alpha=0.5, beta=1)


###################################################
### code chunk number 106: ChemmineR.Rnw:902-904 (eval = FALSE)
###################################################
## myfct <- function(a, b, c, d) c/(a+b+c+d)
## fpSim(fpset[1], fpset, method=myfct) 


###################################################
### code chunk number 107: ChemmineR.Rnw:908-911 (eval = FALSE)
###################################################
## simMAap <- sapply(cid(apfpset), function(x) fpSim(x=apfpset[x], apfpset, sorted=FALSE))
## hc <- hclust(as.dist(1-simMAap), method="single")
## plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=TRUE)


###################################################
### code chunk number 108: ChemmineR.Rnw:918-923
###################################################
cid(sdfset) <- sdfid(sdfset)
fpset <- fp2bit(sdfset, type=1) 
fpset <- fp2bit(sdfset, type=2)
fpset <- fp2bit(sdfset, type=3)
fpset


###################################################
### code chunk number 109: ChemmineR.Rnw:927-928
###################################################
fpSim(fpset[1], fpset[2])


###################################################
### code chunk number 110: ChemmineR.Rnw:933-934
###################################################
fpSim(fpset["650065"], fpset, method="Tanimoto", cutoff=0.6, top=6) 


###################################################
### code chunk number 111: search_result
###################################################
cid(sdfset) <- cid(apset) # Assure compound name consistency among objects.
plot(sdfset[names(cmp.search(apset, apset["650065"], type=2, cutoff=4, 
     quiet=TRUE))], print=FALSE)


###################################################
### code chunk number 112: ChemmineR.Rnw:948-950 (eval = FALSE)
###################################################
## similarities <- cmp.search(apset, apset[1], type=3, cutoff = 10)
## sdf.visualize(sdfset[similarities[,1]], extra=similarities[,3])


###################################################
### code chunk number 113: ChemmineR.Rnw:964-966
###################################################
cmp.duplicated(apset, type=1)[1:4] # Returns AP duplicates as logical vector
cmp.duplicated(apset, type=2)[1:4,] # Returns AP duplicates as data frame


###################################################
### code chunk number 114: duplicates
###################################################
plot(sdfset[c("650059","650060", "650065", "650066")], print=FALSE)


###################################################
### code chunk number 115: ChemmineR.Rnw:975-977
###################################################
apdups <- cmp.duplicated(apset, type=1)
sdfset[which(!apdups)]; apset[which(!apdups)]


###################################################
### code chunk number 116: ChemmineR.Rnw:986-990
###################################################
count <- table(datablocktag(sdfset, tag="PUBCHEM_NIST_INCHI"))
count <- table(datablocktag(sdfset, tag="PUBCHEM_OPENEYE_CAN_SMILES"))
count <- table(datablocktag(sdfset, tag="PUBCHEM_MOLECULAR_FORMULA"))
count[1:4]


###################################################
### code chunk number 117: ChemmineR.Rnw:1020-1022
###################################################
clusters <- cmp.cluster(db=apset, cutoff = c(0.7, 0.8, 0.9), quiet = TRUE)
clusters[1:12,]


###################################################
### code chunk number 118: ChemmineR.Rnw:1027-1031
###################################################
fpset <- desc2fp(apset)
clusters2 <- cmp.cluster(fpset, cutoff=c(0.5, 0.7, 0.9), method="Tanimoto", 
                         quiet=TRUE) 
clusters2[1:12,]


###################################################
### code chunk number 119: ChemmineR.Rnw:1035-1037
###################################################
clusters3 <- cmp.cluster(fpset, cutoff=c(0.5, 0.7, 0.9), method="Tversky", 
                         alpha=0.3, beta=0.7, quiet=TRUE) 


###################################################
### code chunk number 120: ChemmineR.Rnw:1041-1044
###################################################
cluster.sizestat(clusters, cluster.result=1)
cluster.sizestat(clusters, cluster.result=2)
cluster.sizestat(clusters, cluster.result=3)


###################################################
### code chunk number 121: ChemmineR.Rnw:1048-1052 (eval = FALSE)
###################################################
## clusters <- cmp.cluster(db=apset, cutoff = c(0.65, 0.5, 0.3), 
##                         save.distances="distmat.rda") 
##    # Saves distance matrix to file "distmat.rda" in current working directory.
## load("distmat.rda") # Loads distance matrix.


###################################################
### code chunk number 122: ChemmineR.Rnw:1059-1061
###################################################
data(apset)
fpset <- desc2fp(apset)


###################################################
### code chunk number 123: ChemmineR.Rnw:1065-1067
###################################################
jarvisPatrick(apset, j=6, k=5) # Using "APset"
jarvisPatrick(fpset, j=6, k=5) # Using "FPset"


###################################################
### code chunk number 124: ChemmineR.Rnw:1071-1072
###################################################
jarvisPatrick(fpset, j=6, k=2, cutoff=0.6, method="Tanimoto")


###################################################
### code chunk number 125: ChemmineR.Rnw:1076-1078
###################################################
nnm <- jarvisPatrick(fpset, j=6, k=5, type="matrix")
nnm[1:4,]


###################################################
### code chunk number 126: ChemmineR.Rnw:1082-1083
###################################################
jarvisPatrick(nnm, j=6, k=5)


###################################################
### code chunk number 127: ChemmineR.Rnw:1096-1099 (eval = FALSE)
###################################################
## cluster.visualize(apset, clusters, size.cutoff=2, quiet = TRUE) 
##    # Color codes clusters with at least two members.
## cluster.visualize(apset, clusters, quiet = TRUE) # Plots all items.


###################################################
### code chunk number 128: mds_scatter
###################################################
library(scatterplot3d)
coord <- cluster.visualize(apset, clusters, size.cutoff=1, dimensions=3, quiet=TRUE)
scatterplot3d(coord)


###################################################
### code chunk number 129: ChemmineR.Rnw:1110-1117 (eval = FALSE)
###################################################
## library(rgl)
## rgl.open(); offset <- 50; par3d(windowRect=c(offset, offset, 640+offset, 640+offset))
## rm(offset); rgl.clear(); rgl.viewpoint(theta=45, phi=30, fov=60, zoom=1)
## spheres3d(coord[,1], coord[,2], coord[,3], radius=0.03, color=coord[,4], alpha=1, 
## shininess=20); aspect3d(1, 1, 1)
## axes3d(col='black'); title3d("", "", "", "", "", col='black'); bg3d("white") 
##    # To save a snapshot of the graph, one can use the command rgl.snapshot("test.png").


###################################################
### code chunk number 130: mds_scatter
###################################################
dummy <- cmp.cluster(db=apset, cutoff=0, save.distances="distmat.rda", quiet=TRUE)
load("distmat.rda")


###################################################
### code chunk number 131: hclust
###################################################
hc <- hclust(as.dist(distmat), method="single")
hc[["labels"]] <- cid(apset) # Assign correct item labels
plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=T) 


###################################################
### code chunk number 132: fp_hclust (eval = FALSE)
###################################################
## simMA <- sapply(cid(fpset), function(x) fpSim(fpset[x], fpset, sorted=FALSE)) 
## hc <- hclust(as.dist(1-simMA), method="single")  
## plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=TRUE)


###################################################
### code chunk number 133: heatmap
###################################################
library(gplots)
heatmap.2(1-distmat, Rowv=as.dendrogram(hc), Colv=as.dendrogram(hc), 
          col=colorpanel(40, "darkblue", "yellow", "white"), 
          density.info="none", trace="none")


###################################################
### code chunk number 134: getIds (eval = FALSE)
###################################################
## compounds <- getIds(c(111,123))
## compounds


###################################################
### code chunk number 135: getIds (eval = FALSE)
###################################################
## compounds <- searchString("CC(=O)OC1=CC=CC=C1C(=O)O")
## compounds


###################################################
### code chunk number 136: getIds (eval = FALSE)
###################################################
## data(sdfsample); sdfset <- sdfsample[1]
## compounds <- searchSim(sdfset)
## compounds


###################################################
### code chunk number 137: sdf2smiles (eval = FALSE)
###################################################
## data(sdfsample); sdfset <- sdfsample[1]
## smiles <- sdf2smiles(sdfset)
## smiles


###################################################
### code chunk number 138: smiles2sdf (eval = FALSE)
###################################################
## sdf <- smiles2sdf("CC(=O)OC1=CC=CC=C1C(=O)O\tname")
## view(sdf)


###################################################
### code chunk number 139: sessionInfo
###################################################
sessionInfo()


