/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Heap;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.Date;

public class ClockDaemon
extends ThreadFactoryUser {
    protected final Heap heap_ = new Heap(DefaultChannelCapacity.get());
    protected Thread thread_;
    protected final RunLoop runLoop_ = new RunLoop(this);

    public Object executeAt(Date date, Runnable runnable) {
        TaskNode taskNode = new TaskNode(date.getTime(), runnable);
        this.heap_.insert((Object)taskNode);
        this.restart();
        return taskNode;
    }

    public Object executeAfterDelay(long l, Runnable runnable) {
        long l2 = System.currentTimeMillis() + l;
        TaskNode taskNode = new TaskNode(l2, runnable);
        this.heap_.insert((Object)taskNode);
        this.restart();
        return taskNode;
    }

    public Object executePeriodically(long l, Runnable runnable, boolean bl) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = System.currentTimeMillis();
        if (!bl) {
            l2 += l;
        }
        TaskNode taskNode = new TaskNode(l2, runnable, l);
        this.heap_.insert((Object)taskNode);
        this.restart();
        return taskNode;
    }

    public static void cancel(Object object) {
        ((TaskNode)object).setCancelled();
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread((Runnable)this.runLoop_);
            this.thread_.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap_.clear();
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
        this.thread_ = null;
    }

    protected synchronized TaskNode nextTask() {
        try {
            while (!Thread.interrupted()) {
                TaskNode taskNode = (TaskNode)this.heap_.peek();
                if (taskNode == null) {
                    this.wait();
                    continue;
                }
                long l = System.currentTimeMillis();
                long l2 = taskNode.getTimeToRun();
                if (l2 > l) {
                    this.wait(l2 - l);
                    continue;
                }
                taskNode = (TaskNode)this.heap_.extract();
                if (taskNode.getCancelled()) continue;
                if (taskNode.period > 0L) {
                    taskNode.setTimeToRun(l + taskNode.period);
                    this.heap_.insert((Object)taskNode);
                }
                return taskNode;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }
}

