/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import com.install4j.api.Util;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.util.ArrayList;

public class ApplicationRegistry {
    public static boolean checkApplicationId(File file) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = InstallerUtil.getOldApplicationId(file);
        String string2 = installerConfig.getTargetApplicationId();
        if (installerConfig.getInstallerType() == 1) {
            return string == null || string.trim().length() == 0 || string.equals(string2);
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean isUpdateDirectory(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = InstallerUtil.getOldApplicationId(file);
        String string2 = installerConfig.getApplicationId();
        return string != null && string.equals(string2);
    }

    public static ApplicationInfo[] getApplicationInfoById(String string) {
        ArrayList<ApplicationInfo> arrayList = new ArrayList<ApplicationInfo>();
        String[] stringArray = InstallRegistry.getAllInstallationDirs(string);
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            String string2;
            String string3 = stringArray[i];
            ApplicationInfo applicationInfo = ApplicationRegistry.getApplicationInfoByDir(new File(string3));
            if (applicationInfo != null && string.equals(applicationInfo.getId())) {
                arrayList.add(applicationInfo);
            }
            if (!Util.isMacOS() || (string2 = InstallRegistry.getSingleBundleName(string, string3)) == null || (applicationInfo = ApplicationRegistry.getApplicationInfoByDir(file = new File(string3, string2 + "/" + "Contents/Resources/app"))) == null || !string.equals(applicationInfo.getId())) continue;
            arrayList.add(applicationInfo);
        }
        return arrayList.toArray(new ApplicationInfo[arrayList.size()]);
    }

    public static ApplicationInfo getApplicationInfoByDir(File file) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(file);
        if (installerConfig == null) {
            return null;
        }
        ApplicationInfoImpl applicationInfoImpl = new ApplicationInfoImpl();
        applicationInfoImpl.id = installerConfig.getApplicationId();
        applicationInfoImpl.name = installerConfig.getApplicationName();
        applicationInfoImpl.version = installerConfig.getApplicationVersion();
        applicationInfoImpl.installationDirectory = file;
        InstallationProperties installationProperties = new InstallationProperties(new File(file, ".install4j"));
        applicationInfoImpl.programGroup = installationProperties.getProgramGroup();
        return applicationInfoImpl;
    }

    private static class ApplicationInfoImpl
    implements ApplicationInfo {
        private File installationDirectory;
        private String programGroup;
        private String id;
        private String name;
        private String version;

        private ApplicationInfoImpl() {
        }

        public File getInstallationDirectory() {
            return this.installationDirectory;
        }

        public String getProgramGroup() {
            return this.programGroup;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "ApplicationInfo: " + this.getName() + " " + this.getVersion() + " (id: " + this.getId() + "), dir: " + this.getInstallationDirectory() + ", pg: " + this.getProgramGroup();
        }
    }

    public static interface ApplicationInfo {
        public File getInstallationDirectory();

        public String getProgramGroup();

        public String getId();

        public String getName();

        public String getVersion();
    }
}

