/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.ProgressDelegate;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class InstallFilesAction
extends SystemInstallAction {
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private ScriptProperty fileFilterScript;
    private ScriptProperty directoryResolverScript;
    private boolean showFileNames = true;
    private boolean validateApplicationId = false;
    private boolean checkFreeSpace = true;

    public ScriptProperty getFileFilterScript() {
        return this.fileFilterScript;
    }

    public void setFileFilterScript(ScriptProperty scriptProperty) {
        this.fileFilterScript = scriptProperty;
    }

    public ScriptProperty getDirectoryResolverScript() {
        return this.directoryResolverScript;
    }

    public void setDirectoryResolverScript(ScriptProperty scriptProperty) {
        this.directoryResolverScript = scriptProperty;
    }

    public boolean isShowFileNames() {
        return this.showFileNames;
    }

    public void setShowFileNames(boolean bl) {
        this.showFileNames = bl;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean bl) {
        this.validateApplicationId = bl;
    }

    public boolean isCheckFreeSpace() {
        return this.checkFreeSpace;
    }

    public void setCheckFreeSpace(boolean bl) {
        this.checkFreeSpace = bl;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        File file;
        ContextImpl contextImpl = (ContextImpl)((Object)installerContext);
        this.log();
        ProgressInterface progressInterface = installerContext.getProgressInterface();
        if (!this.showFileNames) {
            progressInterface = new ProgressDelegate(progressInterface){

                public void setDetailMessage(String string) {
                    super.setDetailMessage("");
                }
            };
        }
        if ((file = ContentInstaller.validateInstallationDir(installerContext.getInstallationDirectory(), this.validateApplicationId, this.checkFreeSpace, false, installerContext.isUnattended(), true)) == null) {
            throw new UserCanceledException();
        }
        installerContext.setInstallationDirectory(file);
        if (!RunningProcessChecker.checkRunningProcesses(installerContext, "SetupAppRunningError", true)) {
            throw new UserCanceledException();
        }
        ServiceHandler.stopServices(installerContext, false);
        try {
            this.fileInstaller.setLogDir(installerContext.getDestinationFile(".install4j"));
            ContentInstaller.getInstance().doStandardInstallation(installerContext, progressInterface, this);
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
            ClasspathModificator.addCustomJarsToClasspath(installerContext);
            contextImpl.registerScreens(false);
        }
        catch (IOException iOException) {
            installerContext.handleCriticalException(iOException);
            return false;
        }
        return true;
    }

    private void log() {
        List list = InstallerConfig.getCurrentInstance().getComponents();
        for (int i = 0; i < list.size(); ++i) {
            ComponentConfig componentConfig = (ComponentConfig)list.get(i);
            Logger.getInstance().info(this, "Component " + componentConfig);
        }
    }
}

