/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public abstract class InfoScreen
extends SystemScreen {
    private JTextPane txaInfo;
    private JScrollPane scpInfo;
    private String displayedText = "";
    private ExternalFile displayedTextFile = null;
    private String actualText;

    protected abstract String getHeaderText();

    protected abstract boolean handleConsoleQuestion(Console var1) throws UserCanceledException;

    public String getDisplayedText() {
        return InfoScreen.replaceVariables(this.displayedText);
    }

    public void setDisplayedText(String string) {
        this.displayedText = string;
    }

    public ExternalFile getDisplayedTextFile() {
        return this.displayedTextFile;
    }

    public void setDisplayedTextFile(ExternalFile externalFile) {
        this.displayedTextFile = externalFile;
    }

    public String getActualText() {
        return this.actualText;
    }

    public void willActivate() {
        super.willActivate();
        this.updateText();
    }

    public void activated() {
        super.activated();
    }

    protected void setupControls() {
        super.setupControls();
        this.txaInfo = new JTextPane();
        this.txaInfo.setEditable(false);
        this.scpInfo = new JScrollPane(this.txaInfo);
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        String string = this.getOrLoadText();
        console.println();
        console.println(this.getHeaderText());
        console.println();
        console.more(string);
        this.actualText = string;
        return this.handleConsoleQuestion(console);
    }

    private void updateText() {
        String string = this.getOrLoadText();
        String string2 = InstallerUtil.sanitizeHTML(string);
        if (!this.txaInfo.getText().equals(string2)) {
            boolean bl;
            boolean bl2 = bl = string2.toLowerCase().indexOf("<html>") > -1;
            if (bl) {
                this.txaInfo.setEditorKit(new HTMLEditorKit());
                Font font = UIManager.getFont("TextField.font");
                StyleSheet styleSheet = ((HTMLEditorKit)this.txaInfo.getEditorKit()).getStyleSheet();
                styleSheet.addRule("body {font-size : " + font.getSize() + "pt; }");
                styleSheet.addRule("body {font-family :" + font.getFontName() + "; }");
            } else {
                this.txaInfo.setFont(UIManager.getFont("TextField.font"));
            }
            this.txaInfo.setText(string2);
            this.txaInfo.setCaretPosition(0);
            this.txaInfo.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            this.actualText = string2;
        }
    }

    private String getOrLoadText() {
        String string;
        if (this.getDisplayedText().trim().length() > 0) {
            string = this.getDisplayedText();
        } else {
            string = InfoScreen.replaceVariables(InstallerUtil.loadFile(this.getContext().getExternalFile(this.getDisplayedTextFile(), false), this.getContext().getLanguageId()));
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.txaInfo.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIHelper.showURL(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(this.getHeaderText(), jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 10;
        jPanel.add((Component)this.scpInfo, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }
}

