/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstallationDirectoryScreen
extends SystemScreen
implements DirectorySelector.InternalValidator {
    private boolean showRequiredDiskSpace = true;
    private boolean checkFreeSpace = true;
    private boolean suggestAppDir = true;
    private boolean existingDirWarning = true;
    private boolean validateApplicationId = true;
    private DirectorySelector directorySelector;
    private boolean initialized;
    private JLabel lblSpace;

    public InstallationDirectoryScreen() {
        InstallerVariables.registerResponseFileVariable("sys.installationDir");
    }

    public boolean isShowRequiredDiskSpace() {
        return this.showRequiredDiskSpace;
    }

    public void setShowRequiredDiskSpace(boolean bl) {
        this.showRequiredDiskSpace = bl;
    }

    public boolean isCheckFreeSpace() {
        return this.checkFreeSpace;
    }

    public void setCheckFreeSpace(boolean bl) {
        this.checkFreeSpace = bl;
    }

    public boolean isSuggestAppDir() {
        return this.suggestAppDir;
    }

    public void setSuggestAppDir(boolean bl) {
        this.suggestAppDir = bl;
    }

    public boolean isExistingDirWarning() {
        return this.existingDirWarning;
    }

    public void setExistingDirWarning(boolean bl) {
        this.existingDirWarning = bl;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean bl) {
        this.validateApplicationId = bl;
    }

    public void setInstallerContext(InstallerContext installerContext) {
        super.setInstallerContext(installerContext);
        installerContext.addInstallerEventListener(new InstallerEventListener(){

            public void installerEvent(InstallerEvent installerEvent) {
                if (!InstallationDirectoryScreen.this.getContext().isConsole() && !InstallationDirectoryScreen.this.getContext().isUnattended() && installerEvent instanceof InstallerVariableEvent && ((InstallerVariableEvent)installerEvent).getVariableName().equals("sys.installationDir")) {
                    InstallationDirectoryScreen.this.initDirectorySelector();
                    InstallationDirectoryScreen.this.directorySelector.setDirectory(InstallationDirectoryScreen.this.getContext().getInstallationDirectory());
                }
            }
        });
    }

    public boolean handleUnattended() {
        File file = this.validateInternally(this.getInstallerContext().getInstallationDirectory());
        if (file == null || !InstallerUtil.checkWritable(file, null, true)) {
            System.out.println("You can set the destination directory by passing \"-dir [directory]\".");
            return false;
        }
        this.getInstallerContext().setInstallationDirectory(file);
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        while (true) {
            String string = this.getContext().getInstallationDirectory().getAbsolutePath();
            String string2 = console.askString(MessageFormat.format(this.getMessage("SelectDirDesc"), this.getApplicationName()), string);
            try {
                File file = new File(string2).getCanonicalFile();
                if (!new File(string2).isAbsolute() || file.exists() && !file.isDirectory()) {
                    console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string2));
                    continue;
                }
                if ((file = this.validateInternally(file)) == null || !InstallerUtil.checkWritable(file, null, true)) continue;
                InstallerConfig.getCurrentInstance().setInstallationDirectory(file);
                return true;
            }
            catch (IOException iOException) {
                console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string2));
                continue;
            }
            break;
        }
    }

    public void willActivate() {
        super.willActivate();
        this.initDirectorySelector();
        this.updateSpaceLabel();
    }

    private void initDirectorySelector() {
        if (!this.initialized) {
            String string;
            File file;
            File file2 = this.getContext().getInstallationDirectory();
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (!(!this.suggestAppDir || installerConfig.getInstallerType() == 2 || Util.isMacosInstaller() && installerConfig.getMacSpecificConfig().isSingleBundle())) {
                file = file2.getParentFile();
                string = file2.getName();
            } else {
                file = file2;
                string = null;
            }
            if (file == null) {
                file = file2;
                string = installerConfig.getApplicationName();
            }
            this.directorySelector.initDirectory(file, string);
            this.directorySelector.setNoStandardDirectoryNameForUpdate(true);
            this.initialized = true;
        }
    }

    public void activated() {
        super.activated();
        this.directorySelector.focusTextField();
    }

    protected boolean checkCompleted() {
        boolean bl;
        boolean bl2 = bl = this.directorySelector.checkSelectedDirectory() && super.checkCompleted();
        if (bl) {
            File file = this.getSelectedDir();
            InstallerConfig.getCurrentInstance().setInstallationDirectory(file);
            return InstallerUtil.checkWritable(file, Util.getParentWindow(), true);
        }
        return false;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.getMessage("SelectDirLabel"), this.getApplicationName()), jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 25;
        jPanel.add((Component)this.directorySelector, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        if (this.showRequiredDiskSpace) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            this.lblSpace = new JLabel();
            this.updateSpaceLabel();
            jPanel.add((Component)this.lblSpace, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
    }

    private void updateSpaceLabel() {
        if (this.lblSpace != null) {
            String string = MessageFormat.format(this.getMessage("DiskSpaceMBLabel"), this.getDiskSpaceMB());
            this.lblSpace.setText(string);
        }
    }

    public boolean isFillVertical() {
        return false;
    }

    private String getDiskSpaceMB() {
        double d = (double)ContentInstaller.getInstance().getMinSize() / 1048576.0;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(d);
    }

    protected int getMaxGridWidth() {
        return 2;
    }

    public String getTitle() {
        return this.getMessage("WizardSelectDir");
    }

    public String getSubTitle() {
        return MessageFormat.format(this.getMessage("SelectDirDesc"), this.getApplicationName());
    }

    protected void setupControls() {
        super.setupControls();
        this.directorySelector = new DirectorySelector(this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), false);
        this.directorySelector.setInternalValidator(this);
        this.directorySelector.activateNextScreenOnEnter(this.getContext().getWizardContext());
    }

    public File validateInternally(File file) {
        return ContentInstaller.validateInstallationDir(file, this.validateApplicationId, this.checkFreeSpace, this.existingDirWarning, this.getContext().isUnattended(), false);
    }

    private File getSelectedDir() {
        this.initDirectorySelector();
        return this.directorySelector.getSelectedFile();
    }
}

