/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerFileEvent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FileVersion;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.installer.platform.win32.WinDel;
import com.install4j.runtime.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FileInstaller {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int CANCELED = 2;
    private static final String LOG_FILENAME = "files.log";
    private static final String KEY_SHARED_DLLS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDLLs";
    private static FileInstaller fileInstaller = new FileInstaller();
    private boolean respondedOverwriteNever = false;
    private boolean respondedOverwriteAlways = false;
    private ProgressInterface defaultProgressInterface = new ProgressAdapter(null, false);
    private File logDir;
    private FileLogger newFileLogger = new FileLogger();
    private FileLogger oldFileLogger = new FileLogger();
    private FileLogger rollbackFileLogger = new FileLogger();
    private List cleanupFiles = new ArrayList();
    private List undeletedFiles = new ArrayList();
    private List undeletedDirs = new ArrayList();
    private boolean isUninstalling = false;
    private boolean uninstallForUpgrade = false;
    private Method unpackMethod;
    public static final String DS_STORE_NAME = ".DS_Store";
    private boolean hasUnrollbackedFiles = false;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$com$install4j$runtime$installer$frontend$ProgressAdapter;

    public static FileInstaller getInstance() {
        return fileInstaller;
    }

    private BackupPair backupFile(InstallFile installFile) throws IOException {
        Object object;
        Object object2 = File.createTempFile("i4b", null);
        ((File)object2).delete();
        if (!installFile.renameTo((File)object2)) {
            try {
                object = File.createTempFile("i4b", null, installFile.getParentFile());
                ((File)object).delete();
            }
            catch (IOException iOException) {
                object = object2;
            }
            if (installFile.renameTo((File)object)) {
                object2 = object;
            } else {
                FileUtil.copyFile(installFile, (File)object2);
            }
        }
        object = new BackupPair(installFile, (File)object2);
        this.newFileLogger.addReplacedFile((BackupPair)object);
        this.rollbackFileLogger.addReplacedFile((BackupPair)object);
        return object;
    }

    private static boolean isFirstFileNewer(File file, File file2) {
        if (InstallerUtil.isWindows()) {
            int n = FileVersion.compare(file, file2);
            if (n == 1) {
                return true;
            }
            if (n == 3) {
                return file.lastModified() > file2.lastModified();
            }
            return false;
        }
        return file.lastModified() > file2.lastModified();
    }

    private boolean checkFile(File file, InstallFile installFile, int n, UninstallMode uninstallMode, boolean bl, ProgressInterface progressInterface) throws IOException, UserCanceledException {
        this.createDirectory(installFile.getParentFile(), FileInstaller.getParentUninstallMode(uninstallMode));
        if (installFile.exists()) {
            boolean bl2;
            if (n == 0 || (n == 4 || n == 5) && this.respondedOverwriteNever) {
                return false;
            }
            boolean bl3 = bl2 = n != 4 && n != 5;
            if (n == 2 || n == 3) {
                boolean bl4 = FileInstaller.isFirstFileNewer(file, installFile);
                if (!bl4 && (n == 2 || this.respondedOverwriteNever)) {
                    return false;
                }
                bl2 = bl4;
            }
            if (n == 1 || this.respondedOverwriteAlways || bl && n != 5) {
                bl2 = true;
            }
            if (!bl2) {
                switch (progressInterface.askOverwrite(installFile)) {
                    case 4: {
                        this.respondedOverwriteNever = true;
                        return false;
                    }
                    case 1: {
                        return false;
                    }
                    case 3: {
                        this.respondedOverwriteAlways = true;
                    }
                }
            }
            BackupPair backupPair = this.backupFile(installFile);
            backupPair.setPreviouslyCreated(bl);
        } else {
            this.newFileLogger.addCreatedFile(installFile);
            this.rollbackFileLogger.addCreatedFile(installFile);
        }
        return true;
    }

    public void registerUninstallFile(File file) {
        InstallFile installFile = new InstallFile(file, false);
        if (file.isDirectory()) {
            this.newFileLogger.addCreatedDir(installFile);
            this.rollbackFileLogger.addCreatedDir(installFile);
        } else {
            this.newFileLogger.addCreatedFile(installFile);
            this.rollbackFileLogger.addCreatedFile(installFile);
        }
    }

    public void createDirectory(File file, UninstallMode uninstallMode) throws IOException {
        Object object;
        File file2 = file.getCanonicalFile();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (object = file2.getParentFile(); object != null; object = ((File)object).getParentFile()) {
            arrayList.add((File)object);
        }
        object = FileInstaller.getParentUninstallMode(uninstallMode);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file3 = (File)arrayList.get(i);
            if (!file3.mkdir() && object != UninstallMode.ALWAYS && object != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            InstallFile installFile = new InstallFile(file3, false, (UninstallMode)object);
            this.newFileLogger.addCreatedDir(installFile);
            this.rollbackFileLogger.addCreatedDir(installFile);
        }
        if (file2.mkdir() || uninstallMode == UninstallMode.ALWAYS || uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            InstallFile installFile = new InstallFile(file2, false, uninstallMode);
            this.newFileLogger.addCreatedDir(installFile);
            this.rollbackFileLogger.addCreatedDir(installFile);
        }
    }

    public void createDirectory(File file) throws IOException {
        this.createDirectory(file, UninstallMode.IF_CREATED);
    }

    public boolean install(File file, File file2) throws UserCanceledException {
        return this.install(file, file2, new FileOptions(file.lastModified()));
    }

    public boolean install(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return this.install(file, file2, fileOptions, null);
    }

    public boolean install(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface) throws UserCanceledException {
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        boolean bl = false;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bl = this.install(bufferedInputStream, file2, fileOptions, progressInterface, file.length(), false);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not read " + file);
            progressInterface.showFailure(string);
        }
        return bl;
    }

    public boolean install(InputStream inputStream, File file, FileOptions fileOptions) throws UserCanceledException {
        return this.install(inputStream, file, fileOptions, null, 0L, false);
    }

    private void copyTemp(File file, File file2, FileOptions fileOptions, ProgressAdapter progressAdapter, boolean bl) throws IOException {
        if (file2.exists() && !file2.delete()) {
            throw new IOException("could not delete " + file2);
        }
        if (bl) {
            this.unpack(file, file2, progressAdapter);
        } else {
            this.rename(file, file2);
        }
        file2.setLastModified(fileOptions.getFileTime());
        if (!InstallerUtil.isWindows()) {
            UnixFileSystem.setMode(fileOptions.getMode(), file2);
        }
    }

    private void rename(File file, File file2) throws IOException {
        int n = 0;
        while (!file.renameTo(file2)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (file2.exists()) {
                file2.delete();
            }
            if (n > 20) {
                throw new IOException("could not rename " + file + " to " + file2);
            }
            ++n;
        }
    }

    private void unpack(File file, File file2, ProgressAdapter progressAdapter) throws IOException {
        if (this.unpackMethod == null) {
            try {
                this.unpackMethod = Class.forName("com.install4j.runtime.installer.fileinst.Unpacker").getMethod("unpack", class$java$io$File == null ? (class$java$io$File = FileInstaller.class$("java.io.File")) : class$java$io$File, class$java$io$File == null ? (class$java$io$File = FileInstaller.class$("java.io.File")) : class$java$io$File, class$com$install4j$runtime$installer$frontend$ProgressAdapter == null ? (class$com$install4j$runtime$installer$frontend$ProgressAdapter = FileInstaller.class$("com.install4j.runtime.installer.frontend.ProgressAdapter")) : class$com$install4j$runtime$installer$frontend$ProgressAdapter);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.getMessage());
            }
        }
        try {
            Object object = this.unpackMethod.invoke(null, file, file2, progressAdapter);
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                this.rename(file, file2);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(throwable.getMessage());
        }
    }

    private static Object addSharedCount(Object object, int n) {
        int n2 = 1;
        try {
            if (object instanceof Integer) {
                n2 = (Integer)object + n;
                object = new Integer(n2);
            } else if (object instanceof String) {
                n2 = Integer.parseInt((String)object) + n;
                object = String.valueOf(n2);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (byArray.length < 1 || byArray.length > 4) {
                    throw new NumberFormatException();
                }
                int[] nArray = new int[4];
                for (int i = 0; i < byArray.length; ++i) {
                    nArray[i] = byArray[i];
                }
                n2 = (nArray[3] << 24) + (nArray[2] << 16) + (nArray[1] << 8) + (nArray[0] << 0);
                byArray[0] = (byte)((n2 += n) >>> 0 & 0xFF);
                byArray[1] = (byte)(n2 >>> 8 & 0xFF);
                byArray[2] = (byte)(n2 >>> 16 & 0xFF);
                byArray[3] = (byte)(n2 >>> 24 & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = new Integer(n2);
        }
        if (n2 <= 0) {
            return null;
        }
        return object;
    }

    private void registerShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return;
        }
        Object object = Registry.getValue(3, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            object = new Integer(0);
        }
        object = FileInstaller.addSharedCount(object, 1);
        Registry.setValue(3, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
    }

    private static boolean unregisterShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        Object object = Registry.getValue(3, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            return true;
        }
        if ((object = FileInstaller.addSharedCount(object, -1)) == null) {
            Registry.deleteValue(3, KEY_SHARED_DLLS, file.getAbsolutePath());
            return true;
        }
        Registry.setValue(3, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(InputStream inputStream, File file, FileOptions fileOptions, ProgressInterface progressInterface, long l, boolean bl) throws UserCanceledException {
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        ContextImpl contextImpl = ContextImpl.getSingleContextImpl();
        contextImpl.fireInstallerEvent(new InstallerFileEvent(contextImpl.getEventSource(), contextImpl, EventType.BEFORE_INSTALL_FILE, true, file));
        Logger.getInstance().info(null, fileOptions.toString());
        boolean bl2 = false;
        try {
            boolean bl3 = false;
            boolean bl4 = true;
            while (bl4 && !bl3) {
                try {
                    boolean bl5;
                    ProgressAdapter progressAdapter;
                    File file2;
                    block28: {
                        this.createDirectory(file.getParentFile(), FileInstaller.getParentUninstallMode(fileOptions.getUninstallMode()));
                        file2 = File.createTempFile("i4j", null, file.getParentFile());
                        progressAdapter = new ProgressAdapter(progressInterface, false);
                        bl5 = file.getName().endsWith(".jar");
                        if (bl && bl5) {
                            progressAdapter.setMaxCopyProgress(l * 3L);
                        } else {
                            progressAdapter.setMaxCopyProgress(l);
                        }
                        if (FileUtil.extractFile(inputStream, file2, progressAdapter)) break block28;
                        file2.delete();
                        boolean bl6 = false;
                        file2.delete();
                        return bl6;
                    }
                    try {
                        file2.setLastModified(fileOptions.getFileTime());
                        bl3 = true;
                        InstallFile installFile = new InstallFile(file, fileOptions.isShared(), fileOptions.getUninstallMode());
                        boolean bl7 = this.oldFileLogger.containsCreatedFile(file);
                        if (this.checkFile(file2, installFile, fileOptions.getOverwriteMode().getIntValue(), fileOptions.getUninstallMode(), bl7, progressInterface)) {
                            boolean bl8 = true;
                            while (bl8 && !bl2) {
                                try {
                                    this.copyTemp(file2, installFile, fileOptions, progressAdapter, bl && bl5);
                                    bl2 = true;
                                }
                                catch (IOException iOException) {
                                    System.err.println(iOException.getMessage());
                                    switch (progressInterface.askRetry(installFile)) {
                                        case 1: {
                                            bl8 = false;
                                            break;
                                        }
                                        case 3: {
                                            throw new UserCanceledException();
                                        }
                                    }
                                }
                            }
                        }
                        if (!fileOptions.isShared() || bl7) continue;
                        this.registerShared(file);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        file2.delete();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    switch (progressInterface.askRetry(file)) {
                        case 1: {
                            bl4 = false;
                            break;
                        }
                        case 3: {
                            throw new UserCanceledException();
                        }
                    }
                }
            }
            if (!bl2) {
                Logger.getInstance().error(null, "Could not write " + file.getPath());
            }
            boolean bl9 = bl2;
            return bl9;
        }
        finally {
            contextImpl.fireInstallerEvent(new InstallerFileEvent(contextImpl.getEventSource(), contextImpl, EventType.AFTER_INSTALL_FILE, true, file));
        }
    }

    private static UninstallMode getParentUninstallMode(UninstallMode uninstallMode) {
        if (uninstallMode == UninstallMode.ALWAYS) {
            return UninstallMode.IF_CREATED;
        }
        if (uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            return UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE;
        }
        return uninstallMode;
    }

    public void uninstall(ProgressInterface progressInterface, boolean bl) throws IOException {
        File file = InstallerUtil.getInstallerFile(LOG_FILENAME);
        FileLogger fileLogger = new FileLogger();
        fileLogger.read(file);
        if (!bl) {
            this.deleteFile(file);
        }
        this.isUninstalling = true;
        this.uninstallForUpgrade = bl;
        if (InstallerUtil.isWindows()) {
            WinDel.prepareDeletion();
        }
        this.rollback(progressInterface, fileLogger);
        if (bl) {
            this.writeUninstallLog(fileLogger, file);
        }
    }

    private void writeUninstallLog(FileLogger fileLogger, File file) throws IOException {
        InstallFile installFile;
        HashSet hashSet = new HashSet();
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            installFile = (InstallFile)iterator.next();
            if (installFile.getUninstallMode() == UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE || installFile.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                this.addDirs(installFile.getParentFile(), hashSet);
                continue;
            }
            iterator.remove();
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            installFile = (InstallFile)iterator.next();
            if (installFile.getUninstallMode() != UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE && installFile.getUninstallMode() != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            this.addDirs(installFile, hashSet);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            installFile = (InstallFile)iterator.next();
            if (hashSet.contains(installFile.getCanonicalFile())) continue;
            iterator.remove();
        }
        fileLogger.write(file, null);
    }

    private void addDirs(File file, Set set) throws IOException {
        if (file != null) {
            set.add(file.getCanonicalFile());
            this.addDirs(file.getParentFile(), set);
        }
    }

    public void finishUninstall() throws IOException {
        if (InstallerUtil.isWindows() && (this.undeletedFiles.size() > 0 || this.undeletedDirs.size() > 0)) {
            WinDel.scheduleDeletion(this.undeletedFiles, this.undeletedDirs);
        }
    }

    public void setRollbackBarrier() {
        if (!this.hasUnrollbackedFiles) {
            this.hasUnrollbackedFiles = this.rollbackFileLogger.hasFiles();
        }
        this.rollbackFileLogger = new FileLogger();
    }

    public void rollback(ProgressInterface progressInterface) {
        this.rollback(progressInterface, this.rollbackFileLogger);
    }

    public void rollback(ProgressInterface progressInterface, FileLogger fileLogger) {
        Object object;
        int n = fileLogger.getCreatedFilesSize() + fileLogger.getCreatedDirsSize() + fileLogger.getReplacedFiles().size();
        int n2 = 0;
        for (int i = fileLogger.getReplacedFiles().size() - 1; i >= 0; --i) {
            object = (BackupPair)fileLogger.getReplacedFiles().get(i);
            try {
                ((BackupPair)object).getOriginalFile().delete();
                if (!((BackupPair)object).getBackupFile().renameTo(((BackupPair)object).getOriginalFile())) {
                    FileUtil.copyFile(((BackupPair)object).getBackupFile(), ((BackupPair)object).getOriginalFile());
                }
                ((BackupPair)object).getOriginalFile().setLastModified(((BackupPair)object).getModTime());
            }
            catch (IOException iOException) {
                String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not restore " + ((BackupPair)object).getOriginalFile());
                progressInterface.showFailure(string);
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            object = (InstallFile)iterator.next();
            if (!this.isUninstalling || ((InstallFile)object).checkUninstall(this.uninstallForUpgrade)) {
                if (((InstallFile)object).isShared()) {
                    if (FileInstaller.unregisterShared((File)object)) {
                        this.deleteFile((File)object);
                    }
                } else {
                    this.deleteFile((File)object);
                }
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            object = (InstallFile)iterator.next();
            if (!this.isUninstalling || ((InstallFile)object).checkUninstall(this.uninstallForUpgrade)) {
                this.deleteDir((File)object);
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
    }

    public void deleteFile(File file) {
        if (!file.delete() && file.exists()) {
            this.undeletedFiles.add(file);
        }
    }

    public void deleteDir(File file) {
        if (InstallerUtil.isMacOS()) {
            File[] fileArray = file.listFiles();
            if (file.exists() && fileArray.length == 1 && fileArray[0].getName().equals(DS_STORE_NAME)) {
                fileArray[0].delete();
            }
        }
        if (!file.delete() && file.exists()) {
            this.undeletedDirs.add(file);
        }
    }

    public void cleanup(ProgressInterface progressInterface) {
        int n;
        List list = this.newFileLogger.getReplacedFiles();
        for (n = 0; n < list.size(); ++n) {
            BackupPair backupPair = (BackupPair)list.get(n);
            backupPair.getBackupFile().delete();
            progressInterface.setPercentCompleted((n + 1) * 100 / list.size());
        }
        for (n = 0; n < this.cleanupFiles.size(); ++n) {
            ((File)this.cleanupFiles.get(n)).delete();
        }
    }

    public void setDefaultProgressInterface(ProgressInterface progressInterface) {
        this.defaultProgressInterface = new ProgressAdapter(progressInterface, true);
    }

    public void setLogDir(File file) {
        if (this.logDir == null) {
            this.logDir = file;
            try {
                this.oldFileLogger.read(new File(file, LOG_FILENAME));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeLog() throws IOException {
        this.newFileLogger.write(new File(this.logDir, LOG_FILENAME), this.oldFileLogger);
    }

    public List getUndeletedFiles() {
        return this.undeletedFiles;
    }

    public List getUndeletedDirs() {
        return this.undeletedDirs;
    }

    public boolean wasPreviouslyCreated(File file) {
        return this.oldFileLogger.containsCreatedFile(file);
    }

    public boolean hasRollbackFiles() {
        return this.rollbackFileLogger.hasFiles();
    }

    public boolean hasUnrollbackedFiles() {
        return this.hasUnrollbackedFiles;
    }

    public void registerCleanupFile(File file) {
        this.cleanupFiles.add(file);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

