/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.Dimension2D_Double;
import com.sun.glf.Renderer;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Dimension2D;

public class CompositeRenderer
implements Renderer {
    private Renderer[] components;
    private Dimension2D margins;

    public CompositeRenderer(Renderer renderer, Renderer renderer2) {
        this(new Renderer[]{renderer, renderer2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeRenderer(Renderer[] rendererArray) {
        if (rendererArray == null) {
            throw new IllegalArgumentException();
        }
        Renderer[] rendererArray2 = rendererArray;
        synchronized (rendererArray) {
            int n;
            this.components = new Renderer[rendererArray.length];
            System.arraycopy(rendererArray, 0, this.components, 0, rendererArray.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (n = 0; n < this.components.length; ++n) {
                if (this.components[n] != null) continue;
                throw new IllegalArgumentException();
            }
            this.margins = new Dimension2D_Double();
            for (n = 0; n < rendererArray.length; ++n) {
                this.margins.setSize(Math.max(this.margins.getWidth(), rendererArray[n].getMargins().getWidth()), Math.max(this.margins.getHeight(), rendererArray[n].getMargins().getHeight()));
            }
            return;
        }
    }

    public Dimension2D getMargins() {
        return (Dimension2D)this.margins.clone();
    }

    public void render(Graphics2D graphics2D, Shape shape) {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].render(graphics2D, shape);
        }
    }
}

