/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.Anchor;
import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.Renderer;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.TextAlignment;
import com.sun.glf.util.CompositionComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class TextLayer
extends ShapeLayer {
    private static final FontRenderContext frc = new FontRenderContext(null, true, true);

    public TextLayer(LayerComposition layerComposition, String string, Font font, Renderer renderer) {
        super(layerComposition, TextLayer.makeTextBlock(string, font, layerComposition.getSize().width, TextAlignment.CENTER), renderer, Position.CENTER);
    }

    public TextLayer(LayerComposition layerComposition, AttributedString[] attributedStringArray, Renderer renderer, Position position, float f, TextAlignment textAlignment) {
        super(layerComposition, TextLayer.makeTextBlock(attributedStringArray, f, textAlignment), renderer, position);
    }

    public TextLayer(LayerComposition layerComposition, String string, Font font, Renderer renderer, Position position, float f, TextAlignment textAlignment) {
        super(layerComposition, TextLayer.makeTextBlock(string, font, f, textAlignment), renderer, position);
    }

    public static Shape makeTextBlock(String string, Font font) {
        return TextLayer.makeTextBlock(string, font, -1.0f, TextAlignment.CENTER);
    }

    public static Shape makeTextBlock(String string, Font font, float f, TextAlignment textAlignment) {
        String string2 = System.getProperty("line.separator", "\n");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        Hashtable<TextAttribute, Font> hashtable = new Hashtable<TextAttribute, Font>();
        hashtable.put(TextAttribute.FONT, font);
        AttributedString[] attributedStringArray = new AttributedString[n];
        for (int i = 0; i < n; ++i) {
            attributedStringArray[i] = new AttributedString(stringArray[i], hashtable);
        }
        return TextLayer.makeTextBlock(attributedStringArray, f, textAlignment);
    }

    public static Shape makeTextBlock(AttributedString[] attributedStringArray, float f, TextAlignment textAlignment) {
        int n;
        Object object;
        Object[] objectArray;
        int n2;
        int n3 = attributedStringArray.length;
        AttributedCharacterIterator attributedCharacterIterator = null;
        TextLayout textLayout = null;
        Shape shape = null;
        AffineTransform affineTransform = new AffineTransform();
        Vector<Shape> vector = new Vector<Shape>();
        int n4 = 0;
        Vector<Rectangle> vector2 = new Vector<Rectangle>();
        Rectangle rectangle = null;
        if (f <= 0.0f) {
            f = Float.MAX_VALUE;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = attributedStringArray[n2];
            if (textAlignment.equals(TextAlignment.JUSTIFY)) {
                objectArray.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_FULL);
            } else {
                objectArray.addAttribute(TextAttribute.JUSTIFICATION, TextAttribute.JUSTIFICATION_NONE);
            }
            attributedCharacterIterator = objectArray.getIterator();
            object = new LineBreakMeasurer(attributedCharacterIterator, frc);
            n = attributedCharacterIterator.getEndIndex();
            Vector<TextLayout> vector3 = new Vector<TextLayout>();
            while (((LineBreakMeasurer)object).getPosition() < n) {
                vector3.addElement(((LineBreakMeasurer)object).nextLayout(f));
            }
            int n5 = vector3.size();
            for (int i = 0; i < n5 - 1; ++i) {
                textLayout = (TextLayout)vector3.elementAt(i);
                textLayout = textLayout.getJustifiedLayout(f);
                affineTransform.translate(0.0, textLayout.getAscent());
                shape = textLayout.getOutline(affineTransform);
                vector.addElement(shape);
                affineTransform.translate(0.0, textLayout.getDescent() + textLayout.getLeading());
                rectangle = shape.getBounds();
                n4 = Math.max(n4, rectangle.width);
                vector2.addElement(rectangle);
            }
            if (n5 <= 0) continue;
            textLayout = (TextLayout)vector3.elementAt(n5 - 1);
            affineTransform.translate(0.0, textLayout.getAscent());
            shape = textLayout.getOutline(affineTransform);
            vector.addElement(shape);
            affineTransform.translate(0.0, textLayout.getDescent() + textLayout.getLeading());
            rectangle = shape.getBounds();
            n4 = Math.max(n4, rectangle.width);
            vector2.addElement(rectangle);
        }
        n2 = vector.size();
        objectArray = new Shape[n2];
        object = new Rectangle[n2];
        vector2.copyInto((Object[])object);
        vector.copyInto(objectArray);
        switch (textAlignment.toInt()) {
            case 0: 
            case 3: {
                break;
            }
            case 2: {
                for (n = 0; n < n2; ++n) {
                    affineTransform.setToTranslation((n4 - ((Rectangle)object[n]).width) / 2, 0.0);
                    objectArray[n] = affineTransform.createTransformedShape((Shape)objectArray[n]);
                }
                break;
            }
            case 1: {
                for (n = 0; n < n2; ++n) {
                    affineTransform.setToTranslation(n4 - ((Rectangle)object[n]).width, 0.0);
                    objectArray[n] = affineTransform.createTransformedShape((Shape)objectArray[n]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal alignment: " + textAlignment);
            }
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < n2; ++i) {
            generalPath.append((Shape)objectArray[i], false);
        }
        return generalPath;
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("TextLayer unit testing");
        jFrame.getContentPane().setLayout(new GridLayout(0, 3));
        jFrame.getContentPane().setBackground(Color.white);
        Dimension dimension = new Dimension(200, 100);
        String string = System.getProperty("line.separator", null);
        String string2 = "TextLayer extends ShapLayer." + string + "it supports various justification and anchor styles ";
        string2 = string2 + "and is able to wrap lines which are too long to fit in the composition widht, such as this one ";
        string2 = string2 + "when using a typical font, i.e one which is not too small";
        Font font = new Font("Dialog", 0, 10);
        FillRenderer fillRenderer = new FillRenderer(Color.black);
        StrokeRenderer strokeRenderer = new StrokeRenderer((Paint)Color.black, 1.0f);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LayerComposition layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        TextLayer textLayer = new TextLayer(layerComposition, string2, font, fillRenderer);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Defaults. Anchor = Center, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, Position.CENTER, dimension.width, TextAlignment.RIGHT);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Center, TextAlignment = Right");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, Position.CENTER, dimension.width, TextAlignment.LEFT);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Center, TextAlignment = Left");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, Position.CENTER, dimension.width, TextAlignment.JUSTIFY);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Center, TextAlignment = Justify");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.TOP_LEFT, 20.0f, 20.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor= Top Left, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.TOP, 2000.0f, 20.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Top, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.TOP_RIGHT, 20.0f, 20.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Top Right, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.RIGHT, 20.0f, 2000.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Right, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.BOTTOM_RIGHT, 20.0f, 20.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Bottom Right, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.BOTTOM, 2000.0f, 20.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Bottom, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.BOTTOM_LEFT, 20.0f, 20.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Bottom Left, TextAlignment = Center");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, new Position(Anchor.LEFT, 20.0f, 2000.0f), 60.0f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Left, TextAlignment = Center");
            }
        });
        String string3 = "Arts, Graphics & Fun";
        Font font2 = new Font("Dialog", 1, 20);
        Font font3 = new Font("Times New Roman", 3, 20);
        Font font4 = new Font("Dialog", 3, 30);
        AttributedString attributedString = new AttributedString(string3);
        attributedString.addAttribute(TextAttribute.FONT, font2);
        attributedString.addAttribute(TextAttribute.FONT, font3, 5, 16);
        attributedString.addAttribute(TextAttribute.FONT, font4, 16, 20);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        textLayer = new TextLayer(layerComposition, new AttributedString[]{attributedString}, fillRenderer, new Position(Anchor.CENTER, 2000.0f, 2000.0f), dimension.width, TextAlignment.CENTER);
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("AttributedString and Default settings.");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        Position position = new Position(Anchor.CENTER, 0.0f, 0.0f, AffineTransform.getRotateInstance(0.7853981633974483));
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, position, dimension.width, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Center, TextAlignment = Center, Transform = rotate");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        position = new Position(Anchor.CENTER, 0.0f, 0.0f, AffineTransform.getShearInstance(0.2, 0.2));
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, position, dimension.width, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Center, TextAlignment = Center, Transform = shear");
            }
        });
        layerComposition = new LayerComposition(dimension);
        layerComposition.setRenderingHints(renderingHints);
        shapeLayer = new ShapeLayer(layerComposition, new Rectangle(-1, -1, dimension.width, dimension.height), strokeRenderer);
        position = new Position(Anchor.CENTER, 0.0f, 0.0f, AffineTransform.getScaleInstance(1.5, -2.0));
        textLayer = new TextLayer(layerComposition, string2, font, fillRenderer, position, dimension.width, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer, shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition){
            {
                this.setToolTipText("Anchor = Center, TextAlignment = Center, Transform = scale");
            }
        });
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }
}

