/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.goodies.LitSurface;
import java.awt.Color;

public class DirectionalLight {
    private double[] Il = new double[3];
    private double Lx;
    private double Ly;
    private double Lz;

    public DirectionalLight(double[] dArray, double d, Color color) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative intensity not allowed");
        }
        if (dArray == null || dArray.length != 3) {
            throw new IllegalArgumentException();
        }
        double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d2 == 0.0) {
            throw new IllegalArgumentException();
        }
        this.Lx = dArray[0] / d2;
        this.Ly = dArray[1] / d2;
        this.Lz = dArray[2] / d2;
        this.Il[0] = d * ((double)color.getRed() / 255.0);
        this.Il[1] = d * ((double)color.getGreen() / 255.0);
        this.Il[2] = d * ((double)color.getBlue() / 255.0);
    }

    public final void getTexturedIntensity(LitSurface litSurface, int n, int n2, double[] dArray) {
        int[] nArray = litSurface.elevationMap.getNormal(n, n2);
        double d = ((double)nArray[0] * this.Lx + (double)nArray[1] * this.Ly + (double)nArray[2] * this.Lz) / 1024.0;
        d = d > 0.0 ? d : 0.0;
        double d2 = litSurface.kd * d + litSurface.ks * Math.pow(d, litSurface.ns);
        dArray[0] = this.Il[0] * d2;
        dArray[1] = this.Il[1] * d2;
        dArray[2] = this.Il[2] * d2;
    }

    public void getIntensity(LitSurface litSurface, double[] dArray) {
        double d = this.Lz;
        double d2 = Math.max(0.0, litSurface.kd * d) + Math.max(0.0, litSurface.ks * Math.pow(d, litSurface.ns));
        dArray[0] = this.Il[0] * d2;
        dArray[1] = this.Il[1] * d2;
        dArray[2] = this.Il[2] * d2;
    }
}

