/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.goodies.AbstractTransform;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class WaveTransform
extends AbstractTransform {
    int nWaves;
    float waveLength;
    float waveHeight;
    boolean waveLengthBased;

    public WaveTransform(int n, float f) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.nWaves = n;
        this.waveHeight = f;
        this.waveLengthBased = false;
    }

    public WaveTransform(float f, float f2) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.waveLength = f;
        this.waveHeight = f2;
        this.waveLengthBased = true;
    }

    public Shape transformImpl(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        Rectangle rectangle = shape.getBounds();
        float f = 0.0f;
        f = !this.waveLengthBased ? (float)rectangle.width / (float)this.nWaves : this.waveLength;
        float f2 = rectangle.x;
        float[] fArray = new float[6];
        int n = 0;
        boolean bl = false;
        float f3 = (float)Math.PI * 2;
        GeneralPath generalPath = new GeneralPath();
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    generalPath.moveTo(fArray[0], fArray[1] + this.waveHeight * (float)Math.sin((fArray[0] - f2) / f * f3));
                    break;
                }
                case 1: {
                    generalPath.lineTo(fArray[0], fArray[1] + this.waveHeight * (float)Math.sin((fArray[0] - f2) / f * f3));
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                case 2: {
                    generalPath.quadTo(fArray[0], fArray[1] + this.waveHeight * (float)Math.sin((fArray[0] - f2) / f * f3), fArray[2], fArray[3] + this.waveHeight * (float)Math.sin((fArray[2] - f2) / f * f3));
                    break;
                }
                case 3: {
                    generalPath.curveTo(fArray[0], fArray[1] + this.waveHeight * (float)Math.sin((fArray[0] - f2) / f * f3), fArray[2], fArray[3] + this.waveHeight * (float)Math.sin((fArray[2] - f2) / f * f3), fArray[4], fArray[5] + this.waveHeight * (float)Math.sin((fArray[4] - f2) / f * f3));
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n);
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }
}

