/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.MenuEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyVisualStyleAction
extends CytoscapeAction {
    private static final long serialVersionUID = 2435881456685787138L;
    private final String styleName;

    public ApplyVisualStyleAction(String styleName) {
        super(styleName);
        this.styleName = styleName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<CyNetwork> selected = Cytoscape.getSelectedNetworks();
        HashSet<CyNetworkView> views = new HashSet<CyNetworkView>();
        for (CyNetwork network : selected) {
            CyNetworkView targetView = Cytoscape.getNetworkView(network.getIdentifier());
            if (targetView == Cytoscape.getNullNetworkView()) continue;
            views.add(targetView);
        }
        this.applyStyle(views);
    }

    private void applyStyle(Set<CyNetworkView> targetViews) {
        Cytoscape.getVisualMappingManager().setVisualStyle(this.styleName);
        for (CyNetworkView view : targetViews) {
            view.setVisualStyle(this.styleName);
            view.redrawGraph(false, true);
            Cytoscape.getVisualMappingManager().setNetworkView(view);
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.enableForNetworkAndView();
    }
}

