/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;

class CreateNetworkViewTask
implements Task {
    private CyNetwork network;
    private TaskMonitor taskMonitor;

    CreateNetworkViewTask(CyNetwork network) {
        this.network = network;
    }

    public void run() {
        this.taskMonitor.setStatus("Creating network view ...");
        this.taskMonitor.setPercentCompleted(-1);
        try {
            Cytoscape.createNetworkView(this.network);
        }
        catch (Exception e) {
            this.taskMonitor.setException(e, "Could not create network view for network: " + this.network.getTitle());
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Network view successfully create for:  " + this.network.getTitle());
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return "Creating Network View";
    }
}

