/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.BitmapExportFilter;
import cytoscape.actions.ExportFilter;
import cytoscape.actions.PDFExportFilter;
import cytoscape.actions.PSExportFilter;
import cytoscape.actions.SVGExportFilter;
import cytoscape.dialogs.ExportAsGraphicsFileChooser;
import cytoscape.logger.CyLogger;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;

public class ExportAsGraphicsAction
extends CytoscapeAction {
    private static final long serialVersionUID = -5887102279435784342L;
    private static final ExportFilter BMP_FILTER = new BitmapExportFilter("bmp", "BMP");
    private static final ExportFilter JPG_FILTER = new BitmapExportFilter("jpg", "JPEG");
    private static final ExportFilter PDF_FILTER = new PDFExportFilter();
    private static final ExportFilter PNG_FILTER = new BitmapExportFilter("png", "PNG");
    private static final ExportFilter SVG_FILTER = new SVGExportFilter();
    private static final ExportFilter EPS_FILTER = new PSExportFilter("eps", "EPS");
    private static final ExportFilter[] FILTERS = new ExportFilter[]{PDF_FILTER, SVG_FILTER, EPS_FILTER, JPG_FILTER, PNG_FILTER, BMP_FILTER};
    static final CyLogger logger = CyLogger.getLogger(ExportAsGraphicsAction.class);
    private static final String TITLE = "Current Network View as Graphics";
    private ExportAsGraphicsFileChooser chooser;
    private String defaultFileExt;

    public ExportAsGraphicsAction() {
        this("PDF");
    }

    public ExportAsGraphicsAction(String fileExtension) {
        super("Current Network View as Graphics...");
        this.setPreferredMenu("File.Export");
        this.setAcceleratorCombo(80, 3);
        this.defaultFileExt = fileExtension;
    }

    private ExportFilter getFilter(String ext) {
        for (ExportFilter filter : FILTERS) {
            Set<String> exts = filter.getExtensionSet();
            for (String ex : exts) {
                if (!ex.equalsIgnoreCase(ext)) continue;
                return filter;
            }
        }
        return null;
    }

    public void menuSelected(MenuEvent e) {
        this.enableForNetworkAndView();
    }

    public void actionPerformed(ActionEvent e) {
        CyNetworkView v = Cytoscape.getCurrentNetworkView();
        if (v == null || v == Cytoscape.getNullNetworkView()) {
            logger.error("No network view exists to export!");
            return;
        }
        ExportFilter filter = this.getFilter(this.defaultFileExt);
        this.chooser = filter == null ? new ExportAsGraphicsFileChooser(FILTERS, PDF_FILTER) : new ExportAsGraphicsFileChooser(FILTERS, filter);
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExportFilter filter = (ExportFilter)ExportAsGraphicsAction.this.chooser.getSelectedFormat();
                filter.setExportTextAsFont(ExportAsGraphicsAction.this.chooser.getExportTextAsFont());
                File file = ExportAsGraphicsAction.this.chooser.getSelectedFile();
                ExportAsGraphicsAction.this.chooser.dispose();
                FileOutputStream stream = null;
                try {
                    stream = new FileOutputStream(file);
                }
                catch (Exception exp) {
                    JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Could not create file " + file.getName() + "\n\nError: " + exp.getMessage());
                    return;
                }
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                filter.export(view, stream);
            }
        };
        this.chooser.addActionListener(listener);
        this.chooser.setVisible(true);
    }
}

