/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;

class ExportAsXGMMLTask
implements Task {
    private String fileName;
    private CyNetwork network;
    private CyNetworkView view;
    private TaskMonitor taskMonitor;

    public ExportAsXGMMLTask(String fileName, CyNetwork network, CyNetworkView view) {
        this.fileName = fileName;
        this.network = network;
        this.view = view;
    }

    public void run() {
        this.taskMonitor.setStatus("Exporting Network and Attributes...");
        this.taskMonitor.setPercentCompleted(-1);
        int numNodes = this.network.getNodeCount();
        try {
            this.saveGraph();
        }
        catch (Exception e) {
            this.taskMonitor.setException(e, "Cannot export graph as XGMML.");
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Network and attributes are successfully saved to:  " + this.fileName);
        CyLogger.getLogger().info("Network and attributes are exported as an XGMML file: " + this.fileName);
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Exporting Network and Attributes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveGraph() throws IOException, JAXBException, URISyntaxException, XMLStreamException, FactoryConfigurationError {
        block3: {
            OutputStreamWriter fileWriter = null;
            try {
                fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), "UTF-8");
                XGMMLWriter writer = new XGMMLWriter(this.network, this.view);
                writer.write(fileWriter);
                Object var4_3 = null;
                if (fileWriter == null) break block3;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (fileWriter != null) {
                    fileWriter.close();
                }
                throw throwable;
            }
            fileWriter.close();
        }
        Object[] ret_val = new Object[]{this.network, new File(this.fileName).toURI(), new Integer(Cytoscape.FILE_XGMML)};
        Cytoscape.firePropertyChange("NETWORK_SAVED", null, ret_val);
    }
}

