/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.AttributeFilter;
import cytoscape.data.AttributeValueVisitor;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.equations.Equation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyAttributesUtils {
    public static final AttributeFilter ALL_ATTRIBUTES_FILTER = new AttributeFilter(){

        public boolean includeAttribute(CyAttributes attr, String objID, String attrName) {
            return true;
        }
    };

    public static Map getAttribute(String attributeName, CyAttributes attrs) {
        HashMap<String, Object> returnThis = new HashMap<String, Object>();
        MultiHashMap mmap = attrs.getMultiHashMap();
        MultiHashMapDefinition mmapDef = attrs.getMultiHashMapDefinition();
        if (mmapDef.getAttributeValueType(attributeName) != -1) {
            CountedIterator objs = mmap.getObjectKeys(attributeName);
            while (objs.hasNext()) {
                Object val;
                String obj = (String)objs.next();
                switch (attrs.getType(attributeName)) {
                    case 1: {
                        val = attrs.getBooleanAttribute(obj, attributeName);
                        break;
                    }
                    case 3: {
                        val = attrs.getIntegerAttribute(obj, attributeName);
                        break;
                    }
                    case 2: {
                        val = attrs.getDoubleAttribute(obj, attributeName);
                        break;
                    }
                    case 4: {
                        val = attrs.getStringAttribute(obj, attributeName);
                        break;
                    }
                    case -2: {
                        List l = attrs.getListAttribute(obj, attributeName);
                        if (l.size() > 0) {
                            val = l;
                            break;
                        }
                        val = null;
                        break;
                    }
                    case -3: {
                        val = attrs.getMapAttribute(obj, attributeName);
                        break;
                    }
                    default: {
                        val = null;
                    }
                }
                returnThis.put(obj, val);
            }
        }
        HashMap<String, Object> attrMap = returnThis.size() == 0 ? null : returnThis;
        return attrMap;
    }

    public static Map<String, Object> getAttributes(String canonicalName, CyAttributes attrs) {
        HashMap<String, Object> returnThis = new HashMap<String, Object>();
        String[] attrNames = attrs.getAttributeNames();
        for (int i = 0; i < attrNames.length; ++i) {
            byte type = attrs.getType(attrNames[i]);
            if (!attrs.hasAttribute(canonicalName, attrNames[i])) continue;
            if (type == -2) {
                List l = attrs.getListAttribute(canonicalName, attrNames[i]);
                if (l == null || l.size() <= 0) continue;
                returnThis.put(attrNames[i], l);
                continue;
            }
            if (type == -3) {
                Map m = attrs.getMapAttribute(canonicalName, attrNames[i]);
                if (m == null || m.size() <= 0) continue;
                returnThis.put(attrNames[i], m);
                continue;
            }
            if (type == 1) {
                returnThis.put(attrNames[i], attrs.getBooleanAttribute(canonicalName, attrNames[i]));
                continue;
            }
            if (type == 3) {
                returnThis.put(attrNames[i], attrs.getIntegerAttribute(canonicalName, attrNames[i]));
                continue;
            }
            if (type == 2) {
                returnThis.put(attrNames[i], attrs.getDoubleAttribute(canonicalName, attrNames[i]));
                continue;
            }
            if (type != 4) continue;
            returnThis.put(attrNames[i], attrs.getStringAttribute(canonicalName, attrNames[i]));
        }
        return returnThis;
    }

    public static Class getClass(String attributeName, CyAttributes attrs) {
        Class cl = null;
        switch (attrs.getType(attributeName)) {
            case 1: {
                cl = Boolean.class;
                break;
            }
            case 3: {
                cl = Integer.class;
                break;
            }
            case 2: {
                cl = Double.class;
                break;
            }
            case 4: {
                cl = String.class;
                break;
            }
            case -2: {
                cl = List.class;
                break;
            }
            case -3: {
                cl = Map.class;
                break;
            }
            case -4: {
                cl = Object.class;
                break;
            }
            default: {
                cl = null;
            }
        }
        return cl;
    }

    public static List<String> getVisibleAttributeNames(CyAttributes attrs) {
        String[] allNames = attrs.getAttributeNames();
        ArrayList<String> visibleNames = new ArrayList<String>();
        for (String name : allNames) {
            if (!attrs.getUserVisible(name)) continue;
            visibleNames.add(name);
        }
        return visibleNames;
    }

    public static boolean copyAttribute(CyAttributes attribs, String sourceId, String targetId, String attribName, boolean copyEquation, StringBuilder errorMessage) {
        if (sourceId.equals(targetId)) {
            return true;
        }
        errorMessage.setLength(0);
        if (copyEquation) {
            Equation equation = attribs.getEquation(sourceId, attribName);
            if (equation == null) {
                attribs.deleteAttribute(targetId, attribName);
            } else {
                attribs.setAttribute(targetId, attribName, equation);
            }
            return true;
        }
        switch (attribs.getType(attribName)) {
            case 1: {
                Boolean b = attribs.getBooleanAttribute(sourceId, attribName);
                if (b == null) {
                    attribs.deleteAttribute(targetId, attribName);
                } else {
                    attribs.setAttribute(targetId, attribName, b);
                }
                return true;
            }
            case 3: {
                Integer i = attribs.getIntegerAttribute(sourceId, attribName);
                if (i == null) {
                    attribs.deleteAttribute(targetId, attribName);
                } else {
                    attribs.setAttribute(targetId, attribName, i);
                }
                return true;
            }
            case 2: {
                Double d = attribs.getDoubleAttribute(sourceId, attribName);
                if (d == null) {
                    attribs.deleteAttribute(targetId, attribName);
                } else {
                    attribs.setAttribute(targetId, attribName, d);
                }
                return true;
            }
            case 4: {
                String s = attribs.getStringAttribute(sourceId, attribName);
                if (s == null) {
                    attribs.deleteAttribute(targetId, attribName);
                } else {
                    attribs.setAttribute(targetId, attribName, s);
                }
                return true;
            }
            case -2: {
                return CyAttributesUtils.copySimpleList(attribs, sourceId, targetId, attribName, errorMessage);
            }
            case -3: {
                return CyAttributesUtils.copySimpleMap(attribs, sourceId, targetId, attribName, errorMessage);
            }
        }
        Object attribValue = attribs.getAttribute(sourceId, attribName);
        if (attribValue == null) {
            attribs.deleteAttribute(targetId, attribName);
            return true;
        }
        errorMessage.append("can't copy an attribute of this type (" + CyAttributesUtils.toString(attribs.getType(attribName)) + ")!  (Source ID: " + sourceId + ", Attribute name: " + attribName + ")");
        return false;
    }

    private static boolean copySimpleList(CyAttributes attribs, String sourceId, String targetId, String attribName, StringBuilder errorMessage) {
        List originalList = attribs.getListAttribute(sourceId, attribName);
        if (originalList == null) {
            attribs.deleteAttribute(targetId, attribName);
            return true;
        }
        if (originalList.isEmpty()) {
            attribs.setListAttribute(targetId, attribName, new ArrayList());
            return true;
        }
        Class<?> entryType = originalList.get(0).getClass();
        if (entryType != Boolean.class && entryType != Integer.class && entryType != Double.class && entryType != String.class) {
            errorMessage.append("can't copy a list that has entries of a non-trivial type(" + CyAttributesUtils.toString(attribs.getType(attribName)) + ")! (Source ID: " + sourceId + ", Attribute name: " + attribName + ")");
            return false;
        }
        ArrayList newList = new ArrayList(originalList.size());
        for (Object listEntry : originalList) {
            newList.add(listEntry);
        }
        attribs.setListAttribute(targetId, attribName, newList);
        return true;
    }

    private static boolean copySimpleMap(CyAttributes attribs, String sourceId, String targetId, String attribName, StringBuilder errorMessage) {
        Map originalMap = attribs.getMapAttribute(sourceId, attribName);
        if (originalMap == null) {
            attribs.deleteAttribute(targetId, attribName);
            return true;
        }
        if (originalMap.isEmpty()) {
            attribs.setMapAttribute(targetId, attribName, new HashMap());
            return true;
        }
        HashMap newMap = new HashMap();
        newMap.putAll(originalMap);
        attribs.setMapAttribute(targetId, attribName, newMap);
        return true;
    }

    public static void copyAttributes(String originalID, String copyID, CyAttributes attrs, boolean purge) {
        CyAttributesUtils.copyAttributes(originalID, copyID, attrs, ALL_ATTRIBUTES_FILTER, purge);
    }

    public static void copyAttributes(String originalID, String copyID, CyAttributes attrs, AttributeFilter filter, boolean purge) {
        if (originalID == null || copyID == null || attrs == null) {
            CyAttributesUtils.throwIllegalArgumentException("copyAttributes(): 'original', 'copy', or 'attrs' was null.");
        }
        if (filter == null) {
            CyAttributesUtils.throwIllegalArgumentException("copyAttributes(): 'filter' was null.");
        }
        if (originalID == copyID) {
            CyAttributesUtils.throwIllegalArgumentException("copyAttributes(): 'original' must not be the same object as 'copy'.");
        }
        MultiHashMapDefinition mmapDef = attrs.getMultiHashMapDefinition();
        CountedIterator attIt = mmapDef.getDefinedAttributes();
        CopyingAttributeValueVisitor copyVisitor = new CopyingAttributeValueVisitor(copyID);
        while (attIt.hasNext()) {
            String attrName = (String)attIt.next();
            if (!filter.includeAttribute(attrs, originalID, attrName)) continue;
            CyAttributesUtils.traverseAttributeValues(originalID, attrName, attrs, copyVisitor);
        }
    }

    public static void copyAttribute(String originalID, String copyID, String attrName, CyAttributes attrs, boolean purge) {
        if (originalID == null || copyID == null || attrName == null || attrs == null) {
            CyAttributesUtils.throwIllegalArgumentException("copyAttribute(): 'original', 'copy', 'attrName' or 'attrs' was null.");
        }
        if (originalID == copyID) {
            CyAttributesUtils.throwIllegalArgumentException("copyAttribute(): 'original' must not be the same object as 'copy'.");
        }
        CopyingAttributeValueVisitor copyVisitor = new CopyingAttributeValueVisitor(copyID);
        CyAttributesUtils.traverseAttributeValues(originalID, attrName, attrs, copyVisitor);
    }

    public static void traverseAttributeValues(String objToTraverseID, String attrName, CyAttributes attrs, AttributeValueVisitor visitor) {
        if (objToTraverseID == null || attrName == null) {
            return;
        }
        if (!attrs.hasAttribute(objToTraverseID, attrName)) {
            return;
        }
        MultiHashMap mmap = attrs.getMultiHashMap();
        MultiHashMapDefinition mmapDef = attrs.getMultiHashMapDefinition();
        byte attrType = attrs.getType(attrName);
        switch (attrType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                visitor.visitingAttributeValue(objToTraverseID, attrName, attrs, null, mmap.getAttributeValue(objToTraverseID, attrName, null));
                break;
            }
            case -3: 
            case -2: {
                Object[] key = new Object[1];
                CountedIterator keyspan = mmap.getAttributeKeyspan(objToTraverseID, attrName, null);
                while (keyspan.hasNext()) {
                    key[0] = keyspan.next();
                    visitor.visitingAttributeValue(objToTraverseID, attrName, attrs, key, mmap.getAttributeValue(objToTraverseID, attrName, key));
                }
                break;
            }
            case -4: {
                byte[] keyTypes = mmapDef.getAttributeKeyspaceDimensionTypes(attrName);
                CyAttributesUtils.walkThruKeySpace(keyTypes.length, 0, new Object[0], objToTraverseID, attrName, attrs, visitor);
            }
        }
    }

    private static void walkThruKeySpace(int maxKeys, int keyTypesIndex, Object[] currentDimensionKeys, String objToTraverseID, String attrName, CyAttributes attrs, AttributeValueVisitor visitor) {
        CountedIterator dimIt = attrs.getMultiHashMap().getAttributeKeyspan(objToTraverseID, attrName, currentDimensionKeys);
        Object[] nextDimensionKeys = null;
        if (++keyTypesIndex <= maxKeys) {
            nextDimensionKeys = new Object[keyTypesIndex];
            for (int i = 0; i < keyTypesIndex - 1; ++i) {
                nextDimensionKeys[i] = currentDimensionKeys[i];
            }
        }
        while (dimIt.hasNext()) {
            Object nextValue = dimIt.next();
            nextDimensionKeys[keyTypesIndex - 1] = nextValue;
            if (keyTypesIndex < maxKeys) {
                CyAttributesUtils.walkThruKeySpace(maxKeys, keyTypesIndex, nextDimensionKeys, objToTraverseID, attrName, attrs, visitor);
                continue;
            }
            Object finalVal = attrs.getMultiHashMap().getAttributeValue(objToTraverseID, attrName, nextDimensionKeys);
            visitor.visitingAttributeValue(objToTraverseID, attrName, attrs, nextDimensionKeys, finalVal);
        }
    }

    public static List<String> getAttributeNamesForObj(String objID, CyAttributes attrs) {
        if (objID == null || attrs == null) {
            return null;
        }
        CountedIterator nameIt = attrs.getMultiHashMapDefinition().getDefinedAttributes();
        ArrayList<String> names = new ArrayList<String>();
        while (nameIt.hasNext()) {
            String attrName = (String)nameIt.next();
            if (!attrs.hasAttribute(objID, attrName)) continue;
            names.add(attrName);
        }
        return names;
    }

    public static List<String> getIDListFromAttributeValue(AttributeType type, String attrName, Object attrValue) {
        ArrayList<String> result;
        block10: {
            byte attrDataType;
            CyAttributes attr;
            ArrayList<String> ids;
            block9: {
                ids = new ArrayList<String>();
                result = new ArrayList<String>();
                if (type == AttributeType.NODE) {
                    attr = Cytoscape.getNodeAttributes();
                    List nodes = Cytoscape.getRootGraph().nodesList();
                    for (Node node : nodes) {
                        ids.add(node.getIdentifier());
                    }
                } else if (type == AttributeType.EDGE) {
                    attr = Cytoscape.getEdgeAttributes();
                    List edges = Cytoscape.getRootGraph().edgesList();
                    for (Edge edge : edges) {
                        ids.add(edge.getIdentifier());
                    }
                } else {
                    attr = Cytoscape.getNetworkAttributes();
                }
                attrDataType = attr.getType(attrName);
                List l = null;
                if (attrDataType != -2) break block9;
                block2: for (String id : ids) {
                    l = attr.getListAttribute(id, attrName);
                    if (l == null || l.size() <= 0) continue;
                    for (Object obj : l) {
                        if (obj == null || !obj.equals(attrValue)) continue;
                        result.add(id);
                        continue block2;
                    }
                }
                break block10;
            }
            if (attrDataType != 4) break block10;
            for (String id : ids) {
                String value = attr.getStringAttribute(id, attrName);
                if (value == null || !value.equals(attrValue)) continue;
                result.add(id);
            }
        }
        return result;
    }

    public static String toString(byte atype) {
        switch (atype) {
            case -4: {
                return "COMPLEX";
            }
            case -3: {
                return "SIMPLE_MAP";
            }
            case -2: {
                return "SIMPLE_LIST";
            }
            case -1: {
                return "UNDEFINED";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 3: {
                return "INTEGER";
            }
            case 2: {
                return "FLOATING";
            }
            case 4: {
                return "STRING";
            }
        }
        return "UNKNOWN:" + atype;
    }

    public static byte toByte(String attributeType) {
        if (attributeType.equals("COMPLEX")) {
            return -4;
        }
        if (attributeType.equals("SIMPLE_MAP")) {
            return -3;
        }
        if (attributeType.equals("SIMPLE_LIST")) {
            return -2;
        }
        if (attributeType.equals("UNDEFINED")) {
            return -1;
        }
        if (attributeType.equals("BOOLEAN")) {
            return 1;
        }
        if (attributeType.equals("INTEGER")) {
            return 3;
        }
        if (attributeType.equals("FLOATING")) {
            return 2;
        }
        if (attributeType.equals("STRING")) {
            return 4;
        }
        return -1;
    }

    private static void throwIllegalArgumentException(String msg) throws IllegalArgumentException {
        IllegalArgumentException ex = new IllegalArgumentException(msg);
        ex.fillInStackTrace();
        throw ex;
    }

    public static boolean isNullAttribute(String attributeType, String attributeName) {
        boolean retValue = true;
        CyAttributes attributes = null;
        if (attributeType.equalsIgnoreCase("node")) {
            attributes = Cytoscape.getNodeAttributes();
            int[] nodeIndices = Cytoscape.getCurrentNetwork().getNodeIndicesArray();
            for (int i = 0; i < nodeIndices.length; ++i) {
                String nodeID = Cytoscape.getRootGraph().getNode(nodeIndices[i]).getIdentifier();
                Object valueObj = attributes.getAttribute(nodeID, attributeName);
                if (valueObj == null) continue;
                retValue = false;
                break;
            }
        } else {
            attributes = Cytoscape.getEdgeAttributes();
            int[] edgeIndices = Cytoscape.getCurrentNetwork().getEdgeIndicesArray();
            for (int i = 0; i < edgeIndices.length; ++i) {
                String edgeID = Cytoscape.getRootGraph().getEdge(edgeIndices[i]).getIdentifier();
                Object valueObj = attributes.getAttribute(edgeID, attributeName);
                if (valueObj == null) continue;
                retValue = false;
                break;
            }
        }
        return retValue;
    }

    private static class CopyingAttributeValueVisitor
    implements AttributeValueVisitor {
        private String copyID;

        public CopyingAttributeValueVisitor(String objTraversedCopyID) {
            this.copyID = objTraversedCopyID;
        }

        public void visitingAttributeValue(String objTraversedID, String attrName, CyAttributes attrs, Object[] keySpace, Object visitedValue) {
            attrs.getMultiHashMap().setAttributeValue(this.copyID, attrName, visitedValue, keySpace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        NODE,
        EDGE,
        NETWORK;

    }
}

