/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.data.SelectFilter;
import cytoscape.giny.CytoscapeRootGraph;
import giny.model.Edge;
import giny.model.GraphObject;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SelectFilterTest
extends TestCase {
    SelectFilter filter;
    Node node1;
    Node node2;
    Node otherNode;
    Edge edge1;
    Edge edge2;
    Edge otherEdge;
    GraphPerspective gp;
    TestListener listener;
    SelectEvent savedEvent;

    public SelectFilterTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        CytoscapeRootGraph rootGraph = Cytoscape.getRootGraph();
        this.node1 = rootGraph.getNode(rootGraph.createNode());
        this.node2 = rootGraph.getNode(rootGraph.createNode());
        this.edge1 = rootGraph.getEdge(rootGraph.createEdge(this.node1, this.node2));
        this.edge2 = rootGraph.getEdge(rootGraph.createEdge(this.node2, this.node1));
        Node[] nodeArray = new Node[]{this.node1, this.node2};
        Edge[] edgeArray = new Edge[]{this.edge1, this.edge2};
        this.gp = rootGraph.createGraphPerspective(nodeArray, edgeArray);
        this.otherNode = rootGraph.getNode(rootGraph.createNode());
        this.otherEdge = rootGraph.getEdge(rootGraph.createEdge(this.node1, this.otherNode));
        this.filter = new SelectFilter(this.gp);
        this.listener = new TestListener();
        this.filter.addSelectEventListener(this.listener);
    }

    public void tearDown() throws Exception {
    }

    public void checkState(boolean n1, boolean n2, boolean e1, boolean e2) {
        SelectFilterTest.assertTrue(this.filter.isSelected(this.node1) == n1);
        SelectFilterTest.assertTrue(this.filter.isSelected(this.node2) == n2);
        SelectFilterTest.assertTrue(this.filter.isSelected(this.edge1) == e1);
        SelectFilterTest.assertTrue(this.filter.isSelected(this.edge2) == e2);
        SelectFilterTest.assertTrue(this.filter.passesFilter(this.node1) == n1);
        SelectFilterTest.assertTrue(this.filter.passesFilter(this.node2) == n2);
        SelectFilterTest.assertTrue(this.filter.passesFilter(this.edge1) == e1);
        SelectFilterTest.assertTrue(this.filter.passesFilter(this.edge2) == e2);
        if (n1) {
            SelectFilterTest.assertTrue(this.filter.getSelectedNodes().contains(this.node1));
        }
        if (n2) {
            SelectFilterTest.assertTrue(this.filter.getSelectedNodes().contains(this.node2));
        }
        if (e1) {
            SelectFilterTest.assertTrue(this.filter.getSelectedEdges().contains(this.edge1));
        }
        if (e2) {
            SelectFilterTest.assertTrue(this.filter.getSelectedEdges().contains(this.edge2));
        }
        int nodeCount = 0;
        if (n1) {
            ++nodeCount;
        }
        if (n2) {
            ++nodeCount;
        }
        SelectFilterTest.assertTrue(this.filter.getSelectedNodes().size() == nodeCount);
        int edgeCount = 0;
        if (e1) {
            ++edgeCount;
        }
        if (e2) {
            ++edgeCount;
        }
        SelectFilterTest.assertTrue(this.filter.getSelectedEdges().size() == edgeCount);
    }

    public void checkEvent(Object target, int targetType, boolean flagOn) {
        SelectEvent event = this.listener.getEvent();
        SelectFilterTest.assertTrue(event.getSource() == this.filter);
        SelectFilterTest.assertTrue(event.getTarget() == target);
        SelectFilterTest.assertTrue(event.getTargetType() == targetType);
        SelectFilterTest.assertTrue(event.getEventType() == flagOn);
    }

    public void testSingleFlags() throws Exception {
        this.checkState(false, false, false, false);
        this.filter.setSelected(this.node1, true);
        this.checkState(true, false, false, false);
        this.checkEvent(this.node1, 0, true);
        this.filter.setSelected(this.edge1, true);
        this.checkState(true, false, true, false);
        this.checkEvent(this.edge1, 1, true);
        this.filter.setSelected(this.node2, true);
        this.checkState(true, true, true, false);
        this.checkEvent(this.node2, 0, true);
        this.filter.setSelected(this.edge2, true);
        this.checkState(true, true, true, true);
        this.checkEvent(this.edge2, 1, true);
        this.filter.setSelected(this.edge1, false);
        this.checkState(true, true, false, true);
        this.checkEvent(this.edge1, 1, false);
        this.filter.setSelected(this.node1, false);
        this.checkState(false, true, false, true);
        this.checkEvent(this.node1, 0, false);
        this.savedEvent = this.listener.getEvent();
        this.filter.setSelected(this.edge2, true);
        this.checkState(false, true, false, true);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.setSelected(this.node2, true);
        this.checkState(false, true, false, true);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.setSelected(this.edge2, false);
        this.checkState(false, true, false, false);
        this.checkEvent(this.edge2, 1, false);
        this.filter.setSelected(this.node2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(this.node2, 0, false);
        this.savedEvent = this.listener.getEvent();
        this.filter.setSelected(this.node1, false);
        this.checkState(false, false, false, false);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.setSelected(this.edge1, false);
        this.checkState(false, false, false, false);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
    }

    public void testGroupFlags() {
        Set<GraphObject> testSet = null;
        this.checkState(false, false, false, false);
        HashSet<Node> nodeSet1 = new HashSet<Node>();
        nodeSet1.add(this.node1);
        testSet = this.filter.setSelectedNodes(nodeSet1, true);
        this.checkState(true, false, false, false);
        this.checkEvent(testSet, 2, true);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.node1));
        HashSet<Edge> edgeSet1 = new HashSet<Edge>();
        edgeSet1.add(this.edge2);
        testSet = this.filter.setSelectedEdges(edgeSet1, true);
        this.checkState(true, false, false, true);
        this.checkEvent(testSet, 3, true);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.edge2));
        HashSet<Node> nodeSet2 = new HashSet<Node>();
        nodeSet2.add(this.node1);
        nodeSet2.add(this.node2);
        testSet = this.filter.setSelectedNodes(nodeSet2, true);
        this.checkState(true, true, false, true);
        this.checkEvent(testSet, 2, true);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.node2));
        HashSet<Edge> edgeSet2 = new HashSet<Edge>();
        edgeSet2.add(this.edge1);
        edgeSet2.add(this.edge2);
        testSet = this.filter.setSelectedEdges(edgeSet2, true);
        this.checkState(true, true, true, true);
        this.checkEvent(testSet, 3, true);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.edge1));
        testSet = this.filter.setSelectedNodes(nodeSet1, false);
        this.checkState(false, true, true, true);
        this.checkEvent(testSet, 2, false);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.node1));
        testSet = this.filter.setSelectedEdges(edgeSet1, false);
        this.checkState(false, true, true, false);
        this.checkEvent(testSet, 3, false);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.edge2));
        testSet = this.filter.setSelectedNodes(nodeSet2, false);
        this.checkState(false, false, true, false);
        this.checkEvent(testSet, 2, false);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.node2));
        testSet = this.filter.setSelectedEdges(edgeSet2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(testSet, 3, false);
        SelectFilterTest.assertTrue(testSet.size() == 1);
        SelectFilterTest.assertTrue(testSet.contains(this.edge1));
        testSet = this.filter.setSelectedNodes(nodeSet2, true);
        this.checkState(true, true, false, false);
        this.checkEvent(testSet, 2, true);
        SelectFilterTest.assertTrue(testSet.size() == 2);
        SelectFilterTest.assertTrue(testSet.contains(this.node1));
        SelectFilterTest.assertTrue(testSet.contains(this.node2));
        testSet = this.filter.setSelectedNodes(nodeSet2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(testSet, 2, false);
        SelectFilterTest.assertTrue(testSet.size() == 2);
        SelectFilterTest.assertTrue(testSet.contains(this.node1));
        SelectFilterTest.assertTrue(testSet.contains(this.node2));
        testSet = this.filter.setSelectedEdges(edgeSet2, true);
        this.checkState(false, false, true, true);
        this.checkEvent(testSet, 3, true);
        SelectFilterTest.assertTrue(testSet.size() == 2);
        SelectFilterTest.assertTrue(testSet.contains(this.edge1));
        SelectFilterTest.assertTrue(testSet.contains(this.edge2));
        testSet = this.filter.setSelectedEdges(edgeSet2, false);
        this.checkState(false, false, false, false);
        this.checkEvent(testSet, 3, false);
        SelectFilterTest.assertTrue(testSet.size() == 2);
        SelectFilterTest.assertTrue(testSet.contains(this.edge1));
        SelectFilterTest.assertTrue(testSet.contains(this.edge2));
    }

    public void testFlagAll() {
        this.checkState(false, false, false, false);
        this.filter.selectAllNodes();
        this.checkState(true, true, false, false);
        this.checkSelectAllEvent(2, 2, true);
        this.filter.unselectAllNodes();
        this.checkState(false, false, false, false);
        this.checkSelectAllEvent(2, 2, false);
        this.filter.selectAllEdges();
        this.checkState(false, false, true, true);
        this.checkSelectAllEvent(2, 3, true);
        this.filter.unselectAllEdges();
        this.checkState(false, false, false, false);
        this.checkSelectAllEvent(2, 3, false);
        this.filter.setSelected(this.node1, true);
        this.checkState(true, false, false, false);
        this.filter.selectAllNodes();
        this.checkState(true, true, false, false);
        this.checkSelectAllEvent(1, 2, true);
        this.filter.setSelected(this.node1, false);
        this.checkState(false, true, false, false);
        this.filter.unselectAllNodes();
        this.checkState(false, false, false, false);
        this.checkSelectAllEvent(1, 2, false);
        this.filter.setSelected(this.edge1, true);
        this.checkState(false, false, true, false);
        this.filter.selectAllEdges();
        this.checkState(false, false, true, true);
        this.checkSelectAllEvent(1, 3, true);
        this.filter.setSelected(this.edge1, false);
        this.checkState(false, false, false, true);
        this.filter.unselectAllEdges();
        this.checkState(false, false, false, false);
        this.checkSelectAllEvent(1, 3, false);
    }

    public void checkSelectAllEvent(int setSize, int targetType, boolean flagOn) {
    }

    public void testListeners() {
        this.checkState(false, false, false, false);
        this.filter.setSelected(this.node1, true);
        this.checkEvent(this.node1, 0, true);
        this.savedEvent = this.listener.getEvent();
        this.filter.removeSelectEventListener(this.listener);
        this.filter.setSelected(this.node1, false);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.checkEvent(this.node1, 0, true);
        this.filter.setSelected(this.edge1, true);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.checkEvent(this.node1, 0, true);
        this.filter.addSelectEventListener(this.listener);
        this.filter.setSelected(this.edge1, false);
        SelectFilterTest.assertTrue(this.listener.getEvent() != this.savedEvent);
        this.checkEvent(this.edge1, 1, false);
        this.checkState(false, false, false, false);
        this.filter.selectAllNodes();
        this.filter.selectAllEdges();
        this.checkState(true, true, true, true);
        this.gp.hideEdge(this.edge1);
        this.checkState(true, true, false, true);
        this.checkSelectAllEvent(1, 3, false);
        this.savedEvent = this.listener.getEvent();
        this.gp.restoreEdge(this.edge1);
        this.checkState(true, true, false, true);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.unselectAllNodes();
        this.filter.unselectAllEdges();
        this.checkState(false, false, false, false);
        this.filter.selectAllNodes();
        this.filter.selectAllEdges();
        this.checkState(true, true, true, true);
        this.gp.hideNode(this.node1);
        this.checkState(false, true, false, false);
        this.checkSelectAllEvent(2, 3, false);
        this.savedEvent = this.listener.getEvent();
        this.gp.restoreNode(this.node1);
        this.checkState(false, true, false, false);
        SelectFilterTest.assertTrue(this.listener.getEvent() == this.savedEvent);
        this.filter.unselectAllNodes();
        this.filter.unselectAllEdges();
    }

    public static void main(String[] args) {
        TestRunner.run(new TestSuite(SelectFilterTest.class));
    }

    private class TestListener
    implements SelectEventListener {
        private SelectEvent event;

        private TestListener() {
        }

        public void onSelectEvent(SelectEvent newEvent) {
            this.event = newEvent;
        }

        public SelectEvent getEvent() {
            return this.event;
        }
    }
}

