/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology.readers;

import cytoscape.CyNetwork;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.readers.OBOFlatFileReader;
import cytoscape.data.ontology.readers.OBOTags;
import cytoscape.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class OBOFlatFileReaderTest
extends TestCase {
    private static final String REMOTE_OBO = "http://www.geneontology.org/ontology/gene_ontology.obo";
    private static final String LOCAL_OBO = "testData/annotation/goslim_generic.obo";
    private static final int DAG_SIZE = 10738;
    private InputStream is;

    protected void setUp() throws Exception {
        super.setUp();
        File sampleOBO = new File(LOCAL_OBO);
        URL oboUrl = sampleOBO.toURL();
        this.is = URLUtil.getBasicInputStream(oboUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            block4: {
                try {
                    if (this.is == null) break block4;
                    this.is.close();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.is = null;
                }
            }
            Object var3_1 = null;
            this.is = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.is = null;
            throw throwable;
        }
    }

    public void testReadOBO() {
        long start = System.currentTimeMillis();
        OBOFlatFileReader obor = new OBOFlatFileReader(this.is, null);
        try {
            obor.readOntology();
            OBOFlatFileReaderTest.assertNotNull(obor.getHeader());
            Map<String, String> header = obor.getHeader();
            Set<String> keys = obor.getHeader().keySet();
            for (String key : keys) {
                System.out.println("Key = " + key + ", Value = " + header.get(key));
            }
            OBOFlatFileReaderTest.assertTrue(keys.contains("format-version"));
            OBOFlatFileReaderTest.assertTrue(keys.contains("date"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("## OBO Loading time = " + (System.currentTimeMillis() - start) + " msec.");
        start = System.currentTimeMillis();
        CyAttributes goTermAttr = obor.getTermsAttributes();
        String[] names = goTermAttr.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            System.out.println("Name = " + names[i]);
        }
        String curString = goTermAttr.getStringAttribute("GO:0000004", "ontology.name");
        System.out.println("GO:0000004 = " + curString);
        OBOFlatFileReaderTest.assertEquals(curString, "biological process unknown");
        curString = goTermAttr.getStringAttribute("GO:0016049", "ontology.name");
        System.out.println("GO:0016049 = " + curString);
        OBOFlatFileReaderTest.assertEquals(curString, "cell growth");
        Map synoMap = goTermAttr.getMapAttribute("GO:0016049", "ontology." + OBOTags.SYNONYM.toString());
        OBOFlatFileReaderTest.assertNotNull(synoMap);
        OBOFlatFileReaderTest.assertEquals(4, synoMap.size());
        for (Object val : synoMap.keySet()) {
            System.out.print("GO:0016049 Synonyms = " + val.toString());
            System.out.println(" ( " + synoMap.get(val) + " )");
        }
        CyNetwork dag = obor.getDag();
        OBOFlatFileReaderTest.assertNotNull(dag);
        System.out.println("## OBO Test time = " + (System.currentTimeMillis() - start) + " msec.");
    }
}

