/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.GraphReader;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.task.TaskMonitor;
import cytoscape.util.CyNetworkNaming;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public abstract class AbstractGraphReader
implements GraphReader {
    protected String fileName;
    protected String title = null;

    public AbstractGraphReader(String fileName) {
        this.fileName = fileName;
    }

    public abstract void read() throws IOException;

    public int[] getNodeIndicesArray() {
        return null;
    }

    public int[] getEdgeIndicesArray() {
        return null;
    }

    public String getNetworkName() {
        String t = "";
        if (this.title != null) {
            t = this.title;
        } else if (this.fileName != null) {
            Set extSets;
            File tempFile = new File(this.fileName);
            t = tempFile.getName();
            String ext = "";
            int dotIndex = t.lastIndexOf(".");
            if (dotIndex != -1) {
                ext = t.substring(dotIndex + 1);
            }
            if ((extSets = (Set)Cytoscape.getImportHandler().getAllExtensions()).contains(ext)) {
                t = t.substring(0, dotIndex);
            }
        }
        return CyNetworkNaming.getSuggestedNetworkTitle(t);
    }

    public void doPostProcessing(CyNetwork network) {
    }

    public CyLayoutAlgorithm getLayoutAlgorithm() {
        return CyLayouts.getDefaultLayout();
    }

    public void setTaskMonitor(TaskMonitor monitor) {
    }
}

