/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.readers.EqnAttrTracker;
import cytoscape.data.readers.Handler;
import cytoscape.data.readers.MetadataEntries;
import cytoscape.data.readers.MetadataParser;
import cytoscape.data.readers.ObjectType;
import cytoscape.data.readers.ParseState;
import cytoscape.logger.CyLogger;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XGMMLParser
extends DefaultHandler {
    static final String XLINK = "http://www.w3.org/1999/xlink";
    static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String DUBLINCORE = "http://purl.org/dc/elements/1.1/";
    private static CyLogger logger = CyLogger.getLogger(XGMMLParser.class);
    private Locator locator = null;
    private ParseState parseState = ParseState.NONE;
    private Stack<ParseState> stateStack = null;
    private String networkName = null;
    private String currentCData = null;
    private String backgroundColor = null;
    private double graphZoom = 1.0;
    private double graphCenterX = 0.0;
    private double graphCenterY = 0.0;
    private double documentVersion = 1.0;
    private String RDFDate = null;
    private String RDFTitle = null;
    private String RDFIdentifier = null;
    private String RDFDescription = null;
    private String RDFSource = null;
    private String RDFType = null;
    private String RDFFormat = null;
    private List<CyNode> nodeList = null;
    private List<CyEdge> edgeList = null;
    private HashMap<CyNode, List<String>> nodeLinks = null;
    private HashMap<String, CyNode> idMap = null;
    private HashMap<CyNode, List<CyNode>> groupMap = null;
    private Stack<CyNode> groupStack = null;
    private HashMap<CyNode, Attributes> nodeGraphicsMap = null;
    private HashMap<CyEdge, Attributes> edgeGraphicsMap = null;
    private CyNode currentNode = null;
    private CyEdge currentEdge = null;
    private CyNode currentGroupNode = null;
    private ParseState attState = ParseState.NONE;
    private String currentAttributeID = null;
    private CyAttributes currentAttributes = null;
    private String objectTarget = null;
    private int level = 0;
    private int numKeys = 0;
    private Map[] complexMap = null;
    private Object[] complexKey = null;
    private byte[] attributeDefinition = null;
    private byte valueType;
    private boolean complexAttributeDefined = false;
    private MultiHashMap mhm = null;
    private List<String> handleList = null;
    private String edgeBendX = null;
    private String edgeBendY = null;
    private EqnAttrTracker eqnAttrTracker = null;
    final Object[][] startParseTable = new Object[][]{{ParseState.NONE, "graph", ParseState.GRAPH, new HandleGraph()}, {ParseState.GRAPH, "att", ParseState.NETATT, new HandleNetworkAttribute()}, {ParseState.NETATT, "rdf", ParseState.RDF, null}, {ParseState.RDF, "description", ParseState.RDFDESC, new handleRDF()}, {ParseState.RDFDESC, "type", ParseState.RDFDESC, null}, {ParseState.RDFDESC, "description", ParseState.RDFDESC, null}, {ParseState.RDFDESC, "identifier", ParseState.RDFDESC, null}, {ParseState.RDFDESC, "date", ParseState.RDFDESC, null}, {ParseState.RDFDESC, "title", ParseState.RDFDESC, null}, {ParseState.RDFDESC, "source", ParseState.RDFDESC, null}, {ParseState.RDFDESC, "format", ParseState.RDFDESC, null}, {ParseState.GRAPH, "node", ParseState.NODE, new handleNode()}, {ParseState.NODE, "graphics", ParseState.NODEGRAPHICS, new handleNodeGraphics()}, {ParseState.NODE, "att", ParseState.NODEATT, new handleNodeAttribute()}, {ParseState.NODEGRAPHICS, "att", ParseState.NODEGRAPHICS, new handleNodeGraphics()}, {ParseState.NODEATT, "graph", ParseState.GROUP, new handleGroup()}, {ParseState.GROUP, "node", ParseState.NODE, new handleGroupNode()}, {ParseState.GROUP, "edge", ParseState.EDGE, new handleEdge()}, {ParseState.GRAPH, "edge", ParseState.EDGE, new handleEdge()}, {ParseState.EDGE, "att", ParseState.EDGEATT, new handleEdgeAttribute()}, {ParseState.EDGE, "graphics", ParseState.EDGEGRAPHICS, new handleEdgeGraphics()}, {ParseState.EDGEGRAPHICS, "att", ParseState.EDGEGRAPHICS, new handleEdgeGraphics()}, {ParseState.EDGEBEND, "att", ParseState.EDGEHANDLE, new handleEdgeHandle()}, {ParseState.EDGEHANDLE, "att", ParseState.EDGEHANDLE, new handleEdgeHandle()}, {ParseState.LISTATT, "att", ParseState.LISTELEMENT, new handleListAttribute()}, {ParseState.LISTELEMENT, "att", ParseState.LISTELEMENT, new handleListAttribute()}, {ParseState.MAPATT, "att", ParseState.MAPELEMENT, new handleMapAttribute()}, {ParseState.MAPELEMENT, "att", ParseState.MAPELEMENT, new handleListAttribute()}, {ParseState.COMPLEXATT, "att", ParseState.COMPLEXATT, new handleComplexAttribute()}};
    final Object[][] endParseTable = new Object[][]{{ParseState.RDFDESC, "type", ParseState.RDFDESC, new handleRDFType()}, {ParseState.RDFDESC, "description", ParseState.RDFDESC, new handleRDFDescription()}, {ParseState.RDFDESC, "identifier", ParseState.RDFDESC, new handleRDFIdentifier()}, {ParseState.RDFDESC, "date", ParseState.RDFDESC, new handleRDFDate()}, {ParseState.RDFDESC, "title", ParseState.RDFDESC, new handleRDFTitle()}, {ParseState.RDFDESC, "source", ParseState.RDFDESC, new handleRDFSource()}, {ParseState.RDFDESC, "format", ParseState.RDFDESC, new handleRDFFormat()}, {ParseState.GROUP, "graph", ParseState.NONE, new handleGroupDone()}, {ParseState.EDGEHANDLE, "att", ParseState.EDGEBEND, new handleEdgeHandleDone()}, {ParseState.EDGEBEND, "att", ParseState.EDGEBEND, new handleEdgeHandleList()}, {ParseState.COMPLEXATT, "att", ParseState.COMPLEXATT, new handleComplexAttributeDone()}, {ParseState.GRAPH, "graph", ParseState.NONE, new HandleGraphDone()}, {ParseState.LISTATT, "att", ParseState.NONE, new handleListAttributeDone()}, {ParseState.MAPATT, "att", ParseState.NONE, new handleMapAttributeDone()}};
    private List listAttrHolder;
    private Map mapAttrHolder;

    static String getAttributeValue(Attributes atts, String key) {
        String name = atts.getValue("name");
        if (name == null) {
            name = atts.getValue("label");
        }
        if (name != null && name.equals(key)) {
            return atts.getValue("value");
        }
        return null;
    }

    double getDoubleAttributeValue(Attributes atts, String key) throws SAXParseException {
        String attribute = XGMMLParser.getAttributeValue(atts, key);
        if (attribute == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(attribute);
        }
        catch (Exception e) {
            throw new SAXParseException("Unable to convert '" + attribute + "' to a DOUBLE", this.locator);
        }
    }

    Object getTypedAttributeValueOrEquation(ObjectType type, Attributes atts) throws SAXParseException {
        String value = atts.getValue("value");
        if (value != null && value.length() >= 2 && value.charAt(0) == '=') {
            return value;
        }
        try {
            return XGMMLParser.getTypedValue(type, value);
        }
        catch (Exception e) {
            throw new SAXParseException("Unable to convert '" + value + "' to type " + type.toString(), this.locator);
        }
    }

    Object getTypedAttributeValue(ObjectType type, Attributes atts) throws SAXParseException {
        String value = atts.getValue("value");
        try {
            return XGMMLParser.getTypedValue(type, value);
        }
        catch (Exception e) {
            throw new SAXParseException("Unable to convert '" + value + "' to type " + type.toString(), this.locator);
        }
    }

    static Object getTypedValue(ObjectType type, String value) {
        switch (type) {
            case BOOLEAN: {
                if (value == null) break;
                return new Boolean(value);
            }
            case REAL: {
                if (value == null) break;
                return new Double(value);
            }
            case INTEGER: {
                if (value == null) break;
                return new Integer(value);
            }
            case STRING: {
                if (value == null) break;
                String sAttr = value.replace("\\t", "\t");
                sAttr = sAttr.replace("\\n", "\n");
                return sAttr;
            }
            case LIST: {
                return new ArrayList();
            }
            case MAP: {
                return new HashMap();
            }
        }
        return null;
    }

    static String getAttribute(Attributes atts, String key) {
        return atts.getValue(key);
    }

    static String getAttributeNS(Attributes atts, String key, String ns) {
        if (atts.getValue(ns, key) != null) {
            return atts.getValue(ns, key);
        }
        return atts.getValue(key);
    }

    static int getIntegerAttribute(Attributes atts, String key) {
        String attribute = atts.getValue(key);
        if (attribute == null) {
            return 0;
        }
        return new Integer(attribute);
    }

    static int getIntegerAttributeNS(Attributes atts, String key, String ns) {
        String attribute = atts.getValue(ns, key);
        if (attribute == null) {
            return 0;
        }
        return new Integer(attribute);
    }

    static double getDoubleAttribute(Attributes atts, String key) {
        String attribute = atts.getValue(key);
        if (attribute == null) {
            return 0.0;
        }
        return new Double(attribute);
    }

    static double getDoubleAttributeNS(Attributes atts, String key, String ns) {
        String attribute = atts.getValue(ns, key);
        if (attribute == null) {
            return 0.0;
        }
        return new Double(attribute);
    }

    static Color getColorAttribute(Attributes atts, String key) {
        String attribute = atts.getValue(key);
        if (attribute == null) {
            return null;
        }
        return new Color(Integer.parseInt(attribute.substring(1), 16));
    }

    XGMMLParser() {
        this.stateStack = new Stack();
        this.groupStack = new Stack();
        this.nodeList = new ArrayList<CyNode>();
        this.edgeList = new ArrayList<CyEdge>();
        this.nodeLinks = new HashMap();
        this.nodeGraphicsMap = new HashMap();
        this.edgeGraphicsMap = new HashMap();
        this.idMap = new HashMap();
        this.eqnAttrTracker = Cytoscape.getEqnAttrTracker();
    }

    int[] getNodeIndicesArray() {
        int[] array = new int[this.nodeList.size()];
        for (int i = 0; i < this.nodeList.size(); ++i) {
            array[i] = this.nodeList.get(i).getRootGraphIndex();
        }
        return array;
    }

    int[] getEdgeIndicesArray() {
        int[] array = new int[this.edgeList.size()];
        for (int i = 0; i < this.edgeList.size(); ++i) {
            array[i] = this.edgeList.get(i).getRootGraphIndex();
        }
        return array;
    }

    String getNetworkName() {
        return this.networkName;
    }

    private Class mapCytoscapeAttribTypeToEqnType(byte attribType) {
        switch (attribType) {
            case 1: {
                return Boolean.class;
            }
            case 3: {
                return Long.class;
            }
            case 2: {
                return Double.class;
            }
            case 4: {
                return String.class;
            }
            case -2: {
                return List.class;
            }
        }
        throw new IllegalStateException("can't map Cytoscape type " + attribType + " to equation return type!");
    }

    HashMap<CyNode, Attributes> getNodeGraphics() {
        return this.nodeGraphicsMap;
    }

    HashMap<CyEdge, Attributes> getEdgeGraphics() {
        return this.edgeGraphicsMap;
    }

    Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            return null;
        }
        return new Color(Integer.parseInt(this.backgroundColor.substring(1), 16));
    }

    double getGraphViewZoomLevel() {
        return this.graphZoom;
    }

    Point2D getGraphViewCenter() {
        if (this.graphCenterX == 0.0 && this.graphCenterY == 0.0) {
            return null;
        }
        return new Point2D.Double(this.graphCenterX, this.graphCenterY);
    }

    HashMap<CyNode, List<CyNode>> getGroupMap() {
        return this.groupMap;
    }

    void setMetaData(CyNetwork network) {
        MetadataParser mdp = new MetadataParser(network);
        if (this.RDFType != null) {
            mdp.setMetadata(MetadataEntries.TYPE, this.RDFType);
        }
        if (this.RDFDate != null) {
            mdp.setMetadata(MetadataEntries.DATE, this.RDFDate);
        }
        if (this.RDFTitle != null) {
            mdp.setMetadata(MetadataEntries.TITLE, this.RDFTitle);
        }
        if (this.RDFDescription != null) {
            mdp.setMetadata(MetadataEntries.DESCRIPTION, this.RDFDescription);
        }
        if (this.RDFSource != null) {
            mdp.setMetadata(MetadataEntries.SOURCE, this.RDFSource);
        }
        if (this.RDFFormat != null) {
            mdp.setMetadata(MetadataEntries.FORMAT, this.RDFFormat);
        }
        if (this.RDFIdentifier != null) {
            mdp.setMetadata(MetadataEntries.IDENTIFIER, this.RDFIdentifier);
        }
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
        ParseState nextState = this.handleState(this.startParseTable, this.parseState, localName, atts);
        this.stateStack.push(this.parseState);
        this.parseState = nextState;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleState(this.endParseTable, this.parseState, localName, null);
        this.parseState = this.stateStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentCData = new String(ch, start, length);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String err = "Fatal parsing error on line " + e.getLineNumber() + " -- '" + e.getMessage() + "'";
        throw new SAXException(err);
    }

    @Override
    public void error(SAXParseException e) {
        logger.warn("Parsing error on line " + e.getLineNumber() + " -- '" + e.getMessage() + "'.  Attempting to recover");
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private ParseState handleState(Object[][] table, ParseState currentState, String tag, Attributes atts) throws SAXException {
        for (int i = 0; i < table.length; ++i) {
            if (table[i][0] != currentState || !tag.equals(table[i][1])) continue;
            Handler handler = (Handler)table[i][3];
            if (handler != null) {
                return handler.handle(tag, atts, (ParseState)((Object)table[i][2]));
            }
            return (ParseState)((Object)table[i][2]);
        }
        return currentState;
    }

    public static String printAttributes(Attributes atts) {
        String str = " ";
        for (int i = 0; i < atts.getLength(); ++i) {
            str = str + atts.getLocalName(i) + ": " + atts.getValue(i) + ", ";
        }
        return str;
    }

    private static String getLabel(Attributes att) {
        String label = att.getValue("label");
        if (label != null) {
            return label;
        }
        return att.getValue("id");
    }

    private ParseState handleAttribute(Attributes atts, CyAttributes cyAtts, String id) throws SAXException {
        String eqString;
        String name = atts.getValue("name");
        ObjectType objType = this.getType(atts.getValue("type"));
        Object obj = this.getTypedAttributeValueOrEquation(objType, atts);
        boolean hidden = false;
        boolean editable = true;
        boolean equation = false;
        String hString = atts.getValue("cy:hidden");
        if (hString != null) {
            hidden = Boolean.parseBoolean(hString);
        }
        String eString = atts.getValue("cy:editable");
        if (hString != null) {
            editable = Boolean.parseBoolean(hString);
        }
        if ((eqString = atts.getValue("cy:equation")) != null) {
            equation = Boolean.parseBoolean(eqString);
        }
        switch (objType) {
            case BOOLEAN: {
                if (obj == null || name == null || id == null) break;
                if (equation) {
                    this.eqnAttrTracker.recordEquation(cyAtts, id, name, (String)obj, Boolean.class);
                    break;
                }
                cyAtts.setAttribute(id, name, (Boolean)obj);
                break;
            }
            case REAL: {
                if (obj == null || name == null || id == null) break;
                if (equation) {
                    this.eqnAttrTracker.recordEquation(cyAtts, id, name, (String)obj, Double.class);
                    break;
                }
                cyAtts.setAttribute(id, name, (Double)obj);
                break;
            }
            case INTEGER: {
                if (obj == null || name == null || id == null) break;
                if (equation) {
                    this.eqnAttrTracker.recordEquation(cyAtts, id, name, (String)obj, Long.class);
                    break;
                }
                cyAtts.setAttribute(id, name, (Integer)obj);
                break;
            }
            case STRING: {
                if (obj == null || name == null || id == null) break;
                if (equation) {
                    this.eqnAttrTracker.recordEquation(cyAtts, id, name, (String)obj, String.class);
                    break;
                }
                cyAtts.setAttribute(id, name, (String)obj);
                break;
            }
            case LIST: {
                this.currentAttributeID = name;
                if (id != null && cyAtts.hasAttribute(id, name)) {
                    if (equation) {
                        this.eqnAttrTracker.recordEquation(cyAtts, id, name, (String)obj, List.class);
                    } else {
                        cyAtts.deleteAttribute(id, name);
                    }
                }
                this.listAttrHolder = new ArrayList();
                return ParseState.LISTATT;
            }
            case MAP: {
                this.currentAttributeID = name;
                if (id != null && cyAtts.hasAttribute(id, name)) {
                    cyAtts.deleteAttribute(id, name);
                }
                this.mapAttrHolder = new HashMap();
                return ParseState.MAPATT;
            }
            case COMPLEX: {
                this.currentAttributeID = name;
                if (id != null && cyAtts.hasAttribute(id, name)) {
                    cyAtts.deleteAttribute(id, name);
                }
                this.numKeys = Integer.parseInt(atts.getValue("value"));
                this.complexMap = new HashMap[this.numKeys];
                this.complexKey = new Object[this.numKeys];
                this.attributeDefinition = new byte[this.numKeys];
                this.mhm = this.currentAttributes.getMultiHashMap();
                this.level = 0;
                return ParseState.COMPLEXATT;
            }
        }
        if (hidden) {
            cyAtts.setUserVisible(name, false);
        }
        if (!editable) {
            cyAtts.setUserEditable(name, false);
        }
        return ParseState.NONE;
    }

    private boolean multihashmapdefExists(CyAttributes attributes, String attributeName) {
        MultiHashMapDefinition mhmd = attributes.getMultiHashMapDefinition();
        CountedIterator defIt = mhmd.getDefinedAttributes();
        while (defIt.hasNext()) {
            String thisDef = (String)defIt.next();
            if (thisDef == null || !thisDef.equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    private void defineComplexAttribute(String attributeName, CyAttributes attributes, byte[] attributeDefinition) {
        MultiHashMapDefinition mhmd = attributes.getMultiHashMapDefinition();
        mhmd.defineAttribute(attributeName, this.valueType, attributeDefinition);
    }

    private byte getMultHashMapType(ObjectType objectType) {
        switch (objectType) {
            case BOOLEAN: {
                return 1;
            }
            case STRING: {
                return 4;
            }
            case INTEGER: {
                return 3;
            }
            case REAL: {
                return 2;
            }
        }
        return -1;
    }

    private CyNode createUniqueNode(String label, String id) throws SAXException {
        if (label != null && id == null) {
            id = label;
        }
        CyNode node = Cytoscape.getCyNode(label, true);
        this.nodeList.add(node);
        this.idMap.put(id, node);
        return node;
    }

    private CyEdge createEdge(CyNode source, CyNode target, String interaction, String label) throws SAXException {
        CyEdge edge = Cytoscape.getCyEdge(source, target, "interaction", interaction, true, true);
        this.edgeList.add(edge);
        return edge;
    }

    private CyEdge createEdge(String source, String target, String interaction, String label) {
        if (Cytoscape.getCyNode(source, false) == null) {
            String warn = "Warning: skipping edge " + label + "\n";
            warn = warn + "         node " + source + " doesn't exist";
            logger.warn(warn);
            return null;
        }
        if (Cytoscape.getCyNode(target, false) == null) {
            String warn = "Warning: skipping edge " + label + "\n";
            warn = warn + "         node " + target + " doesn't exist";
            logger.warn(warn);
            return null;
        }
        CyEdge edge = Cytoscape.getCyEdge(source, label, target, interaction);
        this.edgeList.add(edge);
        return edge;
    }

    private void addAttributes(Attributes attI, Attributes atts) {
        String localName = null;
        String qName = null;
        String type = null;
        String uri = null;
        String value = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            localName = atts.getLocalName(i);
            uri = atts.getURI(i);
            value = atts.getValue(i);
            type = atts.getType(i);
            qName = atts.getQName(i);
            ((AttributesImpl)attI).addAttribute(uri, localName, qName, type, value);
        }
    }

    private ObjectType getType(String type) {
        if (type == null) {
            return ObjectType.STRING;
        }
        if (type.equals("string")) {
            return ObjectType.STRING;
        }
        if (type.equals("boolean")) {
            return ObjectType.BOOLEAN;
        }
        if (type.equals("real")) {
            return ObjectType.REAL;
        }
        if (type.equals("integer")) {
            return ObjectType.INTEGER;
        }
        if (type.equals("list")) {
            return ObjectType.LIST;
        }
        if (type.equals("map")) {
            return ObjectType.MAP;
        }
        if (type.equals("complex")) {
            return ObjectType.COMPLEX;
        }
        return ObjectType.NONE;
    }

    class handleRDFFormat
    implements Handler {
        handleRDFFormat() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFFormat = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDFSource
    implements Handler {
        handleRDFSource() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFSource = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDFTitle
    implements Handler {
        handleRDFTitle() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFTitle = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDFDate
    implements Handler {
        handleRDFDate() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFDate = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDFIdentifier
    implements Handler {
        handleRDFIdentifier() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFIdentifier = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDFDescription
    implements Handler {
        handleRDFDescription() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFDescription = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDFType
    implements Handler {
        handleRDFType() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.RDFType = XGMMLParser.this.currentCData;
            return current;
        }
    }

    class handleRDF
    implements Handler {
        handleRDF() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            return current;
        }
    }

    class handleComplexAttributeDone
    implements Handler {
        handleComplexAttributeDone() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (XGMMLParser.this.level != 0 && XGMMLParser.this.level < XGMMLParser.this.numKeys) {
                ((XGMMLParser)XGMMLParser.this).complexMap[((XGMMLParser)XGMMLParser.this).level] = null;
                ((XGMMLParser)XGMMLParser.this).complexKey[((XGMMLParser)XGMMLParser.this).level] = null;
            }
            XGMMLParser.this.level--;
            return current;
        }
    }

    class handleComplexAttribute
    implements Handler {
        handleComplexAttribute() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            ObjectType type = XGMMLParser.this.getType(atts.getValue("type"));
            String value = atts.getValue("value");
            if (XGMMLParser.this.level == XGMMLParser.this.numKeys) {
                XGMMLParser.this.complexMap[XGMMLParser.this.level - 1].put(XGMMLParser.this.complexKey[XGMMLParser.this.level - 1], XGMMLParser.getTypedValue(type, value));
                XGMMLParser.this.valueType = XGMMLParser.this.getMultHashMapType(type);
                if (!XGMMLParser.this.multihashmapdefExists(XGMMLParser.this.currentAttributes, XGMMLParser.this.currentAttributeID)) {
                    XGMMLParser.this.defineComplexAttribute(XGMMLParser.this.currentAttributeID, XGMMLParser.this.currentAttributes, XGMMLParser.this.attributeDefinition);
                }
                if (XGMMLParser.this.objectTarget != null) {
                    XGMMLParser.this.mhm.setAttributeValue(XGMMLParser.this.objectTarget, XGMMLParser.this.currentAttributeID, XGMMLParser.getTypedValue(type, value), XGMMLParser.this.complexKey);
                }
            } else if (XGMMLParser.this.level == 0) {
                if (XGMMLParser.this.complexMap[XGMMLParser.this.level] == null) {
                    ((XGMMLParser)XGMMLParser.this).complexMap[((XGMMLParser)XGMMLParser.this).level] = new HashMap();
                }
                ((XGMMLParser)XGMMLParser.this).complexKey[((XGMMLParser)XGMMLParser.this).level] = XGMMLParser.getTypedValue(type, atts.getValue("name"));
                ((XGMMLParser)XGMMLParser.this).attributeDefinition[((XGMMLParser)XGMMLParser.this).level] = XGMMLParser.this.getMultHashMapType(type);
            } else {
                if (XGMMLParser.this.complexMap[XGMMLParser.this.level] == null) {
                    ((XGMMLParser)XGMMLParser.this).complexMap[((XGMMLParser)XGMMLParser.this).level] = new HashMap();
                }
                XGMMLParser.this.complexMap[XGMMLParser.this.level - 1].put(XGMMLParser.this.complexKey[XGMMLParser.this.level - 1], XGMMLParser.this.complexMap[XGMMLParser.this.level]);
                ((XGMMLParser)XGMMLParser.this).complexKey[((XGMMLParser)XGMMLParser.this).level] = XGMMLParser.getTypedValue(type, atts.getValue("name"));
                ((XGMMLParser)XGMMLParser.this).attributeDefinition[((XGMMLParser)XGMMLParser.this).level] = XGMMLParser.this.getMultHashMapType(type);
            }
            XGMMLParser.this.level++;
            return current;
        }
    }

    class handleMapAttributeDone
    implements Handler {
        handleMapAttributeDone() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            try {
                if (XGMMLParser.this.mapAttrHolder != null) {
                    XGMMLParser.this.currentAttributes.setMapAttribute(XGMMLParser.this.objectTarget, XGMMLParser.this.currentAttributeID, XGMMLParser.this.mapAttrHolder);
                    XGMMLParser.this.mapAttrHolder = null;
                }
            }
            catch (Exception e) {
                String err = "XGMML attribute handling error for attribute '" + XGMMLParser.this.currentAttributeID + "' and object '" + XGMMLParser.this.objectTarget + "': " + e.getMessage();
                throw new SAXException(err);
            }
            return current;
        }
    }

    class handleMapAttribute
    implements Handler {
        handleMapAttribute() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            String name = atts.getValue("name");
            ObjectType objType = XGMMLParser.this.getType(atts.getValue("type"));
            Object obj = XGMMLParser.this.getTypedAttributeValue(objType, atts);
            switch (objType) {
                case BOOLEAN: 
                case REAL: 
                case INTEGER: 
                case STRING: {
                    XGMMLParser.this.mapAttrHolder.put(name, obj);
                }
            }
            return current;
        }
    }

    class handleListAttributeDone
    implements Handler {
        handleListAttributeDone() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            try {
                if (XGMMLParser.this.listAttrHolder != null) {
                    XGMMLParser.this.currentAttributes.setListAttribute(XGMMLParser.this.objectTarget, XGMMLParser.this.currentAttributeID, XGMMLParser.this.listAttrHolder);
                    XGMMLParser.this.listAttrHolder = null;
                }
            }
            catch (Exception e) {
                String err = "XGMML attribute handling error for attribute '" + XGMMLParser.this.currentAttributeID + "' and object '" + XGMMLParser.this.objectTarget + "': " + e.getMessage();
                throw new SAXException(err);
            }
            return current;
        }
    }

    class handleListAttribute
    implements Handler {
        handleListAttribute() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            ObjectType objType = XGMMLParser.this.getType(atts.getValue("type"));
            Object obj = XGMMLParser.this.getTypedAttributeValue(objType, atts);
            String name = atts.getValue("name");
            switch (objType) {
                case BOOLEAN: 
                case REAL: 
                case INTEGER: 
                case STRING: {
                    XGMMLParser.this.listAttrHolder.add(obj);
                }
            }
            return current;
        }
    }

    class handleGroupDone
    implements Handler {
        handleGroupDone() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.currentNode = XGMMLParser.this.currentGroupNode;
            if (!XGMMLParser.this.groupStack.empty()) {
                XGMMLParser.this.currentGroupNode = (CyNode)XGMMLParser.this.groupStack.pop();
            } else {
                XGMMLParser.this.currentGroupNode = null;
            }
            return current;
        }
    }

    class handleEdgeHandleList
    implements Handler {
        handleEdgeHandleList() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (XGMMLParser.this.handleList != null) {
                String list = "";
                for (int i = 0; i < XGMMLParser.this.handleList.size(); ++i) {
                    list = i != XGMMLParser.this.handleList.size() - 1 ? list + (String)XGMMLParser.this.handleList.get(i) + ";" : list + (String)XGMMLParser.this.handleList.get(i);
                }
                ((AttributesImpl)XGMMLParser.this.edgeGraphicsMap.get(XGMMLParser.this.currentEdge)).addAttribute("", "", "edgeHandleList", "string", list);
                XGMMLParser.this.handleList = null;
            }
            return current;
        }
    }

    class handleEdgeHandleDone
    implements Handler {
        handleEdgeHandleDone() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (XGMMLParser.this.edgeBendX != null && XGMMLParser.this.edgeBendY != null && XGMMLParser.this.handleList != null) {
                XGMMLParser.this.handleList.add(XGMMLParser.this.edgeBendX + "," + XGMMLParser.this.edgeBendY);
                XGMMLParser.this.edgeBendX = null;
                XGMMLParser.this.edgeBendY = null;
            }
            return current;
        }
    }

    class handleEdgeHandle
    implements Handler {
        handleEdgeHandle() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (XGMMLParser.this.documentVersion == 1.0) {
                if (XGMMLParser.getAttribute(atts, "name").equals("handle")) return current;
                if (XGMMLParser.getAttributeValue(atts, "x") != null) {
                    XGMMLParser.this.edgeBendX = XGMMLParser.getAttributeValue(atts, "x");
                    return current;
                } else {
                    if (XGMMLParser.getAttributeValue(atts, "y") == null) throw new SAXException("expected x or y value for edgeBend handle - got " + atts.getValue("name"));
                    XGMMLParser.this.edgeBendY = XGMMLParser.getAttributeValue(atts, "y");
                }
                return current;
            } else {
                if (XGMMLParser.getAttribute(atts, "x") != null) {
                    XGMMLParser.this.edgeBendX = XGMMLParser.getAttribute(atts, "x");
                }
                if (XGMMLParser.getAttribute(atts, "y") != null) {
                    XGMMLParser.this.edgeBendY = XGMMLParser.getAttribute(atts, "y");
                }
                if (XGMMLParser.this.edgeBendX == null || XGMMLParser.this.edgeBendY == null) return current;
                if (XGMMLParser.this.handleList == null) {
                    XGMMLParser.this.handleList = new ArrayList();
                }
                XGMMLParser.this.handleList.add(XGMMLParser.this.edgeBendX + "," + XGMMLParser.this.edgeBendY);
                XGMMLParser.this.edgeBendX = null;
                XGMMLParser.this.edgeBendY = null;
            }
            return current;
        }
    }

    class handleGroupNode
    implements Handler {
        handleGroupNode() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            String id = atts.getValue("id");
            String label = atts.getValue("label");
            String href = atts.getValue(XGMMLParser.XLINK, "href");
            if (href == null) {
                XGMMLParser.this.currentNode = XGMMLParser.this.createUniqueNode(label, id);
            } else {
                id = href.substring(1);
            }
            if (XGMMLParser.this.currentGroupNode == null) {
                throw new SAXException("No group to add node reference to");
            }
            if (XGMMLParser.this.idMap.containsKey(id)) {
                CyNode node = (CyNode)XGMMLParser.this.idMap.get(id);
                List nodeList = (List)XGMMLParser.this.groupMap.get(XGMMLParser.this.currentGroupNode);
                nodeList.add(node);
            } else {
                if (!XGMMLParser.this.nodeLinks.containsKey(XGMMLParser.this.currentGroupNode)) {
                    XGMMLParser.this.nodeLinks.put(XGMMLParser.this.currentGroupNode, new ArrayList());
                }
                List links = (List)XGMMLParser.this.nodeLinks.get(XGMMLParser.this.currentGroupNode);
                links.add(id);
            }
            return current;
        }
    }

    class handleGroup
    implements Handler {
        handleGroup() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (XGMMLParser.this.groupMap == null) {
                XGMMLParser.this.groupMap = new HashMap();
            }
            if (XGMMLParser.this.currentGroupNode != null) {
                XGMMLParser.this.groupStack.push(XGMMLParser.this.currentGroupNode);
            }
            XGMMLParser.this.currentGroupNode = XGMMLParser.this.currentNode;
            XGMMLParser.this.groupMap.put(XGMMLParser.this.currentGroupNode, new ArrayList());
            return current;
        }
    }

    class handleEdgeGraphics
    implements Handler {
        handleEdgeGraphics() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (tag.equals("graphics")) {
                if (XGMMLParser.this.edgeGraphicsMap.containsKey(XGMMLParser.this.currentEdge)) {
                    XGMMLParser.this.addAttributes((Attributes)XGMMLParser.this.edgeGraphicsMap.get(XGMMLParser.this.currentEdge), atts);
                } else {
                    XGMMLParser.this.edgeGraphicsMap.put(XGMMLParser.this.currentEdge, new AttributesImpl(atts));
                }
            } else if (tag.equals("att")) {
                String name = atts.getValue("name");
                if (name != null && name.equals("edgeBend")) {
                    XGMMLParser.this.handleList = new ArrayList();
                    return ParseState.EDGEBEND;
                }
                if (name != null && !name.equals("cytoscapeEdgeGraphicsAttributes")) {
                    ((AttributesImpl)XGMMLParser.this.edgeGraphicsMap.get(XGMMLParser.this.currentEdge)).addAttribute("", "", "cy:" + name, "string", atts.getValue("value"));
                }
            }
            return current;
        }
    }

    class handleEdgeAttribute
    implements Handler {
        handleEdgeAttribute() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.attState = current;
            XGMMLParser.this.currentAttributes = Cytoscape.getEdgeAttributes();
            if (XGMMLParser.this.currentEdge != null) {
                XGMMLParser.this.objectTarget = XGMMLParser.this.currentEdge.getIdentifier();
            } else {
                XGMMLParser.this.objectTarget = null;
            }
            ParseState nextState = XGMMLParser.this.handleAttribute(atts, XGMMLParser.this.currentAttributes, XGMMLParser.this.objectTarget);
            if (nextState != ParseState.NONE) {
                return nextState;
            }
            return current;
        }
    }

    class handleEdge
    implements Handler {
        handleEdge() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            String label = atts.getValue("label");
            String source = atts.getValue("source");
            String target = atts.getValue("target");
            String sourceAlias = null;
            String targetAlias = null;
            String interaction = "pp";
            int interactionStart = label.indexOf(40);
            int interactionEnd = label.lastIndexOf(41);
            if (interactionStart != -1 && interactionEnd != -1) {
                sourceAlias = label.substring(0, interactionStart - 1);
                if (sourceAlias.length() > 0) {
                    sourceAlias = sourceAlias.trim();
                }
                if ((interaction = label.substring(interactionStart + 1, interactionEnd)).length() > 0) {
                    interaction = interaction.trim();
                }
                if ((targetAlias = label.substring(interactionEnd + 1)).length() > 0) {
                    targetAlias = targetAlias.trim();
                }
            }
            if (XGMMLParser.this.idMap.containsKey(source) && XGMMLParser.this.idMap.containsKey(target)) {
                CyNode sourceNode = (CyNode)XGMMLParser.this.idMap.get(source);
                CyNode targetNode = (CyNode)XGMMLParser.this.idMap.get(target);
                XGMMLParser.this.currentEdge = XGMMLParser.this.createEdge(sourceNode, targetNode, interaction, label);
            } else if (sourceAlias != null && targetAlias != null) {
                XGMMLParser.this.currentEdge = XGMMLParser.this.createEdge(sourceAlias, targetAlias, interaction, label);
            }
            return current;
        }
    }

    class handleNodeGraphics
    implements Handler {
        handleNodeGraphics() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            String name;
            if (tag.equals("graphics")) {
                if (XGMMLParser.this.nodeGraphicsMap.containsKey(XGMMLParser.this.currentNode)) {
                    XGMMLParser.this.addAttributes((Attributes)XGMMLParser.this.nodeGraphicsMap.get(XGMMLParser.this.currentNode), atts);
                } else {
                    XGMMLParser.this.nodeGraphicsMap.put(XGMMLParser.this.currentNode, new AttributesImpl(atts));
                }
            } else if (tag.equals("att") && (name = atts.getValue("name")) != null && !name.equals("cytoscapeNodeGraphicsAttributes")) {
                ((AttributesImpl)XGMMLParser.this.nodeGraphicsMap.get(XGMMLParser.this.currentNode)).addAttribute("", "", "cy:" + name, "string", atts.getValue("value"));
            }
            return current;
        }
    }

    class handleNodeAttribute
    implements Handler {
        handleNodeAttribute() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (atts == null) {
                return current;
            }
            XGMMLParser.this.attState = current;
            String name = atts.getValue("name");
            if (name == null && atts.getValue("value") == null) {
                return current;
            }
            if (name.startsWith("node.")) {
                name = atts.getValue("name").substring(5);
                String value = atts.getValue("value");
                if (!XGMMLParser.this.nodeGraphicsMap.containsKey(XGMMLParser.this.currentNode)) {
                    XGMMLParser.this.nodeGraphicsMap.put(XGMMLParser.this.currentNode, new AttributesImpl());
                }
                ((AttributesImpl)XGMMLParser.this.nodeGraphicsMap.get(XGMMLParser.this.currentNode)).addAttribute("", "", name, "string", value);
            }
            XGMMLParser.this.currentAttributes = Cytoscape.getNodeAttributes();
            XGMMLParser.this.objectTarget = XGMMLParser.this.currentNode.getIdentifier();
            ParseState nextState = XGMMLParser.this.handleAttribute(atts, XGMMLParser.this.currentAttributes, XGMMLParser.this.objectTarget);
            if (nextState != ParseState.NONE) {
                return nextState;
            }
            return current;
        }
    }

    class handleNode
    implements Handler {
        handleNode() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            String href;
            String id = atts.getValue("id");
            String label = atts.getValue("label");
            if (label == null) {
                label = atts.getValue("name");
            }
            if ((href = atts.getValue(XGMMLParser.XLINK, "href")) != null) {
                throw new SAXException("Can't have a node reference outside of a group");
            }
            XGMMLParser.this.currentNode = XGMMLParser.this.createUniqueNode(label, id);
            return current;
        }
    }

    class HandleNetworkAttribute
    implements Handler {
        HandleNetworkAttribute() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            XGMMLParser.this.currentAttributes = Cytoscape.getNetworkAttributes();
            XGMMLParser.this.attState = current;
            ParseState nextState = current;
            if (XGMMLParser.getAttributeValue(atts, "backgroundColor") != null) {
                XGMMLParser.this.backgroundColor = XGMMLParser.getAttributeValue(atts, "backgroundColor");
            } else if (XGMMLParser.getAttributeValue(atts, "documentVersion") != null) {
                XGMMLParser.this.documentVersion = XGMMLParser.this.getDoubleAttributeValue(atts, "documentVersion");
            } else if (XGMMLParser.getAttributeValue(atts, "GRAPH_VIEW_ZOOM") != null) {
                XGMMLParser.this.graphZoom = XGMMLParser.this.getDoubleAttributeValue(atts, "GRAPH_VIEW_ZOOM");
            } else if (XGMMLParser.getAttributeValue(atts, "GRAPH_VIEW_CENTER_X") != null) {
                XGMMLParser.this.graphCenterX = XGMMLParser.this.getDoubleAttributeValue(atts, "GRAPH_VIEW_CENTER_X");
            } else if (XGMMLParser.getAttributeValue(atts, "GRAPH_VIEW_CENTER_Y") != null) {
                XGMMLParser.this.graphCenterY = XGMMLParser.this.getDoubleAttributeValue(atts, "GRAPH_VIEW_CENTER_Y");
            } else {
                XGMMLParser.this.objectTarget = XGMMLParser.this.networkName;
                nextState = XGMMLParser.this.handleAttribute(atts, XGMMLParser.this.currentAttributes, XGMMLParser.this.networkName);
            }
            if (nextState != ParseState.NONE) {
                return nextState;
            }
            return current;
        }
    }

    class HandleGraphDone
    implements Handler {
        HandleGraphDone() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            if (XGMMLParser.this.nodeLinks != null) {
                for (CyNode groupNode : XGMMLParser.this.nodeLinks.keySet()) {
                    if (!XGMMLParser.this.groupMap.containsKey(groupNode)) {
                        XGMMLParser.this.groupMap.put(groupNode, new ArrayList());
                    }
                    List groupList = (List)XGMMLParser.this.groupMap.get(groupNode);
                    for (String ref : (List)XGMMLParser.this.nodeLinks.get(groupNode)) {
                        if (!XGMMLParser.this.idMap.containsKey(ref)) continue;
                        groupList.add(XGMMLParser.this.idMap.get(ref));
                    }
                }
            }
            return current;
        }
    }

    class HandleGraph
    implements Handler {
        HandleGraph() {
        }

        public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
            String name = XGMMLParser.getLabel(atts);
            if (name != null) {
                XGMMLParser.this.networkName = name;
            }
            return current;
        }
    }
}

