/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationFlatFileReader;
import cytoscape.data.annotation.readers.OntologyFlatFileReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.logger.CyLogger;
import java.io.File;

public class loadAnnotationFromFlatFiles {
    public static void main(String[] args) throws Exception {
        File ontologyFile;
        if (args.length != 3) {
            CyLogger.getLogger().warn("usage:  loadAnnotationFromFaltFile <server name> <annotation.txt> <ontology.txt>");
            System.exit(1);
        }
        String serverName = args[0];
        BioDataServer server = new BioDataServer(serverName);
        String annotationFilename = args[1];
        String ontologyFilename = args[2];
        File annotationFile = new File(annotationFilename);
        if (!annotationFile.canRead()) {
            CyLogger.getLogger().warn("--- cytoscape.data.servers.loadAnnotationFromFlatfiles error:  cannot read");
            CyLogger.getLogger().warn("        " + annotationFilename);
            System.exit(1);
        }
        if (!(ontologyFile = new File(ontologyFilename)).canRead()) {
            CyLogger.getLogger().warn("--- cytoscape.data.servers.loadAnnotationFromFlatfiles error:  cannot read");
            CyLogger.getLogger().warn("        " + ontologyFilename);
            System.exit(1);
        }
        AnnotationFlatFileReader reader = new AnnotationFlatFileReader(annotationFile);
        Annotation annotation = reader.getAnnotation();
        OntologyFlatFileReader ontologyReader = new OntologyFlatFileReader(ontologyFile);
        Ontology ontology = ontologyReader.getOntology();
        if (!annotation.getCurator().equals(ontology.getCurator())) {
            CyLogger.getLogger().warn("annotation is curated by " + annotation.getCurator());
            CyLogger.getLogger().warn("ontology is curated by " + ontology.getCurator());
            CyLogger.getLogger().warn(" --> these disagree.  Exiting....");
            System.exit(1);
        }
        annotation.setOntology(ontology);
        server.addAnnotation(annotation);
        CyLogger.getLogger().info(server.describe());
    }
}

