/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CyAttributesWriter {
    public static String newline = System.getProperty("line.separator");
    public static final String ENCODE_PROPERTY = "cytoscape.encode.attributes";
    public static final String ENCODING_SCHEME = "UTF-8";
    private final CyAttributes cyAttributes;
    private final String attributeName;
    private Writer fileWriter;
    private boolean doEncoding;

    public CyAttributesWriter(CyAttributes attributes, String attributeName, Writer fileWriter) {
        this.cyAttributes = attributes;
        this.attributeName = attributeName;
        this.fileWriter = fileWriter;
        this.doEncoding = Boolean.valueOf(System.getProperty(ENCODE_PROPERTY, "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAttributes() throws IOException {
        byte dataType = this.cyAttributes.getMultiHashMapDefinition().getAttributeValueType(this.attributeName);
        if (dataType == -4 || dataType == -3 || dataType == -1) {
            throw new IOException("Unsupported Datatype.");
        }
        String className = dataType == 1 ? "java.lang.Boolean" : (dataType == 3 ? "java.lang.Integer" : (dataType == 2 ? "java.lang.Double" : "java.lang.String"));
        try {
            this.fileWriter.write(this.attributeName + " (class=" + className + ")" + newline);
            MultiHashMap attributeMap = this.cyAttributes.getMultiHashMap();
            if (attributeMap != null) {
                CountedIterator keys = this.cyAttributes.getMultiHashMap().getObjectKeys(this.attributeName);
                StringBuilder result = new StringBuilder();
                while (keys.hasNext()) {
                    String vs;
                    String key = (String)keys.next();
                    Object value = this.cyAttributes.getType(this.attributeName) == -2 ? this.cyAttributes.getListAttribute(key, this.attributeName) : this.cyAttributes.getAttribute(key, this.attributeName);
                    key = this.encodeString(key);
                    if (value == null) continue;
                    if (value instanceof List) {
                        result.append(key + " = ");
                        if (((Collection)value).size() <= 0) continue;
                        Iterator objIt = ((Collection)value).iterator();
                        result.append("(");
                        Object o = objIt.next();
                        vs = o.toString();
                        vs = CyAttributesWriter.slashEncodeString(vs);
                        vs = this.encodeString(vs);
                        result.append(vs);
                        while (objIt.hasNext()) {
                            o = objIt.next();
                            vs = o.toString();
                            vs = CyAttributesWriter.slashEncodeString(vs);
                            vs = this.encodeString(vs);
                            result.append("::" + vs);
                        }
                        result.append(")" + newline);
                        this.fileWriter.write(result.toString());
                        result = new StringBuilder();
                        continue;
                    }
                    vs = value.toString();
                    vs = CyAttributesWriter.slashEncodeString(vs);
                    vs = this.encodeString(vs);
                    this.fileWriter.write(key + " = " + vs + newline);
                }
                this.fileWriter.flush();
            }
            Object var12_11 = null;
            if (this.fileWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (this.fileWriter == null) throw throwable;
            this.fileWriter.close();
            throw throwable;
        }
        this.fileWriter.close();
    }

    private String encodeString(String in) throws UnsupportedEncodingException {
        if (this.doEncoding) {
            in = URLEncoder.encode(in, ENCODING_SCHEME);
        }
        return in;
    }

    private static String slashEncodeString(String in) {
        StringBuilder sb = new StringBuilder(in.length());
        block8: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public boolean isDoEncoding() {
        return this.doEncoding;
    }

    public void setDoEncoding(boolean doEnc) {
        this.doEncoding = doEnc;
    }
}

