/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.dialogs.plugins.TreeNode;
import cytoscape.logger.CyLogger;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerModel
implements TreeModel {
    private TreeNode root;
    protected EventListenerList listenerList = new EventListenerList();

    public ManagerModel(TreeNode Root) {
        this.root = Root;
    }

    public void removeNodesFromParent(List<TreeNode> children) {
        for (TreeNode child : children) {
            this.recursiveRemoveNodeFromParent(child);
        }
    }

    public void removeNodeFromParent(TreeNode child) {
        this.recursiveRemoveNodeFromParent(child);
    }

    private void recursiveRemoveNodeFromParent(TreeNode child) {
        TreeNode Parent2 = child.getParent();
        TreeNode[] Children = new TreeNode[]{child};
        int[] ChildIndicies = new int[]{this.getIndexOfChild(Parent2, child)};
        Parent2.removeChild(child);
        this.nodesRemoved(Parent2, ChildIndicies, Children);
    }

    public void addNodeToParent(TreeNode parent, TreeNode child) {
        parent.addChild(child);
        TreeNode[] Children = new TreeNode[]{child};
        int[] ChildIndicies = new int[]{this.getIndexOfChild(parent, child)};
        this.nodesAdded(parent, ChildIndicies, Children);
    }

    protected void nodesAdded(TreeNode parent, int[] childIndicies, TreeNode[] addedChildren) {
        this.fireTreeNodesAdded(parent, this.getPathToRoot(parent), childIndicies, addedChildren);
    }

    protected void nodesRemoved(TreeNode parent, int[] childIndicies, TreeNode[] removedChildren) {
        this.fireTreeNodesRemoved(parent, this.getPathToRoot(parent), childIndicies, removedChildren);
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode treeNode = (TreeNode)parent;
        return treeNode.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeNode treeNode = (TreeNode)parent;
        return treeNode.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeNode treeNode = (TreeNode)parent;
        return treeNode.getIndexOfChild((TreeNode)child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeNode treeNode = (TreeNode)node;
        return treeNode.getChildCount() == 0 || treeNode.isLeaf();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndicies, Object[] children) {
        TreeModelEvent Event2 = new TreeModelEvent(source, path, childIndicies, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].treeNodesRemoved(Event2);
        }
    }

    protected void fireTreeNodesAdded(Object source, Object[] path, int[] childIndicies, Object[] children) {
        TreeModelEvent Event2 = new TreeModelEvent(source, path, childIndicies, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].treeNodesInserted(Event2);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndicies, Object[] children) {
        TreeModelEvent Event2 = new TreeModelEvent(source, path, childIndicies, children);
        TreeModelListener[] listeners = this.getTreeModelListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].treeStructureChanged(Event2);
        }
    }

    public TreeNode[] getPathToRoot(TreeNode node) {
        return this.getPathToRoot(node, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode node, int depth) {
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            return new TreeNode[depth];
        }
        TreeNode[] path = this.getPathToRoot(node.getParent(), depth + 1);
        path[path.length - depth - 1] = node;
        return path;
    }

    public void reload() {
        int n = this.getChildCount(this.root);
        int[] ChildIndex = new int[n];
        Object[] Children = new Object[n];
        for (int i = 0; i < n; ++i) {
            ChildIndex[i] = i;
            Children[i] = this.getChild(this.root, i);
        }
        this.fireTreeStructureChanged(this, new Object[]{this.root}, ChildIndex, Children);
    }

    public void reload(TreeNode node) {
        int n = this.getChildCount(node);
        int[] ChildIndex = new int[n];
        Object[] Children = new Object[n];
        for (int i = 0; i < n; ++i) {
            ChildIndex[i] = i;
            Children[i] = this.getChild(node, i);
        }
        this.fireTreeStructureChanged(this, new Object[]{node}, ChildIndex, Children);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        CyLogger.getLogger().warn("valueForPathChanged NOT IMPLEMENTED");
    }
}

