/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.CytoscapeVersion;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.dialogs.plugins.LicenseDialog;
import cytoscape.dialogs.plugins.ManagerModel;
import cytoscape.dialogs.plugins.PluginIndex;
import cytoscape.dialogs.plugins.TreeCellRenderer;
import cytoscape.dialogs.plugins.TreeNode;
import cytoscape.dialogs.preferences.EditBookmarkDialog;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.Installable;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginInquireAction;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginManagerInquireTask;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.WebstartException;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.BookmarksUtil;
import cytoscape.util.OpenBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManageDialog
extends JDialog
implements TreeSelectionListener,
ActionListener {
    private static CyLogger logger = CyLogger.getLogger(PluginManageDialog.class);
    public static String CURRENTLY_INSTALLED = "Currently Installed";
    public static String AVAILABLE_FOR_INSTALL = "Available for Install";
    public static String defaultPluginSiteUrl = CytoscapeInit.getProperties().getProperty("defaultPluginDownloadUrl");
    public static String DefaultPluginSiteTitle = "Cytoscape";
    private String currentPluginSiteURL = defaultPluginSiteUrl;
    private String HOWTOSEARCH = "You can use wildcard * or ? in your search words";
    private String baseSiteLabel = "Plugins available for download from: ";
    private JLabel availablePluginsLabel;
    private JPanel bottomPane;
    private JButton btnAddSite;
    private JButton btnClear;
    private JButton btnDeleteSite;
    private JButton btnEditSite;
    private JButton btnSearch;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JLabel downloadLocText;
    private JScrollPane infoScrollPane;
    private JEditorPane infoTextPane;
    private JButton installDeleteButton;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel lbSearchTitle;
    private JList lstDownloadSites;
    private JLabel msgLabel;
    private JTextArea msgPanel;
    private JTree pluginTree;
    private JPanel pnlSearch;
    private JPanel pnlSettings;
    private JPanel sitePanel;
    private JTextField tfSearch;
    private JPanel topPane;
    private JScrollPane treeScrollPane;
    private JCheckBox versionCheck;
    private TreeNode rootTreeNode;
    private TreeNode installedNode;
    private TreeNode availableNode;
    private ManagerModel treeModel;
    private TreeCellRenderer treeRenderer;
    private HashMap<TreeNode, List<TreeNode>> hiddenNodes;
    private String bookmarkCategory = "plugins";
    private Bookmarks theBookmarks;
    private static final Color HIGHLIGHT_COLOR = new Color(0, 0, 128);

    public PluginManageDialog() {
        this.setTitle("Manage Plugins");
        this.initComponents();
        this.initTree();
        this.setSize(600, 500);
    }

    public PluginManageDialog(JDialog owner) {
        super((Dialog)owner, "Manage Plugins");
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.initTree();
        this.setSize(600, 500);
    }

    public PluginManageDialog(JFrame owner) {
        super((Frame)owner, "Manage Plugins");
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.initTree();
        this.setSize(600, 500);
        this.btnSearch.setEnabled(false);
        this.availablePluginsLabel.setVisible(false);
        this.downloadLocText.setVisible(false);
        this.btnClear.setEnabled(false);
        this.bookmarksSetUp();
        this.lstDownloadSites.setCellRenderer(new BookmarkCellRenderer());
        this.lstDownloadSites.addListSelectionListener(new MyListSelectionListener());
        this.lstDownloadSites.getSelectionModel().setSelectionMode(0);
        this.loadBookmarkCMBox(true);
        this.jTabbedPane1.addChangeListener(new MyChangeListener());
        this.tfSearch.setToolTipText(this.HOWTOSEARCH);
        this.versionCheck.setSelected(false);
        this.btnEditSite.setEnabled(false);
        this.btnDeleteSite.setEnabled(false);
    }

    private void refreshPluginTree() {
        this.switchDownloadSites();
        PluginManagerInquireTask task = new PluginManagerInquireTask(this.currentPluginSiteURL, new UrlAction(this, this.currentPluginSiteURL));
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask(task, jTaskConfig);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        logger.info("URL DIALOG: " + evt.getSource().toString());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeNode Node2 = (TreeNode)this.pluginTree.getLastSelectedPathComponent();
        if (Node2 == null) {
            return;
        }
        if (Node2.isLeaf()) {
            this.infoTextPane.setContentType("text/html");
            this.infoTextPane.setText(Node2.getObject().htmlOutput());
            this.infoTextPane.setCaretPosition(0);
            this.infoTextPane.setEditable(false);
            this.infoTextPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.openURL(evt.getURL().toString());
                    }
                }
            });
            if (Node2.getParent().getParent().getTitle().equalsIgnoreCase(CURRENTLY_INSTALLED)) {
                this.installDeleteButton.setText("Delete");
                if (PluginManager.usingWebstartManager()) {
                    this.installDeleteButton.setEnabled(false);
                    this.setMessage("Delete is unavailable when using Web Start");
                } else {
                    this.installDeleteButton.setEnabled(true);
                }
            } else if (Node2.getParent().getParent().getTitle().equalsIgnoreCase(AVAILABLE_FOR_INSTALL)) {
                this.installDeleteButton.setText("Install");
                this.installDeleteButton.setEnabled(true);
            }
        } else {
            this.installDeleteButton.setEnabled(false);
        }
    }

    public void setMessage(String Msg) {
        this.msgPanel.setForeground(Color.BLACK);
        this.msgPanel.setText(Msg);
    }

    public void setError(String Msg) {
        this.msgPanel.setForeground(new Color(204, 0, 51));
        this.msgPanel.setText(Msg);
    }

    public void setSiteName(String SiteName) {
        this.downloadLocText.setText(SiteName);
    }

    public void switchDownloadSites() {
        this.hiddenNodes.clear();
        Vector<TreeNode> AvailableNodes = new Vector<TreeNode>(this.availableNode.getChildren());
        for (TreeNode child : AvailableNodes) {
            this.treeModel.removeNodeFromParent(child);
        }
    }

    public void addCategory(String CategoryName, List<DownloadableInfo> Plugins2, PluginInstallStatus Status2) {
        switch (Status2) {
            case INSTALLED: {
                this.addCategory(CategoryName, Plugins2, this.installedNode);
                break;
            }
            case AVAILABLE: {
                this.addCategory(CategoryName, Plugins2, this.availableNode);
                if (this.treeModel.getIndexOfChild(this.rootTreeNode, this.availableNode) >= 0) break;
                this.treeModel.addNodeToParent(this.rootTreeNode, this.availableNode);
            }
        }
        ToolTipManager.sharedInstance().registerComponent(this.pluginTree);
        ImageIcon warningIcon = this.createImageIcon("/cytoscape/images/misc/alert-red2.gif", "Warning");
        ImageIcon okIcon = this.createImageIcon("/cytoscape/images/misc/check-mark.gif", "Ok");
        if (warningIcon != null) {
            this.treeRenderer = new TreeCellRenderer((Icon)warningIcon, okIcon);
            this.pluginTree.setCellRenderer(this.treeRenderer);
        }
        this.pluginTree.expandPath(new TreePath(this.availableNode.getPath()));
        this.pluginTree.expandPath(new TreePath(this.installedNode.getPath()));
    }

    private void addCategory(String CategoryName, List<DownloadableInfo> Plugins2, TreeNode node) {
        TreeNode Category2 = new TreeNode(CategoryName, true);
        for (DownloadableInfo CurrentPlugin : Plugins2) {
            TreeNode PluginNode = new TreeNode(CurrentPlugin);
            if (node.equals(this.availableNode) && !CurrentPlugin.isPluginCompatibleWithCurrent()) {
                List<TreeNode> hiddenCat = this.hiddenNodes.get(Category2);
                if (hiddenCat == null) {
                    hiddenCat = new ArrayList<TreeNode>();
                }
                hiddenCat.add(PluginNode);
                this.hiddenNodes.put(Category2, hiddenCat);
                if (this.versionCheck.isSelected()) continue;
                this.treeModel.addNodeToParent(Category2, PluginNode);
                continue;
            }
            this.treeModel.addNodeToParent(Category2, PluginNode);
        }
        if (Category2.getChildCount() > 0) {
            this.treeModel.addNodeToParent(node, Category2);
        }
    }

    private void versionCheckItemStateChanged(ItemEvent evt) {
        TreePath[] SelectedPaths = this.pluginTree.getSelectionPaths();
        if (evt.getStateChange() == 2) {
            this.pluginTree.collapsePath(new TreePath(this.availableNode.getPath()));
            this.availableNode.removeChildren();
            for (TreeNode Category2 : this.hiddenNodes.keySet()) {
                for (TreeNode Plugin2 : this.hiddenNodes.get(Category2)) {
                    this.treeModel.addNodeToParent(Category2, Plugin2);
                }
                this.treeModel.addNodeToParent(this.availableNode, Category2);
            }
        } else if (evt.getStateChange() == 1) {
            for (TreeNode Category2 : this.hiddenNodes.keySet()) {
                for (TreeNode Plugin2 : this.hiddenNodes.get(Category2)) {
                    this.hiddenNodes.get(Category2);
                    this.treeModel.removeNodesFromParent(this.hiddenNodes.get(Category2));
                    if (Category2.getChildCount() > 0) continue;
                    this.availableNode.removeChild(Category2);
                    this.treeModel.reload();
                }
            }
        }
        if (SelectedPaths != null) {
            for (TreePath Path2 : SelectedPaths) {
                this.pluginTree.expandPath(Path2);
                this.pluginTree.setSelectionPath(Path2);
            }
        } else {
            this.pluginTree.expandPath(new TreePath(this.availableNode.getPath()));
            this.pluginTree.expandPath(new TreePath(this.installedNode.getPath()));
        }
    }

    private void installDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.installDeleteButton.getText().equals("Delete")) {
            this.deleteButtonActionPerformed(evt);
        } else if (this.installDeleteButton.getText().equals("Install")) {
            this.installButtonActionPerformed(evt);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        TreeNode Node2 = (TreeNode)this.pluginTree.getLastSelectedPathComponent();
        if (Node2 == null) {
            return;
        }
        DownloadableInfo NodeInfo = Node2.getObject();
        String ChangeMsg = "Changes will not take effect until you have restarted Cytoscape.";
        String VerifyMsg = "";
        VerifyMsg = NodeInfo.getCategory().equalsIgnoreCase("core") ? "This is a 'core' plugin and other plugins may depend on it, are you sure you want to delete it?\n" + ChangeMsg : "Are you sure you want to delete the plugin '" + NodeInfo.getName() + "'?\n" + ChangeMsg;
        if (0 == JOptionPane.showConfirmDialog(this, VerifyMsg, "Verify Delete Plugin", 0, 3)) {
            try {
                PluginManager.getPluginManager().delete(NodeInfo);
                this.treeModel.removeNodeFromParent(Node2);
                this.setMessage(NodeInfo.getName() + " will be removed when you restart Cytoscape.");
            }
            catch (WebstartException we) {
                logger.warn("Unable to remove '" + NodeInfo.getName() + "': " + we.getMessage(), we);
            }
        }
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        final TreeNode node = (TreeNode)this.pluginTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        DownloadableInfo nodeInfo = node.getObject();
        if (node.isLeaf()) {
            boolean licenseRequired = false;
            final LicenseDialog License2 = new LicenseDialog(this);
            final DownloadableInfo infoObj = nodeInfo;
            switch (infoObj.getType()) {
                case PLUGIN: {
                    if (infoObj.getLicenseText() == null) break;
                    License2.addPlugin(infoObj);
                    licenseRequired = true;
                    break;
                }
                case THEME: {
                    ThemeInfo themeInfo = (ThemeInfo)infoObj;
                    for (PluginInfo pInfo : themeInfo.getPlugins()) {
                        if (pInfo.getLicenseText() == null) continue;
                        License2.addPlugin(pInfo);
                        licenseRequired = true;
                    }
                    break;
                }
            }
            if (licenseRequired) {
                License2.addListenerToOk(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        License2.dispose();
                        PluginManageDialog.this.createInstallTask(infoObj, node);
                    }
                });
                License2.selectDefault();
                License2.setVisible(true);
            } else {
                this.createInstallTask(infoObj, node);
            }
        }
    }

    private void updateCurrent(DownloadableInfo info) {
        boolean categoryMatched = false;
        for (TreeNode Child2 : this.installedNode.getChildren()) {
            if (!Child2.getTitle().equals(info.getCategory())) continue;
            Child2.addChild(new TreeNode(info));
            categoryMatched = true;
        }
        if (!categoryMatched) {
            ArrayList<DownloadableInfo> NewPlugin = new ArrayList<DownloadableInfo>();
            NewPlugin.add(info);
            this.addCategory(info.getCategory(), NewPlugin, PluginInstallStatus.INSTALLED);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void initTree() {
        this.pluginTree.setRootVisible(false);
        this.pluginTree.addTreeSelectionListener(this);
        this.pluginTree.getSelectionModel().setSelectionMode(1);
        this.rootTreeNode = new TreeNode("Plugins", true);
        this.installedNode = new TreeNode(PluginInstallStatus.INSTALLED.toString(), true);
        this.availableNode = new TreeNode(PluginInstallStatus.AVAILABLE.toString(), true);
        this.treeModel = new ManagerModel(this.rootTreeNode);
        this.treeModel.addNodeToParent(this.rootTreeNode, this.installedNode);
        this.treeModel.addNodeToParent(this.rootTreeNode, this.availableNode);
        this.pluginTree.setModel(this.treeModel);
        this.hiddenNodes = new HashMap();
    }

    private Vector getAllPluginVector() {
        Vector allPluginVect = new Vector();
        TreeNode root = (TreeNode)this.treeModel.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode n = root.getChildAt(i);
            Vector<TreeNode> categories = n.getChildren();
            for (int j = 0; j < categories.size(); ++j) {
                TreeNode category = categories.elementAt(j);
                for (int k = 0; k < category.getChildCount(); ++k) {
                    TreeNode leaf = category.getChildAt(k);
                    Vector<Object> aPluginVect = new Vector<Object>();
                    aPluginVect.add(n.getTitle());
                    aPluginVect.add(category.getTitle());
                    aPluginVect.add(leaf.getObject());
                    allPluginVect.add(aPluginVect);
                }
            }
        }
        return allPluginVect;
    }

    private void updateTreeModel(Vector filteredPluginVector) {
        TreeNode newRootTreeNode = new TreeNode("Plugins", true);
        ManagerModel newTreeModel = new ManagerModel(newRootTreeNode);
        TreeNode newInstalledNode = new TreeNode(PluginInstallStatus.INSTALLED.toString());
        TreeNode newAvailableNode = new TreeNode(PluginInstallStatus.AVAILABLE.toString());
        newTreeModel.addNodeToParent(newRootTreeNode, newInstalledNode);
        newTreeModel.addNodeToParent(newRootTreeNode, newAvailableNode);
        if (filteredPluginVector != null) {
            for (int i = 0; i < filteredPluginVector.size(); ++i) {
                TreeNode node;
                int j;
                TreeNode categoryNode;
                TreeNode leafNode;
                String category;
                Vector aPlugin = (Vector)filteredPluginVector.elementAt(i);
                if (aPlugin.elementAt(0).toString().equalsIgnoreCase(CURRENTLY_INSTALLED)) {
                    category = aPlugin.elementAt(1).toString();
                    leafNode = new TreeNode((DownloadableInfo)aPlugin.elementAt(2));
                    categoryNode = null;
                    for (j = 0; j < newInstalledNode.getChildCount(); ++j) {
                        node = newInstalledNode.getChildAt(j);
                        if (!node.getTitle().equalsIgnoreCase(category)) continue;
                        categoryNode = node;
                        newTreeModel.addNodeToParent(categoryNode, leafNode);
                        break;
                    }
                    if (categoryNode != null) continue;
                    categoryNode = new TreeNode(category, true);
                    newTreeModel.addNodeToParent(categoryNode, leafNode);
                    newTreeModel.addNodeToParent(newInstalledNode, categoryNode);
                    continue;
                }
                if (!aPlugin.elementAt(0).toString().equalsIgnoreCase(AVAILABLE_FOR_INSTALL)) continue;
                category = aPlugin.elementAt(1).toString();
                leafNode = new TreeNode((DownloadableInfo)aPlugin.elementAt(2));
                categoryNode = null;
                for (j = 0; j < newAvailableNode.getChildCount(); ++j) {
                    node = newAvailableNode.getChildAt(j);
                    if (!node.getTitle().equalsIgnoreCase(category)) continue;
                    categoryNode = node;
                    newTreeModel.addNodeToParent(categoryNode, leafNode);
                    break;
                }
                if (categoryNode != null) continue;
                categoryNode = new TreeNode(category, true);
                newTreeModel.addNodeToParent(categoryNode, leafNode);
                newTreeModel.addNodeToParent(newAvailableNode, categoryNode);
            }
        }
        this.pluginTree.setModel(newTreeModel);
        this.pluginTree.expandPath(new TreePath(newAvailableNode.getPath()));
        this.pluginTree.expandPath(new TreePath(newInstalledNode.getPath()));
    }

    private void switchToMainDialog() {
        this.pluginTree.setModel(this.treeModel);
        TreeNode root = (TreeNode)this.treeModel.getRoot();
        Vector<TreeNode> treeNodeVect = root.getChildren();
        for (int i = 0; i < treeNodeVect.size(); ++i) {
            TreeNode n = treeNodeVect.elementAt(i);
            this.pluginTree.expandPath(new TreePath(this.treeModel.getPathToRoot(n)));
        }
        this.sitePanel.setVisible(true);
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlSearch = new JPanel();
        this.topPane = new JPanel();
        this.sitePanel = new JPanel();
        this.tfSearch = new JTextField();
        this.btnSearch = new JButton();
        this.btnClear = new JButton();
        this.downloadLocText = new JLabel();
        this.lbSearchTitle = new JLabel();
        this.pnlSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnAddSite = new JButton();
        this.btnEditSite = new JButton();
        this.btnDeleteSite = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstDownloadSites = new JList();
        this.jPanel3 = new JPanel();
        this.availablePluginsLabel = new JLabel();
        this.versionCheck = new JCheckBox();
        this.jSplitPane1 = new JSplitPane();
        this.treeScrollPane = new JScrollPane();
        this.pluginTree = new JTree();
        this.infoScrollPane = new JScrollPane();
        this.infoTextPane = new JEditorPane();
        this.msgLabel = new JLabel();
        this.msgPanel = new JTextArea();
        this.bottomPane = new JPanel();
        this.buttonPanel = new JPanel();
        this.installDeleteButton = new JButton();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jSplitPane2.setOrientation(0);
        this.pnlSearch.setLayout(new GridBagLayout());
        this.topPane.setLayout(new GridBagLayout());
        this.sitePanel.setLayout(new GridBagLayout());
        this.tfSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.tfSearchActionPerformed(evt);
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                PluginManageDialog.this.tfSearchKeyTyped(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.sitePanel.add((Component)this.tfSearch, gridBagConstraints);
        this.btnSearch.setText("Search");
        this.btnSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.btnSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.sitePanel.add((Component)this.btnSearch, gridBagConstraints);
        this.btnClear.setText("Clear");
        this.btnClear.setPreferredSize(new Dimension(67, 23));
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.btnClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.sitePanel.add((Component)this.btnClear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.topPane.add((Component)this.sitePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.pnlSearch.add((Component)this.topPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.pnlSearch.add((Component)this.downloadLocText, gridBagConstraints);
        this.lbSearchTitle.setText("Enter key words to search");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlSearch.add((Component)this.lbSearchTitle, gridBagConstraints);
        this.jTabbedPane1.addTab("Search", this.pnlSearch);
        this.pnlSettings.setLayout(new GridBagLayout());
        this.jLabel3.setText("Download sites");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.pnlSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnAddSite.setText("Add");
        this.btnAddSite.setPreferredSize(new Dimension(65, 23));
        this.btnAddSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.btnAddSiteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 20);
        this.jPanel2.add((Component)this.btnAddSite, gridBagConstraints);
        this.btnEditSite.setText("Edit");
        this.btnEditSite.setPreferredSize(new Dimension(65, 23));
        this.btnEditSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.btnEditSiteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 20);
        this.jPanel2.add((Component)this.btnEditSite, gridBagConstraints);
        this.btnDeleteSite.setText("Delete");
        this.btnDeleteSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.btnDeleteSiteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 20);
        this.jPanel2.add((Component)this.btnDeleteSite, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.pnlSettings.add((Component)this.jPanel2, gridBagConstraints);
        this.lstDownloadSites.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.lstDownloadSites);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this.pnlSettings.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jTabbedPane1.addTab("Settings", this.pnlSettings);
        this.jSplitPane2.setLeftComponent(this.jTabbedPane1);
        this.jPanel3.setLayout(new GridBagLayout());
        this.availablePluginsLabel.setText("Plugins available for download from:");
        this.availablePluginsLabel.setEnabled(false);
        this.availablePluginsLabel.setFocusable(false);
        this.availablePluginsLabel.setInheritsPopupMenu(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.jPanel3.add((Component)this.availablePluginsLabel, gridBagConstraints);
        this.versionCheck.setText("Show only plugins verified to work in this release");
        this.versionCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.versionCheck.setMargin(new Insets(0, 0, 0, 0));
        this.versionCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PluginManageDialog.this.versionCheckItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.jPanel3.add((Component)this.versionCheck, gridBagConstraints);
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setPreferredSize(new Dimension(400, 326));
        this.treeScrollPane.setViewportView(this.pluginTree);
        this.jSplitPane1.setLeftComponent(this.treeScrollPane);
        this.infoScrollPane.setViewportView(this.infoTextPane);
        this.jSplitPane1.setRightComponent(this.infoScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.jPanel3.add((Component)this.jSplitPane1, gridBagConstraints);
        this.msgLabel.setText("Messages:");
        this.msgLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.jPanel3.add((Component)this.msgLabel, gridBagConstraints);
        this.msgPanel.setBackground(new Color(230, 230, 230));
        this.msgPanel.setColumns(20);
        this.msgPanel.setEditable(false);
        this.msgPanel.setLineWrap(true);
        this.msgPanel.setRows(5);
        this.msgPanel.setWrapStyleWord(true);
        this.msgPanel.setMinimumSize(new Dimension(30, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 20);
        this.jPanel3.add((Component)this.msgPanel, gridBagConstraints);
        this.bottomPane.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        this.installDeleteButton.setText("Install");
        this.installDeleteButton.setEnabled(false);
        this.installDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.installDeleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.buttonPanel.add((Component)this.installDeleteButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.bottomPane.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        this.jPanel3.add((Component)this.bottomPane, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSplitPane2, gridBagConstraints);
        this.pack();
    }

    private void btnDeleteSiteActionPerformed(ActionEvent evt) {
        DataSource theDataSource = (DataSource)this.lstDownloadSites.getSelectedValue();
        if (theDataSource.getName().equalsIgnoreCase("Cytoscape")) {
            JOptionPane.showMessageDialog(this, "Your can not delete default Cytoscape site", "Warning", 2);
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this site", "Delete Confirm", 2);
        if (confirm == 0) {
            BookmarksUtil.deleteBookmark(this.theBookmarks, this.bookmarkCategory, theDataSource);
            this.loadBookmarkCMBox(true);
        }
    }

    private void btnEditSiteActionPerformed(ActionEvent evt) {
        DataSource theDataSource = (DataSource)this.lstDownloadSites.getSelectedValue();
        EditBookmarkDialog theEditDialog = new EditBookmarkDialog(this, true, this.theBookmarks, this.bookmarkCategory, "edit", theDataSource);
        theEditDialog.setLocationRelativeTo(this);
        theEditDialog.setVisible(true);
        this.loadBookmarkCMBox(true);
    }

    private void btnAddSiteActionPerformed(ActionEvent evt) {
        EditBookmarkDialog theNewDialog = new EditBookmarkDialog(this, true, this.theBookmarks, this.bookmarkCategory, "new", null);
        theNewDialog.setLocationRelativeTo(this);
        theNewDialog.setVisible(true);
        theNewDialog.getDataSource();
        this.loadBookmarkCMBox(true);
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.switchToMainDialog();
        this.tfSearch.setText("");
        this.btnSearch.setEnabled(false);
        this.versionCheck.setEnabled(true);
    }

    private void btnBackMainActionPerformed(ActionEvent evt) {
    }

    private void tfSearchKeyTyped(KeyEvent evt) {
        if (this.tfSearch.getText().trim().equals("")) {
            this.btnSearch.setEnabled(false);
            this.switchToMainDialog();
            this.btnClear.setEnabled(false);
            this.versionCheck.setEnabled(true);
        } else {
            this.btnSearch.setEnabled(true);
            this.btnClear.setEnabled(true);
            this.versionCheck.setEnabled(false);
        }
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.btnSearchActionPerformed(null);
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        try {
            Vector filteredPluginVector = PluginIndex.getSearchResult(this.tfSearch.getText().trim(), !this.versionCheck.isSelected(), this.downloadLocText.getText());
            if (filteredPluginVector == null) {
                PluginIndex.setAllPluginVector(this.getAllPluginVector(), !this.versionCheck.isSelected(), this.downloadLocText.getText());
                filteredPluginVector = PluginIndex.getSearchResult(this.tfSearch.getText().trim(), !this.versionCheck.isSelected(), this.downloadLocText.getText());
            }
            this.updateTreeModel(filteredPluginVector);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error in build index for PluginManager!");
        }
    }

    private void createInstallTask(DownloadableInfo obj, TreeNode node) {
        InstallTask task = new InstallTask(obj, node);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask(task, jTaskConfig);
        DownloadableInfo info = task.getDownloadedPlugin();
        if (info != null) {
            this.updateCurrent(info);
            this.cleanTree(node);
        }
    }

    private void cleanTree(TreeNode node) {
        DownloadableInfo info = node.getObject();
        ArrayList<TreeNode> RemovableNodes = new ArrayList<TreeNode>();
        for (int i = 0; i < node.getParent().getChildCount(); ++i) {
            TreeNode Child2 = node.getParent().getChildAt(i);
            DownloadableInfo childInfo = Child2.getObject();
            if (!childInfo.getID().equals(info.getID()) || !childInfo.getName().equals(info.getName())) continue;
            RemovableNodes.add(Child2);
        }
        for (TreeNode treeNode : RemovableNodes) {
            this.treeModel.removeNodeFromParent(treeNode);
        }
    }

    private ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        CyLogger.getLogger().warn("Couldn't find file: " + path);
        return null;
    }

    private void loadBookmarkCMBox(boolean selectLast) {
        DefaultComboBoxModel<DataSource> theModel = new DefaultComboBoxModel<DataSource>();
        List<DataSource> theDataSourceList = BookmarksUtil.getDataSourceList(this.bookmarkCategory, this.theBookmarks.getCategory());
        if (theDataSourceList != null) {
            for (DataSource Current : theDataSourceList) {
                theModel.addElement(Current);
                if (!selectLast) continue;
                theModel.setSelectedItem(Current);
            }
        }
        this.lstDownloadSites.setModel(theModel);
    }

    private void bookmarksSetUp() {
        try {
            this.theBookmarks = Cytoscape.getBookmarks();
        }
        catch (Exception E) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Failed to retrieve bookmarks for plugin download sites.", "Error", 0);
            logger.warn("Failed to retrieve bookmarks for plugin download sites.", E);
            return;
        }
        if (this.theBookmarks == null) {
            this.theBookmarks = new Bookmarks();
            Cytoscape.setBookmarks(this.theBookmarks);
        }
    }

    public static void main(String[] args) {
        PluginManageDialog pd = new PluginManageDialog();
        ArrayList<DownloadableInfo> Plugins2 = new ArrayList<DownloadableInfo>();
        PluginInfo infoC = new PluginInfo("1", "A Plugin");
        infoC.addCytoscapeVersion(CytoscapeVersion.version);
        Plugins2.add(infoC);
        infoC = new PluginInfo("2", "B Plugin");
        infoC.addCytoscapeVersion(CytoscapeVersion.version);
        Plugins2.add(infoC);
        infoC = new PluginInfo("3", "C");
        infoC.addCytoscapeVersion(CytoscapeVersion.version);
        Plugins2.add(infoC);
        pd.addCategory(Category.NONE.toString(), Plugins2, PluginInstallStatus.AVAILABLE);
        ArrayList<DownloadableInfo> Outdated = new ArrayList<DownloadableInfo>();
        PluginInfo infoOD = new PluginInfo("11", "CyGoose");
        infoOD.addCytoscapeVersion("2.3");
        Outdated.add(infoOD);
        infoOD = new PluginInfo("12", "Y");
        infoOD.addCytoscapeVersion("2.3");
        Outdated.add(infoOD);
        pd.addCategory("Outdated", Outdated, PluginInstallStatus.AVAILABLE);
        pd.setMessage("Foo bar");
        pd.setVisible(true);
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private int clickCount = 0;

        private MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent ev) {
            ++this.clickCount;
            JList list = (JList)ev.getSource();
            if (list.getSelectedIndices().length == 0) {
                PluginManageDialog.this.btnEditSite.setEnabled(false);
                PluginManageDialog.this.btnDeleteSite.setEnabled(false);
                return;
            }
            if (this.clickCount % 2 == 0) {
                this.clickCount = 0;
                return;
            }
            DataSource dataSource = (DataSource)list.getSelectedValue();
            if (dataSource.getName().equalsIgnoreCase("Cytoscape")) {
                PluginManageDialog.this.btnEditSite.setEnabled(false);
                PluginManageDialog.this.btnDeleteSite.setEnabled(false);
            } else {
                PluginManageDialog.this.btnEditSite.setEnabled(true);
                PluginManageDialog.this.btnDeleteSite.setEnabled(true);
            }
            String urlStr = dataSource.getHref();
            if (!PluginManageDialog.this.currentPluginSiteURL.equalsIgnoreCase(urlStr)) {
                PluginManageDialog.this.currentPluginSiteURL = urlStr;
                PluginManageDialog.this.refreshPluginTree();
            }
        }
    }

    private class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public BookmarkCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataSource dataSource = (DataSource)value;
            this.setText(dataSource.getName());
            this.setToolTipText(dataSource.getHref());
            if (isSelected) {
                this.setBackground(HIGHLIGHT_COLOR);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    private class InstallTask
    implements Task {
        private TaskMonitor taskMonitor;
        private DownloadableInfo infoObj;
        private TreeNode node;

        public InstallTask(DownloadableInfo Info2, TreeNode Node2) throws IllegalArgumentException {
            String ErrorMsg = null;
            if (Info2 == null) {
                ErrorMsg = "DownloadableInfo object cannot be null\n";
                throw new IllegalArgumentException(ErrorMsg);
            }
            this.infoObj = Info2;
            this.node = Node2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Installable ins;
            block11: {
                if (this.taskMonitor == null) {
                    throw new IllegalStateException("Task Monitor is not set.");
                }
                this.taskMonitor.setStatus("Installing " + this.infoObj.getName() + " v" + this.infoObj.getObjectVersion());
                this.taskMonitor.setPercentCompleted(-1);
                PluginManager Mgr = PluginManager.getPluginManager();
                ins = this.infoObj.getInstallable();
                try {
                    try {
                        this.infoObj = Mgr.download(this.infoObj, this.taskMonitor);
                        this.taskMonitor.setStatus(this.infoObj.getName() + " v" + this.infoObj.getObjectVersion() + " download complete.");
                        PluginManageDialog.this.setMessage(this.infoObj.toString() + " download complete.");
                        this.taskMonitor.setStatus(this.infoObj.toString() + " installing...");
                        Mgr.install(this.infoObj);
                        Mgr.loadPlugin(this.infoObj);
                        if (Mgr.getLoadingErrors().size() > 0) {
                            Throwable t = Mgr.getLoadingErrors().get(0);
                            Mgr.clearErrorList();
                            throw new PluginException("Failed to load plugin: " + this.infoObj.toString(), t);
                        }
                        this.taskMonitor.setStatus(this.infoObj.toString() + " install complete.");
                    }
                    catch (IOException ioe) {
                        this.taskMonitor.setException(ioe, "Failed to download " + this.infoObj.getName() + " from " + this.infoObj.getObjectUrl());
                        logger.warn("Failed to download " + this.infoObj.getName() + " from " + this.infoObj.getObjectUrl(), ioe);
                        this.infoObj = null;
                        Object var5_11 = null;
                        this.taskMonitor.setPercentCompleted(100);
                        break block11;
                    }
                    catch (ManagerException me) {
                        PluginManageDialog.this.setError("Failed to install " + this.infoObj.toString());
                        logger.warn("Failed to install " + this.infoObj.toString(), me);
                        this.taskMonitor.setException(me, me.getMessage());
                        this.infoObj = null;
                        Object var5_12 = null;
                        this.taskMonitor.setPercentCompleted(100);
                        break block11;
                    }
                    catch (PluginException pe) {
                        PluginManageDialog.this.setError("Failed to install " + this.infoObj.toString());
                        logger.warn("Failed to install " + this.infoObj.toString(), pe);
                        this.taskMonitor.setException(pe, pe.getMessage());
                        this.infoObj = null;
                        Object var5_13 = null;
                        this.taskMonitor.setPercentCompleted(100);
                        break block11;
                    }
                    catch (ClassNotFoundException cne) {
                        PluginManageDialog.this.setError("Failed to install " + this.infoObj.toString());
                        logger.warn("Failed to install " + this.infoObj.toString(), cne);
                        this.taskMonitor.setException(cne, cne.getMessage());
                        this.infoObj = null;
                        Object var5_14 = null;
                        this.taskMonitor.setPercentCompleted(100);
                        break block11;
                    }
                    Object var5_10 = null;
                }
                catch (Throwable throwable) {
                    Object var5_15 = null;
                    this.taskMonitor.setPercentCompleted(100);
                    throw throwable;
                }
                this.taskMonitor.setPercentCompleted(100);
            }
            try {
                if (this.infoObj != null) return;
                ins.uninstall();
                return;
            }
            catch (ManagerException me) {
                logger.warn("Failed to cleanup after installation failure", me);
            }
        }

        public DownloadableInfo getDownloadedPlugin() {
            return this.infoObj;
        }

        public void halt() {
        }

        public void setTaskMonitor(TaskMonitor monitor) throws IllegalThreadStateException {
            this.taskMonitor = monitor;
        }

        public String getTitle() {
            return "Installing Cytoscape " + this.infoObj.getType().name() + " '" + this.infoObj.getName() + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UrlAction
    extends PluginInquireAction {
        private PluginManageDialog dialog;
        private String url;

        public UrlAction(PluginManageDialog Dialog2, String Url) {
            this.dialog = Dialog2;
            this.url = Url;
        }

        public boolean displayProgressBar() {
            return true;
        }

        @Override
        public String getProgressBarMessage() {
            return "Attempting to connect...";
        }

        @Override
        public void inquireAction(List<DownloadableInfo> Results) {
            block5: {
                block3: {
                    block4: {
                        if (!this.isExceptionThrown()) break block3;
                        if (this.getIOException() == null) break block4;
                        logger.warn((Object)((Object)CommonError.NOXML) + this.url, this.getIOException());
                        this.dialog.setError((Object)((Object)CommonError.NOXML) + this.url);
                        break block5;
                    }
                    if (this.getJDOMException() == null) break block5;
                    logger.warn((Object)((Object)CommonError.BADXML) + this.url, this.getJDOMException());
                    this.dialog.setError((Object)((Object)CommonError.BADXML) + this.url);
                    break block5;
                }
                PluginManager Mgr = PluginManager.getPluginManager();
                List<DownloadableInfo> UniqueAvailable = ManagerUtil.getUnique(Mgr.getDownloadables(PluginStatus.CURRENT), Results);
                Map<String, List<DownloadableInfo>> NewPlugins = ManagerUtil.sortByCategory(UniqueAvailable);
                if (NewPlugins.size() <= 0) {
                    this.dialog.setError("No plugins compatible with " + new CytoscapeVersion().getFullVersion() + " available from this site.");
                } else {
                    this.dialog.setMessage("");
                }
                for (String Category2 : NewPlugins.keySet()) {
                    this.dialog.addCategory(Category2, NewPlugins.get(Category2), PluginInstallStatus.AVAILABLE);
                }
            }
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            int width = ((PluginManageDialog)PluginManageDialog.this).jTabbedPane1.getSize().width;
            if (PluginManageDialog.this.jTabbedPane1.getSelectedIndex() == 0) {
                // empty if block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonError {
        NOXML("ERROR: Failed to read XML file "),
        BADXML("ERROR: XML file may be incorrectly formatted, unable to read ");

        private String errorText;

        private CommonError(String error) {
            this.errorText = error;
        }

        public String toString() {
            return this.errorText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PluginInstallStatus {
        INSTALLED(CURRENTLY_INSTALLED),
        AVAILABLE(AVAILABLE_FOR_INSTALL);

        private String typeText;

        private PluginInstallStatus(String type) {
            this.typeText = type;
        }

        public String toString() {
            return this.typeText;
        }
    }
}

