/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree;

import java.io.Serializable;

final class ObjStack
implements Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private Object[] m_stack = new Object[11];
    private int m_currentSize = 0;

    public final void empty() {
        for (int i = this.m_currentSize - 1; i >= 0; --i) {
            this.m_stack[i] = null;
        }
        this.m_currentSize = 0;
    }

    public final int size() {
        return this.m_currentSize;
    }

    public final void push(Object obj) {
        try {
            this.m_stack[this.m_currentSize++] = obj;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            --this.m_currentSize;
            this.checkSize();
            this.m_stack[this.m_currentSize++] = obj;
        }
    }

    public final Object peek() {
        return this.m_stack[this.m_currentSize - 1];
    }

    public final Object pop() {
        try {
            Object returnThis = this.m_stack[--this.m_currentSize];
            this.m_stack[this.m_currentSize] = null;
            return returnThis;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ++this.m_currentSize;
            throw e;
        }
    }

    private final void checkSize() {
        if (this.m_currentSize < this.m_stack.length) {
            return;
        }
        int newStackSize = (int)Math.min(Integer.MAX_VALUE, (long)this.m_stack.length * 2L + 1L);
        if (newStackSize == this.m_stack.length) {
            throw new IllegalStateException("cannot allocate large enough array");
        }
        Object[] newStack = new Object[newStackSize];
        System.arraycopy(this.m_stack, 0, newStack, 0, this.m_stack.length);
        this.m_stack = newStack;
    }
}

