/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree.test;

import cytoscape.geom.rtree.RTree;
import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.util.intr.IntBTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BasicQuietRTreeTest {
    public static void main(String[] args) throws Exception {
        int j;
        int foundInx;
        int element;
        int i;
        int i2;
        int k;
        int stop;
        int j2;
        int foo;
        int i3;
        IntBTree cache;
        float[] extentsArr;
        SpacialEntry2DEnumerator iter;
        RTree tree = new RTree(3);
        int a = 0;
        while (true) {
            if ((iter = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, extentsArr = new float[4], 0, false)).numRemaining() != 0) {
                throw new IllegalStateException("did not expect query to generate results");
            }
            if (extentsArr[0] != Float.POSITIVE_INFINITY || extentsArr[1] != Float.POSITIVE_INFINITY || extentsArr[2] != Float.NEGATIVE_INFINITY || extentsArr[3] != Float.NEGATIVE_INFINITY) {
                throw new IllegalStateException("expected query to return inverted infinite extents");
            }
            if (tree.exists(0, extentsArr, 0)) {
                throw new IllegalStateException("did not expect there to be an entry");
            }
            if (tree.size() != 0) {
                throw new IllegalStateException("tree's size() is not 0");
            }
            if (a == 1) break;
            for (int j3 = 0; j3 < 1000; ++j3) {
                int k2;
                int stop2 = (j3 + 1) * 1000;
                for (k2 = j3 * 1000; k2 < stop2; ++k2) {
                    tree.insert(k2, k2, k2, k2 + 1, k2 + 1);
                }
                for (k2 = j3 * 1000; k2 < stop2; ++k2) {
                    tree.delete(k2);
                }
            }
            ++a;
        }
        tree.insert(0, 0.0f, 0.0f, 1.0f, 1.0f);
        tree.insert(1, 2.0f, 2.0f, 3.0f, 3.0f);
        tree.insert(2, 0.5f, 1.0f, 1.5f, 2.0f);
        a = 0;
        while (true) {
            extentsArr = new float[5];
            for (int i4 = 0; i4 < 3; ++i4) {
                if (tree.exists(i4, extentsArr, 0)) continue;
                throw new IllegalStateException("entry " + i4 + " does not exist");
            }
            if (tree.exists(3, extentsArr, 0)) {
                throw new IllegalStateException("entry 3 exits");
            }
            if ((double)extentsArr[0] != 0.5 || (double)extentsArr[1] != 1.0 || (double)extentsArr[2] != 1.5 || (double)extentsArr[3] != 2.0) {
                throw new IllegalStateException("entry's extents don't match");
            }
            if (tree.size() != 3) {
                throw new IllegalStateException("tree's size() is not 3");
            }
            iter = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, extentsArr, 0, false);
            if (iter.numRemaining() != 3) {
                throw new IllegalStateException("expected query to generate 3 hits");
            }
            cache = new IntBTree();
            for (i3 = 0; i3 < 3; ++i3) {
                cache.insert(i3);
            }
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 3) {
                throw new IllegalStateException("iter claimed it had 3 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr[0] != 0.0 || (double)extentsArr[1] != 0.0 || (double)extentsArr[2] != 3.0 || (double)extentsArr[3] != 3.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.25f, 2.0f, 2.1f, 3.3f, extentsArr, 1, false);
            if (iter.numRemaining() != 2) {
                throw new IllegalStateException("exptected query to return 2 hits");
            }
            cache.insert(1);
            cache.insert(2);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 2) {
                throw new IllegalStateException("iter claimed it had 2 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr[1] != 0.5 || (double)extentsArr[2] != 1.0 || (double)extentsArr[3] != 3.0 || (double)extentsArr[4] != 3.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            if (a == 1) break;
            for (j2 = 0; j2 < 1000; ++j2) {
                stop = (j2 + 1) * 1000 + 3;
                for (k = j2 * 1000 + 3; k < stop; ++k) {
                    tree.insert(k, -(k + 1), -(k + 1), -k, -k);
                }
                for (k = j2 * 1000 + 3; k < stop; ++k) {
                    tree.delete(k);
                }
            }
            ++a;
        }
        tree.insert(3, 2.5f, 0.5f, 3.5f, 1.5f);
        a = 0;
        while (true) {
            extentsArr = new float[4];
            for (int i5 = 0; i5 < 4; ++i5) {
                if (tree.exists(i5, extentsArr, 0)) continue;
                throw new IllegalStateException("entry " + i5 + " does not exist");
            }
            if (tree.exists(4, extentsArr, 0)) {
                throw new IllegalStateException("entry 4 exists");
            }
            if ((double)extentsArr[0] != 2.5 || (double)extentsArr[1] != 0.5 || (double)extentsArr[2] != 3.5 || (double)extentsArr[3] != 1.5) {
                throw new IllegalStateException("entry's extents incorrect");
            }
            if (tree.size() != 4) {
                throw new IllegalStateException("tree's size() is not 4");
            }
            iter = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, extentsArr, 0, false);
            if (iter.numRemaining() != 4) {
                throw new IllegalStateException("expected query to generate 4 hits");
            }
            cache = new IntBTree();
            for (i3 = 0; i3 < 4; ++i3) {
                cache.insert(i3);
            }
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 4) {
                throw new IllegalStateException("iter claimed it had 3 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr[0] != 0.0 || (double)extentsArr[1] != 0.0 || (double)extentsArr[2] != 3.5 || (double)extentsArr[3] != 3.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(2.0f, 0.5f, 2.2f, 1.9f, extentsArr, 0, false);
            if (iter.numRemaining() != 0) {
                throw new IllegalStateException("expected query to generate 0 hits");
            }
            if (extentsArr[0] != Float.POSITIVE_INFINITY || extentsArr[1] != Float.POSITIVE_INFINITY || extentsArr[2] != Float.NEGATIVE_INFINITY || extentsArr[3] != Float.NEGATIVE_INFINITY) {
                throw new IllegalStateException("query extents - expected inverted infinite");
            }
            iter = tree.queryOverlap(Float.NEGATIVE_INFINITY, 1.1f, Float.POSITIVE_INFINITY, 1.2f, extentsArr, 0, false);
            if (iter.numRemaining() != 2) {
                throw new IllegalStateException("expected query to generate 2 hits");
            }
            cache.insert(2);
            cache.insert(3);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 2) {
                throw new IllegalStateException("iter claimed it had 2 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("query returned wrong objKeys");
            }
            if ((double)extentsArr[0] != 0.5 || (double)extentsArr[1] != 0.5 || (double)extentsArr[2] != 3.5 || (double)extentsArr[3] != 2.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.0f, 1.0f, 1.0f, 1.0f, extentsArr, 0, false);
            if (iter.numRemaining() != 2) {
                throw new IllegalStateException("expected query to generate 2 hits");
            }
            cache.insert(0);
            cache.insert(2);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 2) {
                throw new IllegalStateException("iter claimed it had 2 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("query returned wrong objKeys");
            }
            if ((double)extentsArr[0] != 0.0 || (double)extentsArr[1] != 0.0 || (double)extentsArr[2] != 1.5 || (double)extentsArr[3] != 2.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            if (a == 1) break;
            for (j2 = 0; j2 < 1000; ++j2) {
                stop = (j2 + 1) * 1000 + 4;
                for (k = j2 * 1000 + 4; k < stop; ++k) {
                    tree.insert(k, k, -(k + 1), k + 3, -(k - 2));
                }
                for (k = j2 * 1000 + 4; k < stop; ++k) {
                    tree.delete(k);
                }
            }
            ++a;
        }
        boolean exceptionCaught = false;
        try {
            tree.insert(0, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        catch (IllegalStateException e) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new IllegalStateException("expected exception for duplicate objKey");
        }
        exceptionCaught = false;
        try {
            tree.insert(-1, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new IllegalStateException("expected exception for negative objKey");
        }
        exceptionCaught = false;
        try {
            tree.insert(5, 1.0f, 1.0f, 0.0f, 0.0f);
        }
        catch (IllegalArgumentException e) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new IllegalStateException("expected exception for min > max");
        }
        tree.insert(4, 3.0f, -0.25f, 4.0f, 0.75f);
        tree.insert(5, -0.5f, 2.5f, 0.5f, 3.5f);
        tree.insert(6, 2.75f, 2.25f, 3.75f, 3.25f);
        tree.insert(7, 1.25f, 1.75f, 2.25f, 2.75f);
        tree.insert(8, 1.0f, 6.0f, 2.0f, 7.0f);
        tree.insert(9, -2.0f, 1.0f, -1.0f, 2.0f);
        a = 0;
        while (true) {
            extentsArr = new float[4];
            for (int i6 = 9; i6 >= 0; --i6) {
                if (tree.exists(i6, extentsArr, 0)) continue;
                throw new IllegalStateException("entry " + i6 + " does not exist");
            }
            if (tree.exists(-1, extentsArr, 0) || tree.exists(10, extentsArr, 0)) {
                throw new IllegalStateException("bad entry exists");
            }
            if ((double)extentsArr[0] != 0.0 || (double)extentsArr[1] != 0.0 || (double)extentsArr[2] != 1.0 || (double)extentsArr[3] != 1.0) {
                throw new IllegalStateException("objKey 0 extents incorrect");
            }
            if (tree.size() != 10) {
                throw new IllegalStateException("tree's size() is not 10");
            }
            iter = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, extentsArr, 0, false);
            if (iter.numRemaining() != 10) {
                throw new IllegalStateException("expected query to generate 10 hits");
            }
            cache = new IntBTree();
            for (i3 = 0; i3 < 10; ++i3) {
                cache.insert(i3);
            }
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 10) {
                throw new IllegalStateException("iter claimed it had 10 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr[0] != -2.0 || (double)extentsArr[1] != -0.25 || (double)extentsArr[2] != 4.0 || (double)extentsArr[3] != 7.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.0f, 1.25f, 3.0f, 5.0f, extentsArr, 0, false);
            if (iter.numRemaining() != 5) {
                throw new IllegalStateException("expected query to generate 5 hits");
            }
            cache.insert(1);
            cache.insert(2);
            cache.insert(3);
            cache.insert(6);
            cache.insert(7);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 5) {
                throw new IllegalStateException("iter claimed it had 5 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("query returned wrong objKeys");
            }
            if ((double)extentsArr[0] != 0.5 || (double)extentsArr[1] != 0.5 || (double)extentsArr[2] != 3.75 || (double)extentsArr[3] != 3.25) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(-1.5f, 0.25f, 0.25f, 3.0f, extentsArr, 0, false);
            if (iter.numRemaining() != 3) {
                throw new IllegalStateException("expected query to generate 3 hits");
            }
            cache.insert(0);
            cache.insert(5);
            cache.insert(9);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 3) {
                throw new IllegalStateException("query claimed it had 3 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("query returned wrong objKeys");
            }
            if ((double)extentsArr[0] != -2.0 || (double)extentsArr[1] != 0.0 || (double)extentsArr[2] != 1.0 || (double)extentsArr[3] != 3.5) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.5f, 6.5f, 1.5f, 6.5f, extentsArr, 0, false);
            if (iter.numRemaining() != 1) {
                throw new IllegalStateException("expected query to generate 1 hit");
            }
            cache.insert(8);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 1) {
                throw new IllegalStateException("query claimed it had 1 element but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("query returned wrong objKey");
            }
            if ((double)extentsArr[0] != 1.0 || (double)extentsArr[1] != 6.0 || (double)extentsArr[2] != 2.0 || (double)extentsArr[3] != 7.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(3.0f, 5.0f, 8.0f, 9.0f, extentsArr, 0, false);
            if (iter.numRemaining() != 0) {
                throw new IllegalStateException("did not expect any query hits");
            }
            iter = tree.queryOverlap(-100.0f, -100.0f, -99.0f, -99.0f, extentsArr, 0, false);
            if (iter.numRemaining() != 0) {
                throw new IllegalStateException("did not expect any query hits");
            }
            iter = tree.queryOverlap(-1.0f, 0.75f, 3.0f, 6.0f, extentsArr, 0, false);
            if (iter.numRemaining() != 10) {
                throw new IllegalStateException("expected 10 query hits");
            }
            if (a == 1) break;
            for (j2 = 0; j2 < 1000; ++j2) {
                stop = (j2 + 1) * 1000 + 10;
                for (k = j2 * 1000 + 10; k < stop; ++k) {
                    tree.insert(k, k, k, k + 2, k + 2);
                }
                for (k = j2 * 1000 + 10; k < stop; ++k) {
                    tree.delete(k);
                }
            }
            ++a;
        }
        a = 0;
        while (true) {
            tree.insert(10, 2.0f, 4.0f, 3.0f, 5.0f);
            tree.insert(11, 1.5f, 3.75f, 3.5f, 4.25f);
            tree.insert(12, 2.5f, 3.5f, 3.0f, 5.5f);
            tree.insert(13, -4.0f, 6.0f, -2.0f, 8.0f);
            tree.insert(14, -4.25f, 5.75f, 2.25f, 8.25f);
            tree.insert(15, 2.0f, -1.0f, 2.0f, -1.0f);
            tree.insert(16, -1.25f, 0.5f, -1.25f, 3.0f);
            tree.insert(17, -0.5f, -0.5f, 1.5f, 0.5f);
            tree.insert(18, 0.25f, 4.0f, 1.25f, 5.0f);
            tree.insert(19, 4.0f, 1.0f, 5.0f, 2.0f);
            tree.insert(20, 4.0f, 3.0f, 5.0f, 4.0f);
            tree.insert(21, 4.25f, -1.5f, 4.75f, 5.0f);
            tree.insert(22, 3.0f, -1.75f, 5.0f, -1.0f);
            tree.insert(23, 1.25f, 0.25f, 2.25f, 1.25f);
            tree.insert(24, -2.0f, 9.0f, -1.0f, 10.0f);
            tree.insert(25, 1.0f, 9.0f, 2.0f, 10.0f);
            tree.insert(26, -2.0f, 5.0f, -1.0f, 6.0f);
            tree.insert(27, -2.5f, 5.25f, -1.75f, 9.25f);
            if (a == 1) break;
            for (int k3 = 10; k3 < 28; ++k3) {
                tree.delete(k3);
            }
            ++a;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(tree);
        objOut.flush();
        objOut.close();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        tree = (RTree)objIn.readObject();
        objIn.close();
        a = 0;
        while (true) {
            float[] extentsArr2 = new float[4];
            for (int i7 = 27; i7 >= 0; --i7) {
                if (tree.exists(i7, extentsArr2, 0)) continue;
                throw new IllegalStateException("entry " + i7 + " does not exist");
            }
            if (tree.exists(28, extentsArr2, 0) || tree.exists(Integer.MAX_VALUE, extentsArr2, 0) || tree.exists(Integer.MIN_VALUE, extentsArr2, 0)) {
                throw new IllegalStateException("bad entry exists");
            }
            if ((double)extentsArr2[0] != 0.0 || (double)extentsArr2[1] != 0.0 || (double)extentsArr2[2] != 1.0 || (double)extentsArr2[3] != 1.0) {
                throw new IllegalStateException("objKey 0 extents incorrect");
            }
            if (tree.size() != 28) {
                throw new IllegalStateException("tree's size() is not 28");
            }
            iter = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, extentsArr2, 0, false);
            if (iter.numRemaining() != 28) {
                throw new IllegalStateException("expected query to give 28 hits");
            }
            cache = new IntBTree();
            for (i3 = 0; i3 < 28; ++i3) {
                cache.insert(i3);
            }
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 28) {
                throw new IllegalStateException("iter claimed it had 28 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -4.25 || (double)extentsArr2[1] != -1.75 || (double)extentsArr2[2] != 5.0 || (double)extentsArr2[3] != 10.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(-2.0f, 6.0f, -2.0f, 6.0f, extentsArr2, 0, false);
            if (iter.numRemaining() != 4) {
                throw new IllegalStateException("expected query to generate 4 hits");
            }
            cache.insert(13);
            cache.insert(14);
            cache.insert(26);
            cache.insert(27);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 4) {
                throw new IllegalStateException("iter claimed it had 4 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -4.25 || (double)extentsArr2[1] != 5.0 || (double)extentsArr2[2] != 2.25 || (double)extentsArr2[3] != 9.25) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(2.5f, 3.75f, 6.0f, 6.0f, extentsArr2, 0, false);
            if (iter.numRemaining() != 5) {
                throw new IllegalStateException("expected query to generate 5 hits");
            }
            cache.insert(10);
            cache.insert(11);
            cache.insert(12);
            cache.insert(20);
            cache.insert(21);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 5) {
                throw new IllegalStateException("iter claimed it had 5 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != 1.5 || (double)extentsArr2[1] != -1.5 || (double)extentsArr2[2] != 5.0 || (double)extentsArr2[3] != 5.5) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.75f, -1.5f, 3.25f, -0.5f, extentsArr2, 0, false);
            if (iter.numRemaining() != 2) {
                throw new IllegalStateException("expected query to generate 2 hits");
            }
            cache.insert(15);
            cache.insert(22);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 2) {
                throw new IllegalStateException("iter claimed it had 2 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != 2.0 || (double)extentsArr2[1] != -1.75 || (double)extentsArr2[2] != 5.0 || (double)extentsArr2[3] != -1.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(-3.0f, -5.0f, 7.0f, 2.75f, extentsArr2, 0, false);
            if (iter.numRemaining() != 16) {
                throw new IllegalStateException("expected query to generate 16 hits");
            }
            cache.insert(0);
            cache.insert(1);
            cache.insert(2);
            cache.insert(3);
            cache.insert(4);
            cache.insert(5);
            cache.insert(6);
            cache.insert(7);
            cache.insert(9);
            cache.insert(15);
            cache.insert(16);
            cache.insert(17);
            cache.insert(19);
            cache.insert(21);
            cache.insert(22);
            cache.insert(23);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 16) {
                throw new IllegalStateException("iter claimed it had 16 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -2.0 || (double)extentsArr2[1] != -1.75 || (double)extentsArr2[2] != 5.0 || (double)extentsArr2[3] != 5.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.0f, 4.5f, 3.0f, 6.25f, extentsArr2, 0, false);
            if (iter.numRemaining() != 5) {
                throw new IllegalStateException("expected query to generate 5 hits");
            }
            cache.insert(8);
            cache.insert(10);
            cache.insert(12);
            cache.insert(14);
            cache.insert(18);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 5) {
                throw new IllegalStateException("iter claimed it had 5 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -4.25 || (double)extentsArr2[1] != 3.5 || (double)extentsArr2[2] != 3.0 || (double)extentsArr2[3] != 8.25) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(0.75f, 0.25f, 1.5f, 0.75f, extentsArr2, 0, false);
            if (iter.numRemaining() != 3) {
                throw new IllegalStateException("expected query to generate 3 hits");
            }
            cache.insert(0);
            cache.insert(17);
            cache.insert(23);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 3) {
                throw new IllegalStateException("iter claimed it had 3 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -0.5 || (double)extentsArr2[1] != -0.5 || (double)extentsArr2[2] != 2.25 || (double)extentsArr2[3] != 1.25) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(1.75f, -10.0f, 1.75f, 30.0f, extentsArr2, 0, false);
            if (iter.numRemaining() != 6) {
                throw new IllegalStateException("expected query to generate 6 hits");
            }
            cache.insert(7);
            cache.insert(8);
            cache.insert(11);
            cache.insert(14);
            cache.insert(23);
            cache.insert(25);
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 6) {
                throw new IllegalStateException("iter claimed it had 6 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -4.25 || (double)extentsArr2[1] != 0.25 || (double)extentsArr2[2] != 3.5 || (double)extentsArr2[3] != 10.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            iter = tree.queryOverlap(0.75f, 3.0f, 1.75f, 3.5f, extentsArr2, 0, false);
            if (iter.numRemaining() != 0) {
                throw new IllegalStateException("did not expect query results");
            }
            iter = tree.queryOverlap(2.5f, 1.75f, 3.75f, 1.75f, null, -1, false);
            if (iter.numRemaining() != 0) {
                throw new IllegalStateException("did not expect query results");
            }
            iter = tree.queryOverlap(-2.0f, -1.0f, 4.25f, 9.0f, extentsArr2, 0, false);
            if (iter.numRemaining() != 28) {
                throw new IllegalStateException("expected 28 (all) query hits");
            }
            for (int i8 = 0; i8 < 28; ++i8) {
                cache.insert(i8);
            }
            foo = 0;
            while (iter.numRemaining() > 0) {
                cache.delete(iter.nextInt());
                ++foo;
            }
            if (foo != 28) {
                throw new IllegalStateException("iter claimed it had 28 elements but really didn't");
            }
            if (cache.size() != 0) {
                throw new IllegalStateException("iter returned wrong objKeys");
            }
            if ((double)extentsArr2[0] != -4.25 || (double)extentsArr2[1] != -1.75 || (double)extentsArr2[2] != 5.0 || (double)extentsArr2[3] != 10.0) {
                throw new IllegalStateException("extents from query wrong");
            }
            if (a == 1) break;
            for (j2 = 0; j2 < 1000; ++j2) {
                stop = (j2 + 1) * 1000 + 28;
                for (k = j2 * 1000 + 28; k < stop; ++k) {
                    tree.insert(k, k, k, k + 5, k + 5);
                }
                for (k = j2 * 1000 + 28; k < stop; ++k) {
                    tree.delete(k);
                }
            }
            ++a;
        }
        if (tree.size() != 28) {
            throw new IllegalStateException("expected 28 elements in tree");
        }
        int[] allOrdered = new int[28];
        SpacialEntry2DEnumerator iter2 = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, null, 0, false);
        if (iter2.numRemaining() != 28) {
            throw new IllegalStateException("expected 28 elements in iteration");
        }
        for (i2 = 0; i2 < 28; ++i2) {
            allOrdered[i2] = iter2.nextInt();
        }
        iter2 = tree.queryOverlap(0.0f, 0.0f, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, null, 0, false);
        if (iter2.numRemaining() != 20) {
            throw new IllegalStateException("expected 20 elements in iteration");
        }
        int prevInx = -1;
        for (i = 0; i < 20; ++i) {
            element = iter2.nextInt();
            foundInx = -2;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx <= prevInx) {
                throw new IllegalStateException("order in subquery not preserved");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        iter2 = tree.queryOverlap(-10.0f, -5.0f, 1.0f, 4.0f, null, 0, false);
        if (iter2.numRemaining() != 7) {
            throw new IllegalStateException("expected 7 elements in iteration");
        }
        prevInx = -1;
        for (i = 0; i < 7; ++i) {
            element = iter2.nextInt();
            foundInx = -2;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx <= prevInx) {
                throw new IllegalStateException("order in subquery not preserved");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        iter2 = tree.queryOverlap(-99.0f, -5.0f, 1.0f, 30.0f, null, 0, false);
        if (iter2.numRemaining() != 14) {
            throw new IllegalStateException("expected 14 elements in iteration");
        }
        prevInx = -1;
        for (i = 0; i < 14; ++i) {
            element = iter2.nextInt();
            foundInx = -2;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx <= prevInx) {
                throw new IllegalStateException("order in subquery not preserved");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        iter2 = tree.queryOverlap(-3.0f, 4.0f, 10.0f, 20.0f, null, 0, false);
        if (iter2.numRemaining() != 13) {
            throw new IllegalStateException("expected 13 elements in iteration");
        }
        prevInx = -1;
        for (i = 0; i < 13; ++i) {
            element = iter2.nextInt();
            foundInx = -2;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx <= prevInx) {
                throw new IllegalStateException("order in subquery not preserved");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        if (tree.size() != 28) {
            throw new IllegalStateException("expected 28 elements in tree");
        }
        allOrdered = new int[28];
        iter2 = tree.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, null, 0, false);
        if (iter2.numRemaining() != 28) {
            throw new IllegalStateException("expected 28 elements in iteration");
        }
        for (i2 = 0; i2 < 28; ++i2) {
            allOrdered[i2] = iter2.nextInt();
        }
        iter2 = tree.queryOverlap(0.0f, 0.0f, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, null, 0, true);
        if (iter2.numRemaining() != 20) {
            throw new IllegalStateException("expected 20 elements in iteration");
        }
        prevInx = 0x7FFFFFFE;
        for (i = 0; i < 20; ++i) {
            element = iter2.nextInt();
            foundInx = Integer.MAX_VALUE;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx >= prevInx) {
                throw new IllegalStateException("not reverse order");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        iter2 = tree.queryOverlap(-10.0f, -5.0f, 1.0f, 4.0f, null, 0, true);
        if (iter2.numRemaining() != 7) {
            throw new IllegalStateException("expected 7 elements in iteration");
        }
        prevInx = 0x7FFFFFFE;
        for (i = 0; i < 7; ++i) {
            element = iter2.nextInt();
            foundInx = Integer.MAX_VALUE;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx >= prevInx) {
                throw new IllegalStateException("not reverse order");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        iter2 = tree.queryOverlap(-99.0f, -5.0f, 1.0f, 30.0f, null, 0, true);
        if (iter2.numRemaining() != 14) {
            throw new IllegalStateException("expected 14 elements in iteration");
        }
        prevInx = 0x7FFFFFFE;
        for (i = 0; i < 14; ++i) {
            element = iter2.nextInt();
            foundInx = Integer.MAX_VALUE;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx >= prevInx) {
                throw new IllegalStateException("not reverse order");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
        iter2 = tree.queryOverlap(-3.0f, 4.0f, 10.0f, 20.0f, null, 0, true);
        if (iter2.numRemaining() != 13) {
            throw new IllegalStateException("expected 13 elements in iteration");
        }
        prevInx = 0x7FFFFFFE;
        for (i = 0; i < 13; ++i) {
            element = iter2.nextInt();
            foundInx = Integer.MAX_VALUE;
            j = 0;
            while (true) {
                if (allOrdered[j] == element) break;
                ++j;
            }
            foundInx = j;
            if (foundInx >= prevInx) {
                throw new IllegalStateException("not reverse order");
            }
            prevInx = foundInx;
        }
        if (iter2.numRemaining() != 0) {
            throw new IllegalStateException("more elements remain in iteration");
        }
    }
}

