/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeVersion;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.Installable;
import cytoscape.plugin.PluginVersionUtils;
import cytoscape.util.URLUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DownloadableInfo {
    private static CyLogger logger = CyLogger.getLogger(DownloadableInfo.class);
    protected String versionMatch = "^\\d+\\.\\d+";
    protected String versionSplit = "\\.";
    private String releaseDate;
    private String uniqueID;
    private String name = "";
    private String description;
    private String objVersion;
    private String downloadURL = "";
    private String objURL = "";
    private String category;
    private License license;
    private boolean licenseRequired = false;
    private Set<String> compatibleCyVersions;
    private DownloadableInfo parentObj;

    public DownloadableInfo() {
        this(null, null);
    }

    public DownloadableInfo(String id) {
        this(id, null);
    }

    public DownloadableInfo(String id, DownloadableInfo parentObj) {
        this.uniqueID = id;
        this.parentObj = parentObj;
        this.compatibleCyVersions = new HashSet<String>();
    }

    public void setLicense(URL url) {
        this.license = new License(url);
    }

    public void setLicense(String licenseText, boolean alwaysRequired) {
        this.license = new License(licenseText);
        this.licenseRequired = alwaysRequired;
    }

    public void setCategory(String Category2) {
        this.category = Category2;
    }

    public void setCategory(Category cat) {
        this.category = cat.toString();
    }

    public void setParent(DownloadableInfo parentObj) {
        this.parentObj = parentObj;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDownloadableURL(String url) {
        this.downloadURL = url;
    }

    public void setObjectUrl(String url) {
        this.objURL = url;
    }

    public void addCytoscapeVersion(String cyVersion) throws NumberFormatException {
        if (!PluginVersionUtils.versionOk(cyVersion, false)) {
            throw new NumberFormatException("Cytoscape version numbers must be in the format: \\d+.\\d+  optional to add: .\\d+-[a-z]");
        }
        this.compatibleCyVersions.add(cyVersion);
    }

    public void setObjectVersion(double objVersion) throws NumberFormatException {
        String Version2 = Double.toString(objVersion);
        if (!PluginVersionUtils.versionOk(Version2, true)) {
            throw new NumberFormatException("Bad version '" + Version2 + "'." + this + " version numbers must be in the format: \\d+.\\d+");
        }
        this.objVersion = Version2;
    }

    public void setReleaseDate(String date) {
        this.releaseDate = date;
    }

    public String getLicenseText() {
        if (this.license != null) {
            return this.license.getLicense();
        }
        return null;
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    public abstract Installable getInstallable();

    public abstract DownloadableType getType();

    public DownloadableInfo getParent() {
        return this.parentObj;
    }

    public String getObjectUrl() {
        return this.objURL;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDownloadableURL() {
        return this.downloadURL;
    }

    public String getObjectVersion() {
        return this.objVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCytoscapeVersion() {
        for (String v : this.compatibleCyVersions) {
            if (!this.isCytoscapeVersionCurrent(v)) continue;
            return v;
        }
        String currentPluginVersion = null;
        String all = "";
        for (String v : this.compatibleCyVersions) {
            all = all + v + " ";
            if (currentPluginVersion != null) {
                if (!this.isCytoscapeVersionCurrent(currentPluginVersion = PluginVersionUtils.getNewerVersion(v, currentPluginVersion))) continue;
                return currentPluginVersion;
            }
            currentPluginVersion = v;
        }
        logger.debug(this.getName() + ": Compatible: " + all + " cyvers: " + currentPluginVersion + "(cyversion " + CytoscapeVersion.version + ")");
        return currentPluginVersion;
    }

    public List<String> getCytoscapeVersions() {
        return new ArrayList<String>(this.compatibleCyVersions);
    }

    protected boolean containsVersion(String cyVersion) {
        return this.compatibleCyVersions.contains(cyVersion);
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getID() {
        return this.uniqueID;
    }

    public boolean isNewerObjectVersion(DownloadableInfo New) {
        String[] CurrentVersion = this.getObjectVersion().split(this.versionSplit);
        String[] NewVersion = New.getObjectVersion().split(this.versionSplit);
        if (!this.getID().equals(New.getID()) || !this.getDownloadableURL().equals(New.getDownloadableURL())) {
            return false;
        }
        int CurrentMajor = Integer.valueOf(CurrentVersion[0]);
        int NewMajor = Integer.valueOf(NewVersion[0]);
        int CurrentMinor = Integer.valueOf(CurrentVersion[1]);
        int NewMinor = Integer.valueOf(NewVersion[1]);
        return CurrentMajor <= NewMajor && (CurrentMajor != NewMajor || CurrentMinor < NewMinor);
    }

    private boolean isCytoscapeVersionCurrent(String pluginVersion) {
        String[] plVersion;
        if (pluginVersion == null) {
            return false;
        }
        String[] cyVersion = new CytoscapeVersion().getFullVersion().split(this.versionSplit);
        if (cyVersion.length < (plVersion = pluginVersion.split(this.versionSplit)).length) {
            return false;
        }
        for (int i = 0; i < plVersion.length; ++i) {
            if (Integer.valueOf(cyVersion[i]).intValue() == Integer.valueOf(plVersion[i]).intValue()) continue;
            return false;
        }
        return true;
    }

    private boolean compareVersions(String[] v1, String[] v2) {
        if (v1.length != v2.length) {
            return false;
        }
        for (int i = 0; i < v1.length; ++i) {
            if (Integer.valueOf(v1[i]).intValue() == Integer.valueOf(v2[i]).intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isPluginCompatibleWithCurrent() {
        if (this.getCategory() != null && this.getCategory().equalsIgnoreCase("Core")) {
            return true;
        }
        boolean compatible = false;
        CytoscapeVersion cv = new CytoscapeVersion();
        for (String pluginVersion : this.compatibleCyVersions) {
            Object[] cyVersion = cv.getFullVersion().split(this.versionSplit);
            Object[] plVersion = pluginVersion.split(this.versionSplit);
            if (PluginVersionUtils.isVersion(pluginVersion, 2)) {
                cyVersion = new String[]{cyVersion[0], cyVersion[1]};
            }
            logger.debug("Comparing versions: " + Arrays.toString(cyVersion) + " : " + Arrays.toString(plVersion));
            if (!this.compareVersions((String[])cyVersion, (String[])plVersion)) continue;
            compatible = true;
            break;
        }
        return compatible;
    }

    public boolean equals(Object Obj) {
        DownloadableInfo obj = (DownloadableInfo)Obj;
        return this.getType().equals((Object)obj.getType()) && (this.getID() != null && obj.getID() != null ? this.getID().equals(obj.getID()) && this.getDownloadableURL().equals(obj.getDownloadableURL()) && this.getObjectVersion().equals(obj.getObjectVersion()) : this.getDownloadableURL().equals(obj.getDownloadableURL()) && this.getObjectVersion().equals(obj.getObjectVersion()));
    }

    public boolean equalsDifferentObjectVersion(Object Obj) {
        DownloadableInfo obj = (DownloadableInfo)Obj;
        return this.getID().equals(obj.getID()) && this.getType().equals((Object)obj.getType()) && this.getDownloadableURL().equals(obj.getDownloadableURL());
    }

    public String toString() {
        return this.getName() + " v." + this.getObjectVersion();
    }

    public abstract String htmlOutput();

    protected String basicHtmlOutput() {
        String Html = "<html><style type='text/css'>";
        Html = Html + "body,th,td,div,p,h1,h2,li,dt,dd ";
        Html = Html + "{ font-family: Tahoma, \"Gill Sans\", Arial, sans-serif; }";
        Html = Html + "body { margin: 0px; color: #333333; background-color: #ffffff; }";
        Html = Html + "#indent { padding-left: 30px; }";
        Html = Html + "ul {list-style-type: none}";
        Html = Html + "</style><body>";
        Html = Html + "<b>" + this.getName() + "</b><p>";
        Html = Html + "<b>Version:</b>&nbsp;" + this.getObjectVersion() + "<p>";
        Html = Html + "<b>Category:</b>&nbsp;" + this.getCategory() + "<p>";
        Html = Html + "<b>Description:</b><br>" + this.getDescription();
        if (!this.isPluginCompatibleWithCurrent()) {
            Html = Html + "<br><b>Verified with the following Cytoscape versions:</b> " + this.getCytoscapeVersions().toString() + "<br>";
            Html = Html + "<font color='red'><i>" + this.toString() + " is not verfied to work in the current version (" + CytoscapeVersion.version + ") of Cytoscape.</i></font>";
        }
        Html = Html + "<p>";
        if (this.getReleaseDate() != null && this.getReleaseDate().length() > 0) {
            Html = Html + "<b>Release Date:</b>&nbsp;" + this.getReleaseDate() + "<p>";
        }
        return Html;
    }

    protected class License {
        private URL url;
        private String text;

        public License(URL url) {
            this.url = url;
        }

        public License(String licenseText) {
            this.text = licenseText;
        }

        public String getLicense() {
            if (this.text == null) {
                try {
                    this.text = URLUtil.download(this.url);
                }
                catch (Exception e) {
                    logger.warn("Unable to get license: " + e.toString());
                    this.text = "No license found";
                }
            }
            return this.text;
        }
    }
}

