/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PluginProperties
extends Properties {
    private String configFileName = "plugin.props";
    private String packageName;
    private String errorMsg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PluginProperties(String fileName) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(fileName));
            this.readPluginProperties(fis);
            Object var4_3 = null;
            if (fis == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
    }

    public PluginProperties(CytoscapePlugin Plugin2) throws IOException {
        if (Plugin2.getClass().getPackage() == null) {
            throw new IOException(Plugin2.getClass().getName() + " is not part of a package, cannot read " + this.configFileName);
        }
        this.packageName = Plugin2.getClass().getPackage().getName();
        this.packageName = this.packageName.replace('.', '/');
        this.readPluginProperties(Plugin2.getClass().getClassLoader().getResourceAsStream(this.packageName + "/" + this.configFileName));
    }

    private void readPluginProperties(InputStream is) throws IOException {
        if (is == null || is.available() == 0) {
            String Msg = "";
            if (is == null) {
                Msg = "File is not in the expected location: " + this.packageName;
            } else if (is.available() == 0) {
                Msg = "0 bytes in input stream";
            }
            IOException Error2 = new IOException("Unable to load " + this.configFileName + ". " + Msg);
            throw Error2;
        }
        this.load(is);
    }

    public PluginInfo fillPluginInfoObject(DownloadableInfo info) throws ManagerException {
        String[] AllCytoscapeVersions;
        PluginInfo pi;
        if (!this.expectedPropertiesPresent()) {
            throw new ManagerException("Required properties are missing from plugins.props file: " + this.errorMsg);
        }
        if (this.containsKey(PluginProperty.UNIQUE_ID.getPropertyKey())) {
            pi = new PluginInfo(this.getProperty(PluginProperty.UNIQUE_ID.getPropertyKey()));
            if (info != null) {
                pi.setObjectUrl(info.getObjectUrl());
                pi.setDownloadableURL(info.getDownloadableURL());
            }
        } else if (info != null) {
            CyLogger.getLogger().info(info.toString());
            pi = (PluginInfo)info;
            pi.clearAuthorList();
        } else {
            pi = new PluginInfo();
        }
        pi.setName(this.getProperty(PluginProperty.NAME.getPropertyKey()));
        try {
            pi.setObjectVersion(Double.valueOf(this.getProperty(PluginProperty.VERSION.getPropertyKey())));
        }
        catch (NumberFormatException ne) {
            CyLogger.getLogger().warn(pi.getName() + " version is incorrectly formatted, format is: \\d+.\\d+. Version set to 0.1 to allow plugin to load");
            pi.setObjectVersion(0.1);
        }
        pi.setDescription(this.getProperty(PluginProperty.DESCRIPTION.getPropertyKey()));
        pi.setCategory(this.getProperty(PluginProperty.CATEGORY.getPropertyKey()));
        if (this.containsKey(PluginProperty.PROJECT_URL.getPropertyKey())) {
            pi.setProjectUrl(this.getProperty(PluginProperty.PROJECT_URL.getPropertyKey()));
        }
        if (this.containsKey(PluginProperty.DOWNLOAD_URL.getPropertyKey())) {
            pi.setDownloadableURL(this.getProperty(PluginProperty.DOWNLOAD_URL.getPropertyKey()));
        }
        if (this.containsKey(PluginProperty.AUTHORS.getPropertyKey()) || this.containsKey("pluginAuthorsIntsitutions")) {
            String[] AuthInst;
            String AuthorProp = this.getProperty(PluginProperty.AUTHORS.getPropertyKey());
            if (AuthorProp == null) {
                AuthorProp = this.getProperty("pluginAuthorsIntsitutions");
            }
            for (String ai : AuthInst = AuthorProp.split(";")) {
                String[] CurrentAI = ai.split(":");
                if (CurrentAI.length != 2) {
                    CyLogger.getLogger().warn("Author line '" + ai + "' incorrectly formatted. Please enter authors as 'Name1, Name2 and Name3: Institution");
                    continue;
                }
                pi.addAuthor(CurrentAI[0], CurrentAI[1]);
            }
        }
        if (this.containsKey(PluginProperty.RELEASE_DATE.getPropertyKey())) {
            pi.setReleaseDate(this.getProperty(PluginProperty.RELEASE_DATE.getPropertyKey()));
        }
        for (String v : AllCytoscapeVersions = this.getProperty(PluginProperty.CYTOSCAPE_VERSION.getPropertyKey()).split(",")) {
            v = v.trim();
            pi.addCytoscapeVersion(v);
        }
        return pi;
    }

    private boolean expectedPropertiesPresent() {
        for (PluginProperty pp : PluginProperty.values()) {
            if (!pp.isRequired() || this.containsKey(pp.getPropertyKey())) continue;
            this.errorMsg = pp.getPropertyKey();
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PluginProperty {
        NAME("pluginName", true),
        DESCRIPTION("pluginDescription", true),
        VERSION("pluginVersion", true),
        CYTOSCAPE_VERSION("cytoscapeVersion", true),
        CATEGORY("pluginCategory", true),
        PROJECT_URL("projectURL", false),
        AUTHORS("pluginAuthorsInstitutions", false),
        RELEASE_DATE("releaseDate", false),
        UNIQUE_ID("uniqueID", false),
        DOWNLOAD_URL("downloadURL", false);

        private String propText;
        private boolean requiredProp;

        private PluginProperty(String prop, boolean required) {
            this.propText = prop;
            this.requiredProp = required;
        }

        public String toString() {
            return this.propText + ":" + this.requiredProp;
        }

        public String getPropertyKey() {
            return this.propText;
        }

        public boolean isRequired() {
            return this.requiredProp;
        }
    }
}

