/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.ImportHandler;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.GraphReader;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyFileFilter;
import java.net.URL;
import java.net.URLConnection;

public class GMLFileFilter
extends CyFileFilter {
    private static String fileNature = ImportHandler.GRAPH_NATURE;
    private static String fileExtension = "gml";
    private static String[] contentTypes = new String[]{"text/gml", "text/gml+xml"};
    private static String description = "GML files";

    public GMLFileFilter() {
        super(fileExtension, description, fileNature);
    }

    public GraphReader getReader(String fileName) {
        this.reader = new GMLReader(fileName);
        return this.reader;
    }

    public GraphReader getReader(URL url, URLConnection conn) {
        try {
            this.reader = new GMLReader(conn.getInputStream(), url.toString());
        }
        catch (Exception e) {
            CyLogger.getLogger(GMLFileFilter.class).error("Unable to get GML reader: " + e.getMessage());
            this.reader = null;
        }
        return this.reader;
    }
}

