/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MacAppConfig {
    private String configFile = "Cytoscape.app/Contents/Info.plist";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure() throws IOException, JDOMException {
        block3: {
            Document doc = this.getConfiguration();
            String[] files = this.getJarList();
            Element root = doc.getRootElement();
            Element dict = root.getChild("dict");
            dict = dict.getChild("dict");
            Element array = dict.getChild("JAR_ARRAY");
            array.setName("array");
            this.addJars(files, array);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            FileWriter writer = null;
            try {
                writer = new FileWriter(this.configFile);
                outputter.output(doc, (Writer)writer);
                Object var9_8 = null;
                if (writer == null) break block3;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            writer.close();
        }
        CyLogger.getLogger().info("File is now updated with correct JARs:  " + this.configFile);
    }

    private void addJars(String[] files, Element array) {
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (!file.endsWith("jar")) continue;
            Element jar = new Element("string");
            jar.setText("$JAVAROOT/" + file);
            array.addContent(jar);
            array.addContent("\n");
        }
    }

    private String[] getJarList() {
        File dir = new File("lib");
        String[] files = dir.list();
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document getConfiguration() throws IOException, JDOMException {
        Document doc = null;
        try {
            FileReader reader = null;
            try {
                reader = new FileReader(this.configFile);
                SAXBuilder saxBuilder = new SAXBuilder();
                doc = saxBuilder.build(reader, new File(this.configFile).toURI().toURL().toString());
                Object var5_5 = null;
                if (reader == null) return doc;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return doc;
        }
        catch (FileNotFoundException e) {
            CyLogger.getLogger().info("Cannot find:  " + this.configFile);
            CyLogger.getLogger().info("Try running:  'ant mac' first.");
            Cytoscape.exit(-1);
        }
        return doc;
    }

    public static void main(String[] args) throws Exception {
        MacAppConfig mac = new MacAppConfig();
        mac.configure();
    }
}

