/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.ImportHandler;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyFileFilter;
import java.net.URL;
import java.net.URLConnection;

public class SIFFileFilter
extends CyFileFilter {
    private static String fileNature = ImportHandler.GRAPH_NATURE;
    private static String fileExtension = "sif";
    private static String[] contentTypes = new String[]{"text/sif"};
    private static String description = "SIF files";

    public SIFFileFilter() {
        super(fileExtension, description, fileNature);
    }

    public GraphReader getReader(String fileName) {
        this.reader = new InteractionsReader(fileName);
        return this.reader;
    }

    public GraphReader getReader(URL url, URLConnection conn) {
        try {
            this.reader = new InteractionsReader(conn.getInputStream(), url.toString());
        }
        catch (Exception e) {
            CyLogger.getLogger(SIFFileFilter.class).error("Unable to get SIF reader: " + e.getMessage());
            this.reader = null;
        }
        return this.reader;
    }
}

